/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.envisage.EnvisageFrame;

public class Envisage {
    protected ApplicationDescriptor application;
    private EnvisageFrame mainFrame;

    public void run(ApplicationDescriptor application) {
        this.initLookAndFeel();
        this.application = application;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Envisage.this.showMainFrame();
            }
        });
    }

    public void stop() {
        if (this.mainFrame != null && this.mainFrame.isDisplayable()) {
            this.mainFrame.dispose();
            this.mainFrame = null;
        }
    }

    private void showMainFrame() {
        this.mainFrame = new EnvisageFrame(this.application);
        this.mainFrame.setLocationByPlatform(true);
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setSize(new Dimension(1024, 768));
        this.mainFrame.setVisible(true);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Envisage.this.mainFrame.initQi4J();
                    }
                });
            }
        });
    }

    private void initLookAndFeel() {
        String osName = System.getProperty("os.name").toUpperCase();
        System.setProperty("swing.aatext", "true");
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        LookAndFeel lnf = UIManager.getLookAndFeel();
        if (lnf != null && lnf.getID().equalsIgnoreCase("Metal")) {
            String lnfClassName;
            if (osName.startsWith("MAC")) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Envisage");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                lnfClassName = UIManager.getSystemLookAndFeelClassName();
            } else if (osName.startsWith("WINDOWS")) {
                UIManager.put("ClassLoader", LookUtils.class.getClassLoader());
                lnfClassName = Options.getSystemLookAndFeelClassName();
                Options.setUseNarrowButtons((boolean)false);
            } else {
                UIManager.put("ClassLoader", LookUtils.class.getClassLoader());
                lnfClassName = Options.getCrossPlatformLookAndFeelClassName();
                PlasticLookAndFeel.setTabStyle((String)"metal");
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                Options.setUseNarrowButtons((boolean)false);
            }
            if (lnfClassName != null) {
                try {
                    UIManager.setLookAndFeel(lnfClassName);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                    System.err.println("Unable to set LookAndFeel, use default LookAndFeel.\n" + ex.getMessage());
                }
            }
        }
    }
}

