/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.event.LinkListener;
import org.qi4j.envisage.graph.GraphPane;
import org.qi4j.envisage.print.PDFWriter;
import org.qi4j.envisage.tree.TreeModelPane;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptorBuilder;

public final class EnvisageFrame
extends JFrame {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(EnvisageFrame.class.getName());
    private JPanel contentPane;
    private final JSplitPane graphSplitPane;
    private final JSplitPane modelSplitPane;
    private final GraphPane graphPane;
    private final TreeModelPane treeModelPane;
    private final DetailModelPane detailModelPane;
    private final ApplicationDescriptor application;
    private ApplicationDetailDescriptor descriptor;
    private boolean graphItemSelectionInProgress;

    public EnvisageFrame(ApplicationDescriptor application) {
        this.$$$setupUI$$$();
        this.application = application;
        this.setTitle(BUNDLE.getString("Application.Title"));
        this.setContentPane(this.contentPane);
        this.graphPane = new GraphPane();
        this.treeModelPane = new TreeModelPane();
        this.detailModelPane = new DetailModelPane();
        this.treeModelPane.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                EnvisageFrame.this.applicationModelPaneValueChanged();
            }
        });
        this.graphPane.addLinkListener(new LinkListener(){

            @Override
            public void activated(LinkEvent evt) {
                EnvisageFrame.this.graphItemLinkActivated(evt);
            }
        });
        this.detailModelPane.addLinkListener(new LinkListener(){

            @Override
            public void activated(LinkEvent evt) {
                EnvisageFrame.this.detailModelPaneLinkActivated(evt);
            }
        });
        this.modelSplitPane = new JSplitPane();
        this.modelSplitPane.setOrientation(1);
        this.modelSplitPane.setDividerLocation(300);
        this.modelSplitPane.setOneTouchExpandable(true);
        this.modelSplitPane.setLeftComponent(this.treeModelPane);
        this.modelSplitPane.setRightComponent(this.detailModelPane);
        this.graphSplitPane = new JSplitPane();
        this.graphSplitPane.setOrientation(0);
        this.graphSplitPane.setDividerLocation(384);
        this.graphSplitPane.setOneTouchExpandable(true);
        this.graphSplitPane.setTopComponent(this.modelSplitPane);
        this.graphSplitPane.setBottomComponent(this.graphPane);
        this.setJMenuBar(this.createMenu());
        this.contentPane.add((Component)this.graphSplitPane, "Center");
    }

    public void initQi4J() {
        this.modelSplitPane.setDividerLocation(300);
        this.graphSplitPane.setDividerLocation(384);
        this.descriptor = ApplicationDetailDescriptorBuilder.createApplicationDetailDescriptor((ApplicationDescriptor)this.application);
        this.treeModelPane.initQi4J(this.descriptor);
        this.graphPane.initQi4J(this.descriptor);
    }

    protected JMenuBar createMenu() {
        ActionListener menuActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("export")) {
                    EnvisageFrame.this.exportAsPDF();
                }
                if (evt.getActionCommand().equals("exit")) {
                    System.exit(0);
                }
            }
        };
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Export As PDF", 69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        menuItem.setActionCommand("export");
        menuItem.addActionListener(menuActionListener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Exit", 88);
        menuItem.setActionCommand("exit");
        menuItem.addActionListener(menuActionListener);
        menu.add(menuItem);
        return menuBar;
    }

    protected void applicationModelPaneValueChanged() {
        Object obj = this.treeModelPane.getLastSelected();
        this.detailModelPane.setDescriptor(obj);
        if (!this.graphItemSelectionInProgress) {
            this.graphPane.setSelectedValue(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void graphItemLinkActivated(LinkEvent evt) {
        this.graphItemSelectionInProgress = true;
        try {
            this.treeModelPane.setSelectedValue(evt.getObject());
        }
        finally {
            this.graphItemSelectionInProgress = false;
        }
    }

    protected void detailModelPaneLinkActivated(LinkEvent evt) {
        this.treeModelPane.setSelectedValue(evt.getObject());
    }

    protected void exportAsPDF() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PDFWriter pdf = new PDFWriter();
                pdf.write(EnvisageFrame.this, EnvisageFrame.this.descriptor, EnvisageFrame.this.graphPane.getGraphDisplays());
            }
        });
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

