/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.qi4j.api.composite.DependencyDescriptor;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.util.Classes;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.detail.DetailPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.InjectedFieldDetailDescriptor;
import org.qi4j.tools.model.descriptor.MixinDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;

final class DependencyPane
extends DetailPane {
    private JPanel contentPane;
    private JSplitPane splitPane;
    private JList fieldList;
    private JLabel classNameLabel;
    private JLabel optionalLabel;
    private JLabel annotationLabel;
    private JLabel injectionTypeLabel;
    private JList injectedServiceList;
    private JPanel detailPane;
    private final DefaultListModel fieldListModel;
    private DefaultListModel injectedServiceListModel;
    private Cursor defaultCursor;
    private Cursor linkCursor;

    DependencyPane(DetailModelPane detailModelPane) {
        super(detailModelPane);
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.fieldListModel = new DefaultListModel();
        this.fieldList.setModel(this.fieldListModel);
        this.fieldList.setSelectionMode(0);
        this.fieldList.setPrototypeCellValue("123456789012345");
        this.injectedServiceListModel = new DefaultListModel();
        this.injectedServiceList.setModel(this.injectedServiceListModel);
        this.injectedServiceList.setCellRenderer(new InjectedServiceListCellRenderer());
        this.injectedServiceList.setSelectionMode(0);
        this.injectedServiceList.setPrototypeCellValue("123456789012345");
        Dimension minSize = new Dimension(20, 20);
        this.detailPane.setMinimumSize(minSize);
        this.fieldList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DependencyPane.this.fieldListValueChanged(evt);
            }
        });
        this.defaultCursor = this.getCursor();
        this.linkCursor = LinkEvent.LINK_CURSOR;
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int i = DependencyPane.this.injectedServiceList.locationToIndex(evt.getPoint());
                if (i != -1) {
                    DependencyPane.this.setCursor(DependencyPane.this.linkCursor);
                } else {
                    DependencyPane.this.setCursor(DependencyPane.this.defaultCursor);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DependencyPane.this.setCursor(DependencyPane.this.defaultCursor);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int i = DependencyPane.this.injectedServiceList.locationToIndex(evt.getPoint());
                if (i != -1) {
                    Object linkObject = DependencyPane.this.injectedServiceListModel.get(i);
                    DependencyPane.this.linkActivated(linkObject);
                }
            }
        };
        this.injectedServiceList.addMouseListener(mouseInputListener);
        this.injectedServiceList.addMouseMotionListener(mouseInputListener);
    }

    private void linkActivated(Object linkObject) {
        if (linkObject == null) {
            return;
        }
        LinkEvent linkEvt = new LinkEvent(this, linkObject);
        this.detailModelPane.fireLinkActivated(linkEvt);
    }

    private void clear() {
        this.fieldListModel.clear();
        this.clearDetail();
    }

    private void clearDetail() {
        this.classNameLabel.setText(null);
        this.classNameLabel.setToolTipText(null);
        this.optionalLabel.setText(null);
        this.annotationLabel.setText(null);
        this.injectionTypeLabel.setText(null);
        this.injectionTypeLabel.setToolTipText(null);
        this.injectedServiceListModel.clear();
    }

    @Override
    protected void setDescriptor(Object objectDesciptor) {
        this.clear();
        if (objectDesciptor instanceof CompositeDetailDescriptor) {
            CompositeDetailDescriptor descriptor = (CompositeDetailDescriptor)objectDesciptor;
            Iterable iter = descriptor.mixins();
            for (MixinDetailDescriptor mixinDescriptor : iter) {
                this.reload(mixinDescriptor.injectedFields());
            }
        } else if (objectDesciptor instanceof ObjectDetailDescriptor) {
            ObjectDetailDescriptor descriptor = (ObjectDetailDescriptor)objectDesciptor;
            this.reload(descriptor.injectedFields());
        }
        if (!this.fieldListModel.isEmpty()) {
            this.fieldList.setSelectedIndex(0);
        }
    }

    private void reload(Iterable<InjectedFieldDetailDescriptor> iter) {
        for (InjectedFieldDetailDescriptor descriptor : iter) {
            DependencyDescriptor dependencyDescriptor = descriptor.descriptor().dependency();
            Annotation annotation = dependencyDescriptor.injectionAnnotation();
            if (!this.isDependencyField(annotation.annotationType())) continue;
            this.fieldListModel.addElement(descriptor);
        }
    }

    private void reloadDetail(InjectedFieldDetailDescriptor descriptor) {
        this.clearDetail();
        if (descriptor == null) {
            return;
        }
        DependencyDescriptor dependencyDescriptor = descriptor.descriptor().dependency();
        this.classNameLabel.setText(dependencyDescriptor.injectedClass().getSimpleName());
        this.classNameLabel.setToolTipText(dependencyDescriptor.injectedClass().getName());
        this.annotationLabel.setText("@" + dependencyDescriptor.injectionAnnotation().annotationType().getSimpleName());
        this.optionalLabel.setText(Boolean.toString(dependencyDescriptor.optional()));
        this.injectionTypeLabel.setText(Classes.simpleGenericNameOf((Type)dependencyDescriptor.injectionType()));
        this.injectionTypeLabel.setToolTipText(dependencyDescriptor.injectionType().toString());
    }

    private boolean isDependencyField(Class<? extends Annotation> clazz) {
        return Uses.class.equals(clazz) || Service.class.equals(clazz);
    }

    private void fieldListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.reloadDetail((InjectedFieldDetailDescriptor)this.fieldList.getSelectedValue());
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.splitPane = new JSplitPane();
        this.contentPane.add((Component)this.splitPane, "Center");
        JScrollPane scrollPane1 = new JScrollPane();
        this.splitPane.setLeftComponent(scrollPane1);
        this.fieldList = new JList();
        scrollPane1.setViewportView(this.fieldList);
        this.detailPane = new JPanel();
        this.detailPane.setLayout(new GridBagLayout());
        this.splitPane.setRightComponent(this.detailPane);
        this.detailPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), null));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("org/qi4j/envisage/detail/DependencyPane").getString("CTL_ClassName.Text"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        this.detailPane.add((Component)label1, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.detailPane.add((Component)spacer1, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.detailPane.add((Component)spacer2, gbc);
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("org/qi4j/envisage/detail/DependencyPane").getString("CTL_Optional.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        this.detailPane.add((Component)label2, gbc);
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("org/qi4j/envisage/detail/DependencyPane").getString("CTL_Annotation.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 13;
        this.detailPane.add((Component)label3, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 3;
        this.detailPane.add((Component)spacer3, gbc);
        JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.fill = 3;
        this.detailPane.add((Component)spacer4, gbc);
        JPanel spacer5 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.fill = 3;
        this.detailPane.add((Component)spacer5, gbc);
        JLabel label4 = new JLabel();
        this.$$$loadLabelText$$$(label4, ResourceBundle.getBundle("org/qi4j/envisage/detail/DependencyPane").getString("CTL_InjectionType.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.anchor = 13;
        this.detailPane.add((Component)label4, gbc);
        this.classNameLabel = new JLabel();
        this.classNameLabel.setText("none");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.detailPane.add((Component)this.classNameLabel, gbc);
        this.annotationLabel = new JLabel();
        this.annotationLabel.setText("none");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        this.detailPane.add((Component)this.annotationLabel, gbc);
        this.injectionTypeLabel = new JLabel();
        this.injectionTypeLabel.setText("none");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 10;
        gbc.anchor = 17;
        this.detailPane.add((Component)this.injectionTypeLabel, gbc);
        this.optionalLabel = new JLabel();
        this.optionalLabel.setText("none");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.detailPane.add((Component)this.optionalLabel, gbc);
        JPanel spacer6 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.fill = 3;
        this.detailPane.add((Component)spacer6, gbc);
        JLabel label5 = new JLabel();
        this.$$$loadLabelText$$$(label5, ResourceBundle.getBundle("org/qi4j/envisage/detail/DependencyPane").getString("CTL_Injection.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.anchor = 17;
        this.detailPane.add((Component)label5, gbc);
        JScrollPane scrollPane2 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 12;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.detailPane.add((Component)scrollPane2, gbc);
        this.injectedServiceList = new JList();
        scrollPane2.setViewportView(this.injectedServiceList);
        JPanel spacer7 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.fill = 3;
        this.detailPane.add((Component)spacer7, gbc);
        JLabel label6 = new JLabel();
        this.$$$loadLabelText$$$(label6, ResourceBundle.getBundle("org/qi4j/envisage/detail/DependencyPane").getString("CTL_InjectedServices.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 12;
        gbc.anchor = 12;
        this.detailPane.add((Component)label6, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        this.detailPane.add((Component)separator1, gbc);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static class InjectedServiceListCellRenderer
    extends DefaultListCellRenderer {
        private InjectedServiceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                String id = (String)value;
                value = "<html><a href=\"" + id + "\">" + id + "</a></html>";
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return this;
        }
    }
}

