/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.detail.DetailPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.util.TableRow;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorUtilities;

final class SPIPane
extends DetailPane {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(SPIPane.class.getName());
    private JPanel contentPane;
    private JTable spiTable;
    private SPITableModel spiTableModel;
    private Object linkObject;
    private Cursor defaultCursor;
    private Cursor linkCursor;

    SPIPane(DetailModelPane detailModelPane) {
        super(detailModelPane);
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.spiTableModel = new SPITableModel();
        this.spiTable.setModel(this.spiTableModel);
        this.spiTable.setSelectionMode(0);
        TableColumnModel columnModel = this.spiTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new DependencyCellRenderer());
        this.defaultCursor = this.getCursor();
        this.linkCursor = LinkEvent.LINK_CURSOR;
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int col = SPIPane.this.spiTable.columnAtPoint(evt.getPoint());
                if (col == 0) {
                    SPIPane.this.setCursor(SPIPane.this.linkCursor);
                } else if (!SPIPane.this.getCursor().equals(SPIPane.this.defaultCursor)) {
                    SPIPane.this.setCursor(SPIPane.this.defaultCursor);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int col = SPIPane.this.spiTable.columnAtPoint(evt.getPoint());
                if (col != 0) {
                    return;
                }
                int row = SPIPane.this.spiTable.rowAtPoint(evt.getPoint());
                if (row < 0) {
                    return;
                }
                SPIPane.this.linkObject = SPIPane.this.spiTable.getValueAt(row, col);
                SPIPane.this.linkActivated();
                SPIPane.this.linkObject = null;
            }
        };
        this.spiTable.addMouseMotionListener(mouseInputListener);
        this.spiTable.addMouseListener(mouseInputListener);
    }

    @Override
    protected void setDescriptor(Object objectDesciptor) {
        this.clear();
        List list = null;
        if (objectDesciptor instanceof LayerDetailDescriptor) {
            list = DescriptorUtilities.findLayerSPI((LayerDetailDescriptor)((LayerDetailDescriptor)objectDesciptor));
        } else if (objectDesciptor instanceof ModuleDetailDescriptor) {
            list = DescriptorUtilities.findModule((ModuleDetailDescriptor)((ModuleDetailDescriptor)objectDesciptor));
        }
        if (list != null) {
            this.spiTableModel.addRow(list);
        }
    }

    private void clear() {
        this.linkObject = null;
        this.spiTableModel.clear();
    }

    private void linkActivated() {
        if (this.linkObject == null) {
            return;
        }
        LinkEvent linkEvt = new LinkEvent(this, this.linkObject);
        this.detailModelPane.fireLinkActivated(linkEvt);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane1, "Center");
        this.spiTable = new JTable();
        scrollPane1.setViewportView(this.spiTable);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static /* synthetic */ ResourceBundle access$900() {
        return BUNDLE;
    }

    private static class DependencyCellRenderer
    extends DefaultTableCellRenderer {
        private DependencyCellRenderer() {
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = "<html><a href=\"" + value.toString() + "\">" + value.toString() + "</a></html>";
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }

    private static class SPITableModel
    extends AbstractTableModel {
        private static final String[] COLUMN_NAMES = new String[]{SPIPane.access$900().getString("Dependency.Column"), SPIPane.access$900().getString("Module.Column"), SPIPane.access$900().getString("Layer.Column")};
        private final ArrayList<TableRow> rows = new ArrayList();

        private SPITableModel() {
        }

        private void addRow(List<ServiceDetailDescriptor> list) {
            if (list.isEmpty()) {
                return;
            }
            int i1 = this.rows.size();
            if (i1 > 0) {
                --i1;
            }
            int i2 = 0;
            for (ServiceDetailDescriptor descriptor : list) {
                TableRow row = new TableRow(COLUMN_NAMES.length);
                row.set(0, descriptor);
                row.set(1, descriptor.module());
                row.set(2, descriptor.module().layer());
                this.rows.add(row);
                ++i2;
            }
            this.fireTableRowsInserted(i1, i1 + i2);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableRow row = this.rows.get(rowIndex);
            return row.get(columnIndex);
        }

        private void clear() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }
    }
}

