/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.qi4j.api.composite.DependencyDescriptor;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.detail.DetailPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.util.TableRow;
import org.qi4j.envisage.util.TableRowUtilities;
import org.qi4j.tools.model.descriptor.InjectedFieldDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorUtilities;

final class ServiceUsagePane
extends DetailPane {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(ServiceUsagePane.class.getName());
    private UsageTableModel usageTableModel;
    private JTable usageTable;
    private JPanel contentPane;
    private Object linkObject;
    private Cursor defaultCursor;
    private Cursor linkCursor;

    ServiceUsagePane(DetailModelPane detailModelPane) {
        super(detailModelPane);
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.usageTableModel = new UsageTableModel();
        this.usageTable.setModel(this.usageTableModel);
        this.usageTable.setSelectionMode(0);
        TableColumnModel columnModel = this.usageTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new OwnerCellRenderer());
        columnModel.getColumn(1).setCellRenderer(new FieldCellRenderer());
        this.defaultCursor = this.getCursor();
        this.linkCursor = LinkEvent.LINK_CURSOR;
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int col = ServiceUsagePane.this.usageTable.columnAtPoint(evt.getPoint());
                if (col == 0) {
                    ServiceUsagePane.this.setCursor(ServiceUsagePane.this.linkCursor);
                } else if (!ServiceUsagePane.this.getCursor().equals(ServiceUsagePane.this.defaultCursor)) {
                    ServiceUsagePane.this.setCursor(ServiceUsagePane.this.defaultCursor);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int col = ServiceUsagePane.this.usageTable.columnAtPoint(evt.getPoint());
                if (col != 0) {
                    return;
                }
                int row = ServiceUsagePane.this.usageTable.rowAtPoint(evt.getPoint());
                if (row < 0) {
                    return;
                }
                ServiceUsagePane.this.linkObject = ServiceUsagePane.this.usageTableModel.getValueAt(row, col);
                ServiceUsagePane.this.linkActivated();
                ServiceUsagePane.this.linkObject = null;
            }
        };
        this.usageTable.addMouseMotionListener(mouseInputListener);
        this.usageTable.addMouseListener(mouseInputListener);
    }

    private void linkActivated() {
        if (this.linkObject == null) {
            return;
        }
        LinkEvent linkEvt = new LinkEvent(this, this.linkObject);
        this.detailModelPane.fireLinkActivated(linkEvt);
    }

    @Override
    protected void setDescriptor(Object objectDesciptor) {
        this.clear();
        if (!(objectDesciptor instanceof ServiceDetailDescriptor)) {
            return;
        }
        ServiceDetailDescriptor descriptor = (ServiceDetailDescriptor)objectDesciptor;
        List serviceUsages = DescriptorUtilities.findServiceUsage((ServiceDetailDescriptor)descriptor);
        this.usageTableModel.addRows(TableRowUtilities.toTableRows(serviceUsages));
    }

    private void clear() {
        this.linkObject = null;
        this.usageTableModel.clear();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane1, "Center");
        this.usageTable = new JTable();
        scrollPane1.setViewportView(this.usageTable);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static /* synthetic */ ResourceBundle access$1100() {
        return BUNDLE;
    }

    private static class FieldCellRenderer
    extends DefaultTableCellRenderer {
        private FieldCellRenderer() {
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                InjectedFieldDetailDescriptor descriptor = (InjectedFieldDetailDescriptor)value;
                DependencyDescriptor dependencyDescriptor = descriptor.descriptor().dependency();
                Annotation annotation = dependencyDescriptor.injectionAnnotation();
                value = descriptor.toString() + " (@" + annotation.annotationType().getSimpleName() + ")";
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class OwnerCellRenderer
    extends DefaultTableCellRenderer {
        private OwnerCellRenderer() {
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = "<html><a href=\"" + value.toString() + "\">" + value.toString() + "</a></html>";
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }

    private static class UsageTableModel
    extends AbstractTableModel {
        private static final String[] COLUMN_NAMES = new String[]{ServiceUsagePane.access$1100().getString("Owner.Column"), ServiceUsagePane.access$1100().getString("Usage.Column"), ServiceUsagePane.access$1100().getString("Module.Column"), ServiceUsagePane.access$1100().getString("Layer.Column")};
        private final ArrayList<TableRow> rows = new ArrayList();

        private UsageTableModel() {
        }

        private void addRows(List<TableRow> rows) {
            int i1 = rows.size();
            if (i1 > 0) {
                --i1;
            }
            int i2 = 0;
            for (TableRow row : rows) {
                this.rows.add(row);
                ++i2;
            }
            this.fireTableRowsInserted(i1, i1 + i2);
        }

        private void addRow(TableRow row) {
            int i1 = this.rows.size();
            if (i1 > 0) {
                --i1;
            }
            this.rows.add(row);
            this.fireTableRowsInserted(i1, i1 + 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableRow row = this.rows.get(rowIndex);
            return row.get(columnIndex);
        }

        private void clear() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }
    }
}

