/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.GenericAssociationInfo;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Property;
import org.qi4j.api.util.Classes;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.detail.DetailPane;
import org.qi4j.envisage.util.TableRow;
import org.qi4j.functional.Iterables;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeMethodDetailDescriptor;
import org.qi4j.tools.model.descriptor.MethodConcernDetailDescriptor;
import org.qi4j.tools.model.descriptor.MethodSideEffectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorUtilities;

final class StatePane
extends DetailPane {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(StatePane.class.getName());
    private JPanel contentPane;
    private JList methodList;
    private JSplitPane splitPane;
    private JTable methodDetailTable;
    private final DefaultListModel methodListModel;
    private final MethodDetailTableModel methodDetailTableModel;

    StatePane(DetailModelPane detailModelPane) {
        super(detailModelPane);
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.methodListModel = new DefaultListModel();
        this.methodList.setModel(this.methodListModel);
        this.methodList.setCellRenderer(new MethodListCellRenderer());
        this.methodList.setPrototypeCellValue("12345678901234567890");
        this.methodList.setSelectionMode(0);
        this.methodDetailTableModel = new MethodDetailTableModel();
        this.methodDetailTable.setModel(this.methodDetailTableModel);
        TableColumnModel columnModel = this.methodDetailTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(75);
        columnModel.getColumn(1).setPreferredWidth(400);
        this.methodList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                StatePane.this.methodListValueChanged(evt);
            }
        });
    }

    @Override
    protected void setDescriptor(Object objectDesciptor) {
        this.clear();
        if (objectDesciptor instanceof CompositeDetailDescriptor) {
            CompositeDetailDescriptor descriptor = (CompositeDetailDescriptor)objectDesciptor;
            List list = DescriptorUtilities.findState((CompositeDetailDescriptor)descriptor);
            for (CompositeMethodDetailDescriptor methodDescriptor : list) {
                this.methodListModel.addElement(methodDescriptor);
            }
            if (!this.methodListModel.isEmpty()) {
                this.methodList.setSelectedIndex(0);
            }
        } else if (objectDesciptor instanceof ObjectDetailDescriptor) {
            // empty if block
        }
    }

    private void clear() {
        this.methodListModel.clear();
        this.methodDetailTableModel.clear();
    }

    private void methodListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        Object obj = this.methodList.getSelectedValue();
        if (obj == null) {
            this.methodDetailTableModel.clear();
            return;
        }
        this.methodDetailTableModel.reload((CompositeMethodDetailDescriptor)obj);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.splitPane = new JSplitPane();
        this.contentPane.add((Component)this.splitPane, "Center");
        JScrollPane scrollPane1 = new JScrollPane();
        this.splitPane.setLeftComponent(scrollPane1);
        this.methodList = new JList();
        scrollPane1.setViewportView(this.methodList);
        JScrollPane scrollPane2 = new JScrollPane();
        this.splitPane.setRightComponent(scrollPane2);
        this.methodDetailTable = new JTable();
        scrollPane2.setViewportView(this.methodDetailTable);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static class MethodListCellRenderer
    extends DefaultListCellRenderer {
        private final Icon publicIcon;
        private final Icon privateIcon;

        private MethodListCellRenderer() {
            try {
                this.publicIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Public")));
                this.privateIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Private")));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Type t;
            Method method;
            Class<?> methodReturnType;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof CompositeMethodDetailDescriptor)) {
                return this;
            }
            CompositeMethodDetailDescriptor descriptor = (CompositeMethodDetailDescriptor)value;
            Class compositeClass = (Class)Iterables.first((Iterable)descriptor.composite().descriptor().types());
            Class<?> mixinMethodClass = descriptor.descriptor().method().getDeclaringClass();
            Icon icon = mixinMethodClass.isAssignableFrom(compositeClass) ? this.publicIcon : this.privateIcon;
            if (icon != null) {
                this.setIcon(icon);
            }
            if (Property.class.isAssignableFrom(methodReturnType = (method = descriptor.descriptor().method()).getReturnType())) {
                Type t2 = GenericPropertyInfo.propertyTypeOf((AccessibleObject)method);
                if (t2 instanceof Class) {
                    this.setText(method.getName() + ":" + ((Class)t2).getSimpleName());
                }
            } else if (Association.class.isAssignableFrom(methodReturnType)) {
                Type t3 = GenericAssociationInfo.associationTypeOf((AccessibleObject)method);
                if (t3 instanceof Class) {
                    this.setText(method.getName() + "->" + ((Class)t3).getSimpleName());
                }
            } else if (ManyAssociation.class.isAssignableFrom(methodReturnType)) {
                Type t4 = GenericAssociationInfo.associationTypeOf((AccessibleObject)method);
                if (t4 instanceof Class) {
                    this.setText(method.getName() + "=>" + ((Class)t4).getSimpleName());
                }
            } else if (NamedAssociation.class.isAssignableFrom(methodReturnType) && (t = GenericAssociationInfo.associationTypeOf((AccessibleObject)method)) instanceof Class) {
                this.setText(method.getName() + ">>" + ((Class)t).getSimpleName());
            }
            return this;
        }
    }

    private static class MethodDetailTableModel
    extends AbstractTableModel {
        private static final String[] COLUMN_NAMES = new String[]{"Name", "Value"};
        private final ArrayList<TableRow> rows = new ArrayList();

        private MethodDetailTableModel() {
        }

        private void reload(CompositeMethodDetailDescriptor descriptor) {
            this.clear();
            this.rows.add(new TableRow(2, "interface", descriptor.descriptor().method().getDeclaringClass().getSimpleName()));
            StringBuilder str = new StringBuilder();
            for (Annotation annotation : descriptor.descriptor().method().getAnnotations()) {
                String ann = annotation.toString();
                ann = "@" + ann.substring(ann.lastIndexOf(46) + 1);
                str.append(ann).append(" ");
            }
            str.append(Classes.simpleGenericNameOf((Type)descriptor.descriptor().method().getGenericReturnType()));
            this.rows.add(new TableRow(2, "return", str.toString()));
            boolean first = true;
            for (MethodConcernDetailDescriptor concern : descriptor.concerns().concerns()) {
                if (first) {
                    this.rows.add(new TableRow(2, "concern", concern.toString()));
                    first = false;
                    continue;
                }
                this.rows.add(new TableRow(2, "", concern.toString()));
            }
            first = false;
            for (MethodSideEffectDetailDescriptor sideEffect : descriptor.sideEffects().sideEffects()) {
                if (first) {
                    this.rows.add(new TableRow(2, "sideEffect", sideEffect.toString()));
                    first = false;
                    continue;
                }
                this.rows.add(new TableRow(2, "", sideEffect.toString()));
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableRow row = this.rows.get(rowIndex);
            return row.get(columnIndex);
        }

        private void clear() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }
    }
}

