/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qi4j.api.composite.TransientDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceCompositeDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorNameComparator;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;

final class GraphBuilder {
    private final DescriptorNameComparator<Object> nameComparator = new DescriptorNameComparator();
    private final Graph graph = new Graph(true);
    private final List childList;

    static Graph buildGraph(ApplicationDetailDescriptor descriptor) {
        GraphBuilder builder = new GraphBuilder();
        return builder.buildApplicationNode(descriptor);
    }

    GraphBuilder() {
        Table nodeTable = this.graph.getNodeTable();
        nodeTable.addColumn("name", String.class);
        nodeTable.addColumn("userObject", Object.class);
        Table edgeTable = this.graph.getEdgeTable();
        edgeTable.addColumn("uses.edges", Boolean.TYPE, (Object)false);
        this.childList = new ArrayList();
    }

    private Graph buildApplicationNode(ApplicationDetailDescriptor descriptor) {
        Node node = this.addChild(null, descriptor.descriptor().name(), descriptor);
        this.buildLayersNode(node, descriptor.layers());
        this.buildUsesNode(node, descriptor.layers());
        return this.graph;
    }

    private void buildUsesNode(Node parent, Iterable<LayerDetailDescriptor> iter) {
        for (LayerDetailDescriptor descriptor : iter) {
            Node source = this.findNode(parent, descriptor);
            for (LayerDetailDescriptor usesDescriptor : descriptor.usedLayers()) {
                Node target = this.findNode(parent, usesDescriptor);
                if (target == null) continue;
                Edge edge = this.graph.addEdge(source, target);
                edge.setBoolean("uses.edges", true);
            }
        }
    }

    private Node findNode(Node parent, Object userObject) {
        Node node = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node tNode = parent.getChild(i);
            Object obj = tNode.get("userObject");
            if (!obj.equals(userObject)) continue;
            node = tNode;
            break;
        }
        return node;
    }

    private Node addChild(Node parent, String name, Object object) {
        Node childNode = this.graph.addNode();
        childNode.set("name", (Object)name);
        childNode.set("userObject", object);
        if (parent != null) {
            this.graph.addEdge(parent, childNode);
        }
        return childNode;
    }

    private void buildLayersNode(Node parent, Iterable<LayerDetailDescriptor> iter) {
        for (LayerDetailDescriptor descriptor : iter) {
            Node childNode = this.addChild(parent, descriptor.descriptor().name(), descriptor);
            this.buildModulesNode(childNode, descriptor.modules());
        }
    }

    private void buildModulesNode(Node parent, Iterable<ModuleDetailDescriptor> iter) {
        for (ModuleDetailDescriptor descriptor : iter) {
            Node childNode = this.addChild(parent, descriptor.descriptor().name(), descriptor);
            this.buildServicesNode(childNode, descriptor.services());
            this.buildImportedServicesNode(childNode, descriptor.importedServices());
            this.buildEntitiesNode(childNode, descriptor.entities());
            this.buildTransientsNode(childNode, descriptor.transients());
            this.buildValuesNode(childNode, descriptor.values());
            this.buildObjectsNode(childNode, descriptor.objects());
        }
    }

    private void sortTypeChildren(Iterable iter) {
        this.childList.clear();
        for (Object obj : iter) {
            this.childList.add(obj);
        }
        Collections.sort(this.childList, this.nameComparator);
    }

    private void buildServicesNode(Node parent, Iterable<ServiceDetailDescriptor> iter) {
        this.sortTypeChildren(iter);
        boolean first = true;
        for (Object obj : this.childList) {
            ServiceDetailDescriptor descriptor = (ServiceDetailDescriptor)obj;
            if (first) {
                String name = "Services";
                parent = this.addChild(parent, name, name);
                first = false;
            }
            this.addChild(parent, ((ServiceDescriptor)descriptor.descriptor()).toString(), descriptor);
        }
    }

    private void buildImportedServicesNode(Node parent, Iterable<ImportedServiceDetailDescriptor> iter) {
        this.sortTypeChildren(iter);
        boolean first = true;
        for (Object obj : this.childList) {
            ImportedServiceDetailDescriptor descriptor = (ImportedServiceDetailDescriptor)obj;
            if (first) {
                String name = "Imported Services";
                parent = this.addChild(parent, name, name);
                first = false;
            }
            this.addChild(parent, ((ImportedServiceCompositeDescriptor)descriptor.descriptor()).primaryType().getSimpleName(), descriptor);
        }
    }

    private void buildEntitiesNode(Node parent, Iterable<EntityDetailDescriptor> iter) {
        this.sortTypeChildren(iter);
        boolean first = true;
        for (Object obj : this.childList) {
            EntityDetailDescriptor descriptor = (EntityDetailDescriptor)obj;
            if (first) {
                String name = "Entities";
                parent = this.addChild(parent, name, name);
                first = false;
            }
            this.addChild(parent, ((EntityDescriptor)descriptor.descriptor()).toString(), descriptor);
        }
    }

    private void buildTransientsNode(Node parent, Iterable<TransientDetailDescriptor> iter) {
        this.sortTypeChildren(iter);
        boolean first = true;
        for (Object obj : this.childList) {
            TransientDetailDescriptor descriptor = (TransientDetailDescriptor)obj;
            if (first) {
                String name = "Transients";
                parent = this.addChild(parent, name, name);
                first = false;
            }
            this.addChild(parent, ((TransientDescriptor)descriptor.descriptor()).toString(), descriptor);
        }
    }

    private void buildValuesNode(Node parent, Iterable<ValueDetailDescriptor> iter) {
        this.sortTypeChildren(iter);
        boolean first = true;
        for (Object obj : this.childList) {
            ValueDetailDescriptor descriptor = (ValueDetailDescriptor)obj;
            if (first) {
                String name = "Values";
                parent = this.addChild(parent, name, name);
                first = false;
            }
            this.addChild(parent, ((ValueDescriptor)descriptor.descriptor()).toString(), descriptor);
        }
    }

    private void buildObjectsNode(Node parent, Iterable<ObjectDetailDescriptor> iter) {
        this.sortTypeChildren(iter);
        boolean first = true;
        for (Object obj : this.childList) {
            ObjectDetailDescriptor descriptor = (ObjectDetailDescriptor)obj;
            if (first) {
                String name = "Objects";
                parent = this.addChild(parent, name, name);
                first = false;
            }
            this.addChild(parent, descriptor.descriptor().toString(), descriptor);
        }
    }
}

