/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.graph;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.graph.GraphDisplay;
import org.qi4j.envisage.graph.StackedLayout;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.Layout;
import prefuse.activity.Activity;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.TupleSet;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.ColorMap;
import prefuse.util.FontLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.DecoratorItem;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

class StackedGraphDisplay
extends GraphDisplay {
    static final Font FONT = FontLib.getFont((String)"Tahoma", (double)12.0);
    private static final Schema LABEL_SCHEMA = PrefuseLib.getVisualItemSchema();
    private static final String LABELS = "labels";
    private static final String LAYOUT_ACTION = "layout";
    private static final String COLORS_ACTION = "colors";
    private static final String AUTO_PAN_ACTION = "autoPan";
    private static int OUTLINE_COLOR;
    private static int OUTLINE_FOCUS_COLOR;
    private StackedLayout stackedLayout;
    private Activity activity;

    StackedGraphDisplay() {
        super(new Visualization());
        this.setBackground(ColorLib.getColor((int)0, (int)51, (int)88));
        LabelRenderer labelRenderer = new LabelRenderer("name");
        labelRenderer.setVerticalAlignment(3);
        labelRenderer.setHorizontalAlignment(0);
        EdgeRenderer usesRenderer = new EdgeRenderer(1, 1);
        usesRenderer.setHorizontalAlignment1(2);
        usesRenderer.setHorizontalAlignment2(2);
        usesRenderer.setVerticalAlignment1(3);
        usesRenderer.setVerticalAlignment2(4);
        Predicate usesPredicate = (Predicate)ExpressionParser.parse((String)"ingroup('graph.edges') AND [uses.edges]==true", (boolean)true);
        DefaultRendererFactory rf = new DefaultRendererFactory();
        rf.add((Predicate)new InGroupPredicate("graph.nodes"), (Renderer)new NodeRenderer());
        rf.add((Predicate)new InGroupPredicate(LABELS), (Renderer)labelRenderer);
        rf.add(usesPredicate, (Renderer)usesRenderer);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        BorderColorAction borderColor = new BorderColorAction("graph.nodes");
        FillColorAction fillColor = new FillColorAction("graph.nodes");
        ColorAction usesColor = new ColorAction("graph.edges", usesPredicate, VisualItem.STROKECOLOR, ColorLib.rgb((int)50, (int)50, (int)50));
        ColorAction usesArrow = new ColorAction("graph.edges", usesPredicate, VisualItem.FILLCOLOR, ColorLib.rgb((int)50, (int)50, (int)50));
        ActionList colors = new ActionList();
        colors.add((Action)fillColor);
        colors.add((Action)borderColor);
        colors.add((Action)usesColor);
        colors.add((Action)usesArrow);
        this.m_vis.putAction(COLORS_ACTION, (Action)colors);
        ActionList autoPan = new ActionList();
        autoPan.add((Action)colors);
        autoPan.add((Action)new AutoPanAction());
        autoPan.add((Action)new RepaintAction());
        this.m_vis.putAction(AUTO_PAN_ACTION, (Action)autoPan);
        this.stackedLayout = new StackedLayout("graph");
        ActionList layout = new ActionList();
        layout.add((Action)this.stackedLayout);
        layout.add((Action)new LabelLayout(LABELS));
        layout.add((Action)autoPan);
        this.m_vis.putAction(LAYOUT_ACTION, (Action)layout);
        Dimension size = new Dimension(400, 400);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setItemSorter((ItemSorter)new ExtendedTreeDepthItemSorter(true));
        this.addControlListener((Control)new HoverControl());
        this.addControlListener((Control)new FocusControl(1, COLORS_ACTION));
        this.addControlListener((Control)new WheelMouseControl());
        this.addControlListener((Control)new PanControl(true));
        this.addControlListener((Control)new ItemSelectionControl());
        this.setDamageRedraw(true);
    }

    @Override
    public void run(Graph graph) {
        this.m_vis.add("graph", (TupleSet)graph);
        Predicate edgesPredicate = (Predicate)ExpressionParser.parse((String)"ingroup('graph.edges') AND [uses.edges]==false", (boolean)true);
        this.m_vis.setVisible("graph.edges", edgesPredicate, false);
        this.m_vis.setInteractive("graph.edges", null, false);
        this.m_vis.setInteractive("graph.nodes", null, true);
        Predicate labelP = (Predicate)ExpressionParser.parse((String)"VISIBLE()");
        this.m_vis.addDecorators(LABELS, "graph.nodes", labelP, LABEL_SCHEMA);
        this.run();
    }

    @Override
    public void run() {
        if (this.isInProgress()) {
            return;
        }
        this.m_vis.invalidate("graph.nodes");
        this.activity = this.m_vis.run(LAYOUT_ACTION);
    }

    @Override
    public void setSelectedValue(Object object) {
        if (object == null) {
            return;
        }
        NodeItem item = null;
        Iterator iter = this.m_vis.items("graph.nodes");
        while (iter.hasNext()) {
            NodeItem tItem = (NodeItem)iter.next();
            Object tObj = tItem.get("userObject");
            if (!tObj.equals(object)) continue;
            item = tItem;
            break;
        }
        if (item != null) {
            int depth = item.getDepth();
            boolean relayout = false;
            if (depth > this.stackedLayout.getZoom()) {
                this.stackedLayout.zoom(depth);
                relayout = true;
            }
            TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
            ts.setTuple((Tuple)item);
            if (relayout) {
                this.run();
            } else {
                this.m_vis.run(AUTO_PAN_ACTION);
            }
        }
    }

    private void zoomIn() {
        if (this.isInProgress()) {
            return;
        }
        this.stackedLayout.zoomIn();
        this.run();
    }

    private void zoomOut() {
        if (this.isInProgress()) {
            return;
        }
        this.stackedLayout.zoomOut();
        this.run();
    }

    private boolean isInProgress() {
        if (this.isTranformInProgress()) {
            return true;
        }
        return this.activity != null && this.activity.isRunning();
    }

    static {
        LABEL_SCHEMA.setDefault(VisualItem.INTERACTIVE, false);
        LABEL_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.rgb((int)255, (int)255, (int)255));
        LABEL_SCHEMA.setDefault(VisualItem.FONT, (Object)FONT);
        OUTLINE_COLOR = ColorLib.rgb((int)33, (int)115, (int)170);
        OUTLINE_FOCUS_COLOR = ColorLib.rgb((int)255, (int)255, (int)255);
    }

    private static class ExtendedTreeDepthItemSorter
    extends TreeDepthItemSorter {
        private ExtendedTreeDepthItemSorter() {
            this(false);
        }

        private ExtendedTreeDepthItemSorter(boolean childrenAbove) {
            super(childrenAbove);
        }

        public int score(VisualItem item) {
            int score = super.score(item);
            if (item instanceof EdgeItem) {
                score = 0x20000000;
            }
            return score;
        }
    }

    private class AutoPanAction
    extends Action {
        private AutoPanAction() {
        }

        public void run(double frac) {
            Dimension size;
            Rectangle2D.Double displayBounds = new Rectangle2D.Double(0.0, 0.0, StackedGraphDisplay.this.getWidth(), StackedGraphDisplay.this.getHeight());
            Container container = StackedGraphDisplay.this.getParent();
            if (container == null) {
                return;
            }
            if (container instanceof JViewport) {
                size = ((JViewport)container).getExtentSize();
                ((Rectangle2D)displayBounds).setRect(0.0, 0.0, size.getWidth(), size.getHeight());
            } else {
                size = container.getSize();
                ((Rectangle2D)displayBounds).setRect(0.0, 0.0, size.getWidth(), size.getHeight());
            }
            Rectangle2D bounds = StackedGraphDisplay.this.stackedLayout.getLayoutRoot().getBounds();
            double x = (((RectangularShape)displayBounds).getWidth() - bounds.getWidth()) / 2.0;
            double y = (((RectangularShape)displayBounds).getHeight() - bounds.getHeight()) / 2.0;
            try {
                StackedGraphDisplay.this.setTransform(new AffineTransform());
            }
            catch (NoninvertibleTransformException ex) {
                return;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            StackedGraphDisplay.this.pan(x, y);
            TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
            if (ts.getTupleCount() != 0) {
                VisualItem vi = (VisualItem)ts.tuples().next();
                if (container instanceof JViewport) {
                    ((JViewport)container).scrollRectToVisible(vi.getBounds().getBounds());
                }
            }
        }
    }

    private class ItemSelectionControl
    extends ControlAdapter {
        private ItemSelectionControl() {
        }

        public final void itemClicked(VisualItem anItem, MouseEvent anEvent) {
            anItem.getVisualization().repaint();
            if (!anItem.canGet("userObject", Object.class)) {
                return;
            }
            Object object = anItem.get("userObject");
            LinkEvent evt = new LinkEvent((Object)StackedGraphDisplay.this, object);
            StackedGraphDisplay.this.fireLinkActivated(evt);
        }
    }

    private class WheelMouseControl
    extends ControlAdapter {
        private WheelMouseControl() {
        }

        public void itemWheelMoved(VisualItem item, MouseWheelEvent evt) {
            this.zoom(evt.getWheelRotation());
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
            this.zoom(evt.getWheelRotation());
        }

        private void zoom(final int rotation) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (rotation == 0) {
                        return;
                    }
                    if (rotation < 0) {
                        StackedGraphDisplay.this.zoomOut();
                    } else {
                        StackedGraphDisplay.this.zoomIn();
                    }
                }
            });
        }
    }

    private static class NodeRenderer
    extends AbstractShapeRenderer {
        private Rectangle2D m_bounds = new Rectangle2D.Double();

        private NodeRenderer() {
            this.m_manageBounds = false;
        }

        protected Shape getRawShape(VisualItem item) {
            this.m_bounds.setRect(item.getBounds());
            return this.m_bounds;
        }
    }

    private static class LabelLayout
    extends Layout {
        private LabelLayout(String group) {
            super(group);
        }

        public void run(double frac) {
            Iterator iter = this.m_vis.items(this.m_group);
            while (iter.hasNext()) {
                DecoratorItem item = (DecoratorItem)iter.next();
                VisualItem node = item.getDecoratedItem();
                Rectangle2D bounds = node.getBounds();
                this.setX((VisualItem)item, node, bounds.getX() + (double)StackedLayout.INSET);
                this.setY((VisualItem)item, node, bounds.getY() + (double)StackedLayout.INSET + 12.0);
            }
        }
    }

    private static class HoverControl
    extends ControlAdapter {
        private HoverControl() {
        }

        public void itemEntered(VisualItem item, MouseEvent evt) {
            item.setStrokeColor(OUTLINE_FOCUS_COLOR);
            item.getVisualization().repaint();
        }

        public void itemExited(VisualItem item, MouseEvent evt) {
            item.setStrokeColor(item.getEndStrokeColor());
            item.getVisualization().repaint();
        }
    }

    private static class FillColorAction
    extends ColorAction {
        private static final ColorMap CMAP = new ColorMap(new int[]{ColorLib.rgb((int)11, (int)117, (int)188), ColorLib.rgb((int)8, (int)99, (int)160), ColorLib.rgb((int)5, (int)77, (int)126), ColorLib.rgb((int)2, (int)61, (int)100), ColorLib.rgb((int)148, (int)55, (int)87)}, 0.0, 4.0);

        private FillColorAction(String group) {
            super(group, VisualItem.FILLCOLOR);
        }

        public int getColor(VisualItem item) {
            if (item instanceof NodeItem) {
                NodeItem nItem = (NodeItem)item;
                if (this.m_vis.isInGroup((VisualItem)nItem, Visualization.FOCUS_ITEMS)) {
                    int c = CMAP.getColor((double)nItem.getDepth());
                    return ColorLib.darker((int)c);
                }
                return CMAP.getColor((double)nItem.getDepth());
            }
            return CMAP.getColor(0.0);
        }
    }

    private static class BorderColorAction
    extends ColorAction {
        private BorderColorAction(String group) {
            super(group, VisualItem.STROKECOLOR);
        }

        public int getColor(VisualItem item) {
            if (!(item instanceof NodeItem)) {
                return 0;
            }
            NodeItem nItem = (NodeItem)item;
            if (this.m_vis.isInGroup((VisualItem)nItem, Visualization.FOCUS_ITEMS)) {
                return OUTLINE_FOCUS_COLOR;
            }
            return OUTLINE_COLOR;
        }
    }
}

