/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.graph;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.qi4j.envisage.graph.StackedGraphDisplay;
import prefuse.Display;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.render.Renderer;
import prefuse.visual.NodeItem;

final class StackedLayout
extends TreeLayout {
    static int INSET = 10;
    private int zoom = 2;

    StackedLayout(String group) {
        super(group);
    }

    public void run(double frac) {
        NodeItem root = this.getLayoutRoot();
        this.layout(root, 0.0, 0.0);
        Rectangle2D bounds = root.getBounds();
        Display display = this.getVisualization().getDisplay(0);
        Dimension size = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        display.setSize(size);
        if (!display.isValid()) {
            display.validate();
        }
    }

    void zoomOut() {
        --this.zoom;
        if (this.zoom < 1) {
            this.zoom = 1;
        }
    }

    void zoomIn() {
        ++this.zoom;
        if (this.zoom > 4) {
            this.zoom = 4;
        }
    }

    void zoom(int zoom) {
        this.zoom = zoom;
    }

    int getZoom() {
        return this.zoom;
    }

    private Dimension getItemMinSize(NodeItem node, Dimension minSize) {
        if (minSize == null) {
            minSize = new Dimension(0, 0);
        }
        String label = node.getString("name");
        FontMetrics fm = Renderer.DEFAULT_GRAPHICS.getFontMetrics(StackedGraphDisplay.FONT);
        int width = fm.stringWidth(label);
        int height = fm.getHeight();
        minSize.setSize(width + INSET + INSET, height + INSET + INSET);
        return minSize;
    }

    private void layout(NodeItem node, double x, double y) {
        Dimension minSize = this.getItemMinSize(node, null);
        node.setBounds(x, y, (double)minSize.width, (double)minSize.height);
        int depth = node.getDepth();
        if (depth > this.zoom) {
            node.setBounds(x, y, 0.0, 0.0);
            node.setVisible(false);
        } else {
            node.setVisible(true);
        }
        double cx = x + (double)INSET;
        double cy = y + (double)minSize.height;
        Area area = new Area(node.getBounds());
        boolean hasChild = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            hasChild = true;
            NodeItem child = (NodeItem)node.getChild(i);
            this.layout(child, cx, cy);
            area.add(new Area(child.getBounds()));
            Rectangle2D nodeRect = child.getBounds();
            if (depth == 0) {
                cy = cy + (double)(INSET * 2) + nodeRect.getHeight();
            }
            if (depth == 1) {
                cx = cx + (double)INSET + nodeRect.getWidth();
                continue;
            }
            if (depth == 2) {
                cx = cx + (double)INSET + nodeRect.getWidth();
                continue;
            }
            if (depth != 3) continue;
            cy = cy + (double)INSET + nodeRect.getHeight();
        }
        Rectangle2D bounds = area.getBounds2D();
        if (hasChild && depth <= this.zoom) {
            bounds.setRect(x, y, bounds.getWidth() + (double)INSET, bounds.getHeight() + (double)INSET);
        }
        node.setBounds(x, y, bounds.getWidth(), bounds.getHeight());
        if (depth == 0) {
            this.arrangeChildVertically(node);
        } else if (depth == 1) {
            this.arrangeChildHorizontally(node);
        } else if (depth == 2) {
            this.arrangeChildHorizontally(node);
        } else if (depth == 3) {
            this.arrangeChildVertically(node);
        }
    }

    private void arrangeChildVertically(NodeItem parent) {
        Rectangle2D bounds;
        NodeItem node;
        int i;
        double maxW = 0.0;
        for (i = 0; i < parent.getChildCount(); ++i) {
            node = (NodeItem)parent.getChild(i);
            bounds = node.getBounds();
            maxW = Math.max(maxW, bounds.getWidth());
        }
        for (i = 0; i < parent.getChildCount(); ++i) {
            node = (NodeItem)parent.getChild(i);
            bounds = node.getBounds();
            node.setBounds(bounds.getX(), bounds.getY(), maxW, bounds.getHeight());
        }
    }

    private void arrangeChildHorizontally(NodeItem parent) {
        Rectangle2D bounds;
        NodeItem node;
        int i;
        double maxH = 0.0;
        for (i = 0; i < parent.getChildCount(); ++i) {
            node = (NodeItem)parent.getChild(i);
            bounds = node.getBounds();
            maxH = Math.max(maxH, bounds.getHeight());
        }
        for (i = 0; i < parent.getChildCount(); ++i) {
            node = (NodeItem)parent.getChild(i);
            bounds = node.getBounds();
            node.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), maxH);
        }
    }
}

