/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.graph;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.graph.GraphDisplay;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.filter.FisheyeTreeFilter;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.PrefuseLib;
import prefuse.util.display.DisplayLib;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public final class TreeGraphDisplay
extends GraphDisplay {
    static final String FILTER_ACTION = "filter";
    static final String REPAINT_ACTION = "repaint";
    static final String FULL_PAINT_ACTION = "fullPaint";
    static final String ANIMATE_PAINT_ACTION = "animatePaint";
    static final String ANIMATE_ACTION = "animate";
    static final String LAYOUT_ACTION = "layout";
    static final String SUB_LAYOUT_ACTION = "subLayout";
    static final String AUTO_ZOOM_ACTION = "autoZoom";
    private final LabelRenderer nodeRenderer;
    private final EdgeRenderer edgeRenderer;
    private final EdgeRenderer usesRenderer;
    private final int orientation = 0;

    public TreeGraphDisplay() {
        super(new Visualization());
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.BLACK;
        this.setBackground(BACKGROUND);
        this.setForeground(FOREGROUND);
        this.nodeRenderer = new LabelRenderer("name");
        this.nodeRenderer.setRenderType(2);
        this.nodeRenderer.setHorizontalAlignment(0);
        this.nodeRenderer.setRoundedCorner(8, 8);
        this.edgeRenderer = new EdgeRenderer(1);
        this.usesRenderer = new EdgeRenderer(1, 1);
        Predicate edgesPredicate = (Predicate)ExpressionParser.parse((String)"ingroup('graph.edges') AND [uses.edges]==false", (boolean)true);
        Predicate usesPredicate = (Predicate)ExpressionParser.parse((String)"ingroup('graph.edges') AND [uses.edges]==true", (boolean)true);
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.nodeRenderer);
        rf.add(edgesPredicate, (Renderer)this.edgeRenderer);
        rf.add(usesPredicate, (Renderer)this.usesRenderer);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        NodeColorAction nodeColor = new NodeColorAction("graph.nodes");
        ColorAction textColor = new ColorAction("graph.nodes", VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0));
        this.m_vis.putAction("textColor", (Action)textColor);
        ColorAction edgeColor = new ColorAction("graph.edges", edgesPredicate, VisualItem.STROKECOLOR, ColorLib.rgb((int)200, (int)200, (int)200));
        ColorAction usesColor = new ColorAction("graph.edges", usesPredicate, VisualItem.STROKECOLOR, ColorLib.rgb((int)255, (int)100, (int)100));
        ColorAction usesArrow = new ColorAction("graph.edges", usesPredicate, VisualItem.FILLCOLOR, ColorLib.rgb((int)255, (int)100, (int)100));
        ActionList repaint = new ActionList();
        repaint.add((Action)nodeColor);
        repaint.add((Action)new RepaintAction());
        this.m_vis.putAction(REPAINT_ACTION, (Action)repaint);
        ActionList fullPaint = new ActionList();
        fullPaint.add((Action)nodeColor);
        this.m_vis.putAction(FULL_PAINT_ACTION, (Action)fullPaint);
        ActionList animatePaint = new ActionList();
        animatePaint.add((Action)new ColorAnimator("graph.nodes"));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction(ANIMATE_PAINT_ACTION, (Action)animatePaint);
        NodeLinkTreeLayout treeLayout = new NodeLinkTreeLayout("graph", 0, 40.0, 0.0, 8.0);
        treeLayout.setLayoutAnchor((Point2D)new Point2D.Double(25.0, 300.0));
        this.m_vis.putAction(LAYOUT_ACTION, (Action)treeLayout);
        CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout("graph", 0);
        this.m_vis.putAction(SUB_LAYOUT_ACTION, (Action)subLayout);
        ActionList filter = new ActionList();
        filter.add((Action)new ExtendedFisheyeTreeFilter("graph", 2));
        filter.add((Action)new FontAction("graph.nodes", FontLib.getFont((String)"Tahoma", (double)14.0)));
        filter.add((Action)treeLayout);
        filter.add((Action)subLayout);
        filter.add((Action)textColor);
        filter.add((Action)nodeColor);
        filter.add((Action)edgeColor);
        filter.add((Action)usesColor);
        filter.add((Action)usesArrow);
        this.m_vis.putAction(FILTER_ACTION, (Action)filter);
        AutoPanAction autoPan = new AutoPanAction();
        ActionList animate = new ActionList(750L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)autoPan);
        animate.add((Action)new QualityControlAnimator());
        animate.add((Action)new VisibilityAnimator("graph"));
        animate.add((Action)new LocationAnimator("graph.nodes"));
        animate.add((Action)new ColorAnimator("graph.nodes"));
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction(ANIMATE_ACTION, (Action)animate);
        this.m_vis.alwaysRunAfter(FILTER_ACTION, ANIMATE_ACTION);
        this.m_vis.putAction(AUTO_ZOOM_ACTION, (Action)new AutoZoomAction());
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new FocusControl(1, FILTER_ACTION));
        this.addControlListener((Control)new ItemSelectionControl());
        this.nodeRenderer.setHorizontalAlignment(0);
        this.edgeRenderer.setHorizontalAlignment1(1);
        this.edgeRenderer.setHorizontalAlignment2(0);
        this.edgeRenderer.setVerticalAlignment1(2);
        this.edgeRenderer.setVerticalAlignment2(2);
        this.usesRenderer.setHorizontalAlignment1(2);
        this.usesRenderer.setHorizontalAlignment2(2);
        this.usesRenderer.setVerticalAlignment1(3);
        this.usesRenderer.setVerticalAlignment2(2);
        NodeLinkTreeLayout rtl = (NodeLinkTreeLayout)this.m_vis.getAction(LAYOUT_ACTION);
        CollapsedSubtreeLayout stl = (CollapsedSubtreeLayout)this.m_vis.getAction(SUB_LAYOUT_ACTION);
        rtl.setOrientation(0);
        stl.setOrientation(0);
    }

    @Override
    public void run(Graph graph) {
        this.m_vis.add("graph", (TupleSet)graph);
        this.run();
        this.m_vis.run(AUTO_ZOOM_ACTION);
        this.m_vis.setInteractive("graph.edges", null, false);
    }

    @Override
    public void run() {
        this.m_vis.run(FILTER_ACTION);
    }

    @Override
    public void setSelectedValue(Object object) {
        if (object == null) {
            return;
        }
        VisualItem item = null;
        Iterator iter = this.m_vis.items("graph.nodes");
        while (iter.hasNext()) {
            VisualItem tItem = (VisualItem)iter.next();
            Object tObj = tItem.get("userObject");
            if (!tObj.equals(object)) continue;
            item = tItem;
            break;
        }
        if (item != null) {
            TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
            ts.setTuple(item);
            this.m_vis.run(FILTER_ACTION);
        }
    }

    private static class ExtendedFisheyeTreeFilter
    extends FisheyeTreeFilter {
        private ExtendedFisheyeTreeFilter(String group, int distance) {
            super(group, distance);
        }

        public void run(double frac) {
            super.run(frac);
            Iterator items = this.m_vis.items("graph.edges");
            while (items.hasNext()) {
                VisualItem item = (VisualItem)items.next();
                if (!item.getBoolean("uses.edges")) continue;
                PrefuseLib.updateVisible((VisualItem)item, (boolean)true);
            }
        }
    }

    private class ItemSelectionControl
    extends ControlAdapter {
        private ItemSelectionControl() {
        }

        public final void itemClicked(VisualItem anItem, MouseEvent anEvent) {
            if (!anItem.canGet("userObject", Object.class)) {
                return;
            }
            Object object = anItem.get("userObject");
            LinkEvent evt = new LinkEvent((Object)TreeGraphDisplay.this, object);
            TreeGraphDisplay.this.fireLinkActivated(evt);
        }
    }

    private static class NodeColorAction
    extends ColorAction {
        private NodeColorAction(String group) {
            super(group, VisualItem.FILLCOLOR);
        }

        public int getColor(VisualItem item) {
            if (this.m_vis.isInGroup(item, Visualization.SEARCH_ITEMS)) {
                return ColorLib.rgb((int)255, (int)190, (int)190);
            }
            if (this.m_vis.isInGroup(item, Visualization.FOCUS_ITEMS)) {
                return ColorLib.rgb((int)198, (int)229, (int)229);
            }
            if (item.getDOI() > -1.0) {
                return ColorLib.rgb((int)164, (int)193, (int)193);
            }
            return ColorLib.rgba((int)255, (int)255, (int)255, (int)0);
        }
    }

    private class AutoPanAction
    extends Action {
        private final Point2D m_start = new Point2D.Double();
        private final Point2D m_end = new Point2D.Double();
        private final Point2D m_cur = new Point2D.Double();
        private final int m_bias = 150;

        private AutoPanAction() {
        }

        public void run(double frac) {
            TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
            if (ts.getTupleCount() == 0) {
                return;
            }
            if (frac == 0.0) {
                int ybias = 0;
                int xbias = 150;
                switch (0) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        xbias = -150;
                        break;
                    }
                    case 2: {
                        ybias = 150;
                        break;
                    }
                    case 3: {
                        ybias = -150;
                    }
                }
                VisualItem vi = (VisualItem)ts.tuples().next();
                this.m_cur.setLocation(TreeGraphDisplay.this.getWidth() / 2, TreeGraphDisplay.this.getHeight() / 2);
                TreeGraphDisplay.this.getAbsoluteCoordinate(this.m_cur, this.m_start);
                this.m_end.setLocation(vi.getX() + (double)xbias, vi.getY() + (double)ybias);
            } else {
                this.m_cur.setLocation(this.m_start.getX() + frac * (this.m_end.getX() - this.m_start.getX()), this.m_start.getY() + frac * (this.m_end.getY() - this.m_start.getY()));
                TreeGraphDisplay.this.panToAbs(this.m_cur);
            }
        }
    }

    private class AutoZoomAction
    extends Action {
        private AutoZoomAction() {
        }

        public void run(double frac) {
            int duration = 20;
            int margin = 50;
            Visualization vis = this.getVisualization();
            Rectangle2D bounds = vis.getBounds(Visualization.ALL_ITEMS);
            GraphicsLib.expand((Rectangle2D)bounds, (double)(margin + (int)(1.0 / TreeGraphDisplay.this.getScale())));
            DisplayLib.fitViewToBounds((Display)TreeGraphDisplay.this, (Rectangle2D)bounds, (long)duration);
        }
    }
}

