/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.tree;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;

final class TreeModelCellRenderer
extends DefaultTreeCellRenderer {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(TreeModelCellRenderer.class.getName());
    private final Icon applicationIcon;
    private final Icon layerIcon;
    private final Icon moduleIcon;
    private final Icon serviceIcon;
    private final Icon importedServiceIcon;
    private final Icon entityIcon;
    private final Icon valueIcon;
    private final Icon transientIcon;
    private final Icon objectIcon;

    TreeModelCellRenderer() {
        try {
            this.applicationIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Application")));
            this.layerIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Layer")));
            this.moduleIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Module")));
            this.serviceIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Service")));
            this.importedServiceIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_ImportedService")));
            this.entityIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Entity")));
            this.valueIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Value")));
            this.transientIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Transient")));
            this.objectIcon = new ImageIcon(this.getClass().getResource(BUNDLE.getString("ICON_Object")));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        Icon icon = null;
        if (userObject instanceof ApplicationDetailDescriptor) {
            icon = this.applicationIcon;
        } else if (userObject instanceof LayerDetailDescriptor) {
            icon = this.layerIcon;
        } else if (userObject instanceof ModuleDetailDescriptor) {
            icon = this.moduleIcon;
        } else if (userObject instanceof ServiceDetailDescriptor) {
            icon = this.serviceIcon;
        } else if (userObject instanceof ImportedServiceDetailDescriptor) {
            icon = this.importedServiceIcon;
        } else if (userObject instanceof EntityDetailDescriptor) {
            icon = this.entityIcon;
        } else if (userObject instanceof ValueDetailDescriptor) {
            icon = this.valueIcon;
        } else if (userObject instanceof TransientDetailDescriptor) {
            icon = this.transientIcon;
        } else if (userObject instanceof ObjectDetailDescriptor) {
            icon = this.objectIcon;
        } else {
            String str = userObject.toString();
            if (str.equalsIgnoreCase("Services")) {
                icon = this.serviceIcon;
            } else if (str.equalsIgnoreCase("Imported Services")) {
                icon = this.importedServiceIcon;
            } else if (str.equalsIgnoreCase("Entities")) {
                icon = this.entityIcon;
            } else if (str.equalsIgnoreCase("Values")) {
                icon = this.valueIcon;
            } else if (str.equalsIgnoreCase("Transients")) {
                icon = this.transientIcon;
            } else if (str.equalsIgnoreCase("Objects")) {
                icon = this.objectIcon;
            }
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        return this;
    }
}

