/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.riak;

import com.basho.riak.client.IRiakClient;
import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.bucket.Bucket;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.entitystore.riak.RiakAccessors;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRiakMapEntityStore
implements ServiceActivation,
MapEntityStore,
RiakAccessors {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"org.qi4j.entitystore.riak");
    protected static final int DEFAULT_MAX_CONNECTIONS = 50;
    static final String DEFAULT_BUCKET_KEY = "qi4j:entities";
    protected IRiakClient riakClient;
    protected String bucketKey;

    AbstractRiakMapEntityStore() {
    }

    public void passivateService() throws Exception {
        this.riakClient.shutdown();
        this.riakClient = null;
        this.bucketKey = null;
    }

    @Override
    public IRiakClient riakClient() {
        return this.riakClient;
    }

    @Override
    public String bucket() {
        return this.bucketKey;
    }

    public Reader get(EntityReference entityReference) throws EntityStoreException {
        try {
            Bucket bucket = this.riakClient.fetchBucket(this.bucketKey).execute();
            IRiakObject entity = (IRiakObject)bucket.fetch(entityReference.identity()).execute();
            if (entity == null) {
                throw new EntityNotFoundException(entityReference);
            }
            String jsonState = entity.getValueAsString();
            return new StringReader(jsonState);
        }
        catch (RiakRetryFailedException ex) {
            throw new EntityStoreException("Unable to get Entity " + entityReference.identity(), (Throwable)ex);
        }
    }

    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        try {
            final Bucket bucket = this.riakClient.fetchBucket(this.bucketKey).execute();
            changes.visitMap(new MapEntityStore.MapChanger(){

                public Writer newEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            try {
                                super.close();
                                bucket.store(ref.identity(), this.toString()).execute();
                            }
                            catch (RiakException ex) {
                                throw new EntityStoreException("Unable to apply entity change: newEntity", (Throwable)ex);
                            }
                        }
                    };
                }

                public Writer updateEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            try {
                                super.close();
                                IRiakObject entity = (IRiakObject)bucket.fetch(ref.identity()).execute();
                                if (entity == null) {
                                    throw new EntityNotFoundException(ref);
                                }
                                bucket.store(ref.identity(), this.toString()).execute();
                            }
                            catch (RiakException ex) {
                                throw new EntityStoreException("Unable to apply entity change: updateEntity", (Throwable)ex);
                            }
                        }
                    };
                }

                public void removeEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws EntityNotFoundException {
                    try {
                        IRiakObject entity = (IRiakObject)bucket.fetch(ref.identity()).execute();
                        if (entity == null) {
                            throw new EntityNotFoundException(ref);
                        }
                        bucket.delete(ref.identity()).execute();
                    }
                    catch (RiakException ex) {
                        throw new EntityStoreException("Unable to apply entity change: removeEntity", (Throwable)ex);
                    }
                }
            });
        }
        catch (RiakRetryFailedException ex) {
            throw new EntityStoreException("Unable to apply entity changes.", (Throwable)ex);
        }
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                        try {
                            Bucket bucket = AbstractRiakMapEntityStore.this.riakClient.fetchBucket(AbstractRiakMapEntityStore.this.bucketKey).execute();
                            for (String key : bucket.keys()) {
                                String jsonState = ((IRiakObject)bucket.fetch(key).execute()).getValueAsString();
                                receiver.receive((Object)new StringReader(jsonState));
                            }
                        }
                        catch (RiakException ex) {
                            throw new EntityStoreException("Unable to apply entity changes.", (Throwable)ex);
                        }
                    }
                });
            }
        };
    }
}

