/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.riak;

import com.basho.riak.client.RiakFactory;
import com.basho.riak.client.raw.http.HTTPClientConfig;
import com.basho.riak.client.raw.http.HTTPClusterConfig;
import java.util.List;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.This;
import org.qi4j.entitystore.riak.AbstractRiakMapEntityStore;
import org.qi4j.entitystore.riak.RiakHttpEntityStoreConfiguration;

public class RiakHttpMapEntityStoreMixin
extends AbstractRiakMapEntityStore {
    private static final String DEFAULT_URL = "http://127.0.0.1:8098/riak";
    @This
    private Configuration<RiakHttpEntityStoreConfiguration> configuration;

    public void activateService() throws Exception {
        this.configuration.refresh();
        RiakHttpEntityStoreConfiguration config = (RiakHttpEntityStoreConfiguration)this.configuration.get();
        int maxConnections = config.maxConnections().get() == null ? 50 : (Integer)config.maxConnections().get();
        int timeoutMillis = (Integer)config.timeout().get();
        List urls = (List)config.urls().get();
        if (urls.isEmpty()) {
            urls.add(DEFAULT_URL);
        }
        this.bucketKey = config.bucket().get() == null ? "qi4j:entities" : (String)config.bucket().get();
        HTTPClusterConfig httpClusterConfig = new HTTPClusterConfig(maxConnections);
        for (String url : urls) {
            HTTPClientConfig clientConfig = new HTTPClientConfig.Builder().withTimeout(timeoutMillis).withUrl(url).build();
            httpClusterConfig.addClient((com.basho.riak.client.raw.config.Configuration)clientConfig);
        }
        this.riakClient = RiakFactory.newClient((com.basho.riak.client.raw.config.Configuration)httpClusterConfig);
        if (!this.riakClient.listBuckets().contains(this.bucketKey)) {
            this.riakClient.createBucket(this.bucketKey).execute();
        }
    }
}

