/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.riak;

import com.basho.riak.client.RiakFactory;
import com.basho.riak.client.raw.pbc.PBClientConfig;
import com.basho.riak.client.raw.pbc.PBClusterConfig;
import java.util.List;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.This;
import org.qi4j.entitystore.riak.AbstractRiakMapEntityStore;
import org.qi4j.entitystore.riak.RiakProtobufEntityStoreConfiguration;

public class RiakProtobufMapEntityStoreMixin
extends AbstractRiakMapEntityStore {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 1000;
    private static final int DEFAULT_IDLE_CONNECTION_TTL = 1000;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE_KB = 16;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 8087;
    @This
    private Configuration<RiakProtobufEntityStoreConfiguration> configuration;

    public void activateService() throws Exception {
        this.configuration.refresh();
        RiakProtobufEntityStoreConfiguration config = (RiakProtobufEntityStoreConfiguration)this.configuration.get();
        int maxConnections = config.maxConnections().get() == null ? 50 : (Integer)config.maxConnections().get();
        int connectionTimeout = config.connectionTimeout().get() == null ? 1000 : (Integer)config.connectionTimeout().get();
        int idleConnectionTTL = config.idleConnectionTTL().get() == null ? 1000 : (Integer)config.idleConnectionTTL().get();
        int maxPoolSize = (Integer)config.maxPoolSize().get();
        int initialPoolSize = (Integer)config.initialPoolSize().get();
        int socketBufferSize = config.socketBufferSizeKb().get() == null ? 16 : (Integer)config.socketBufferSizeKb().get();
        List hosts = (List)config.hosts().get();
        if (hosts.isEmpty()) {
            hosts.add(DEFAULT_HOST);
        }
        this.bucketKey = config.bucket().get() == null ? "qi4j:entities" : (String)config.bucket().get();
        PBClusterConfig pbClusterConfig = new PBClusterConfig(maxConnections);
        for (String host : hosts) {
            String[] splitted = host.split(":");
            int port = 8087;
            if (splitted.length > 1) {
                host = splitted[0];
                port = Integer.valueOf(splitted[1]);
            }
            PBClientConfig clientConfig = new PBClientConfig.Builder().withConnectionTimeoutMillis((long)connectionTimeout).withIdleConnectionTTLMillis((long)idleConnectionTTL).withPoolSize(maxPoolSize).withInitialPoolSize(initialPoolSize).withSocketBufferSizeKb(socketBufferSize).withHost(host).withPort(port).build();
            pbClusterConfig.addClient((com.basho.riak.client.raw.config.Configuration)clientConfig);
        }
        this.riakClient = RiakFactory.newClient((com.basho.riak.client.raw.config.Configuration)pbClusterConfig);
        if (!this.riakClient.listBuckets().contains(this.bucketKey)) {
            this.riakClient.createBucket(this.bucketKey).execute();
        }
    }
}

