/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.rest.server;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Outputs;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.source.EventSource;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.atom.Text;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class DomainEventSourceResource
extends Restlet {
    EventSource source;

    public DomainEventSourceResource(@Service @Tagged(value={"domain"}) EventSource source) {
        this.source = source;
    }

    public void handle(Request request, Response response) {
        WriterRepresentation representation;
        long eventCount = this.source.count();
        long pageSize = 10L;
        long startEvent = -1L;
        long endEvent = -1L;
        long limit = pageSize;
        ArrayList eventsValues = new ArrayList();
        final Feed feed = new Feed();
        feed.setBaseReference(request.getResourceRef().getParentRef());
        List links = feed.getLinks();
        String remainingPart = request.getResourceRef().getRemainingPart();
        if (remainingPart.equals("/")) {
            startEvent = Math.max(0L, eventCount - pageSize - 1L);
            feed.setTitle(new Text("Current set"));
            if (startEvent > 0L) {
                long previousStart = Math.max(0L, startEvent - pageSize);
                long previousEnd = startEvent - 1L;
                Link link = new Link(new Reference(previousStart + "," + previousEnd), new Relation("previous"), MediaType.APPLICATION_ATOM);
                link.setTitle("Previous page");
                links.add(link);
            }
        } else {
            String[] indices = remainingPart.substring(1).split(",");
            if (indices.length == 1) {
                startEvent = Long.parseLong(indices[0]);
                endEvent = startEvent + pageSize - 1L;
                limit = pageSize;
                feed.setTitle(new Text("Working set"));
            } else if (indices.length == 2) {
                feed.setTitle(new Text("Archive page"));
                startEvent = Long.parseLong(indices[0]);
                endEvent = Long.parseLong(indices[1]);
                limit = 1L + endEvent - startEvent;
            } else {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
            }
            if (startEvent > 0L) {
                long previousStart = Math.max(0L, startEvent - pageSize);
                long previousEnd = startEvent - 1L;
                Link link = new Link(new Reference(previousStart + "," + previousEnd), new Relation("previous"), MediaType.APPLICATION_ATOM);
                link.setTitle("Previous page");
                links.add(link);
            }
            long nextStart = endEvent + 1L;
            long nextEnd = nextStart + pageSize - 1L;
            if (nextStart < eventCount) {
                Link next;
                if (nextEnd >= eventCount) {
                    next = new Link(new Reference(nextStart + ""), new Relation("next"), MediaType.APPLICATION_ATOM);
                    next.setTitle("Working set");
                    links.add(next);
                } else {
                    next = new Link(new Reference(nextStart + "," + nextEnd), new Relation("next"), MediaType.APPLICATION_ATOM);
                    next.setTitle("Next page");
                    links.add(next);
                }
            }
        }
        try {
            this.source.events(startEvent, limit).transferTo(Outputs.collection(eventsValues));
        }
        catch (Throwable throwable) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, throwable);
        }
        Link last = new Link(new Reference("0," + (pageSize - 1L)), new Relation("last"), MediaType.APPLICATION_ATOM);
        last.setTitle("Last archive page");
        links.add(last);
        Link first = new Link(new Reference("."), new Relation("first"), MediaType.APPLICATION_ATOM);
        first.setTitle("Current set");
        links.add(first);
        Date lastModified = null;
        for (UnitOfWorkDomainEventsValue eventsValue : eventsValues) {
            Entry entry = new Entry();
            entry.setTitle(new Text((String)eventsValue.usecase().get() + "(" + (String)eventsValue.user().get() + ")"));
            entry.setPublished(new Date((Long)eventsValue.timestamp().get()));
            lastModified = new Date((Long)eventsValue.timestamp().get());
            entry.setModificationDate(lastModified);
            entry.setId(Long.toString(startEvent + 1L));
            ++startEvent;
            Content content = new Content();
            content.setInlineContent((Representation)new StringRepresentation((CharSequence)eventsValue.toString(), MediaType.APPLICATION_JSON));
            entry.setContent(content);
            feed.getEntries().add(entry);
        }
        feed.setModificationDate(lastModified);
        MediaType mediaType = request.getClientInfo().getPreferredMediaType(Iterables.toList((Iterable)Iterables.iterable((Object[])new MediaType[]{MediaType.TEXT_HTML, MediaType.APPLICATION_ATOM})));
        if (MediaType.APPLICATION_ATOM.equals((Object)mediaType)) {
            representation = new WriterRepresentation(MediaType.APPLICATION_ATOM){

                public void write(Writer writer) throws IOException {
                    feed.write(writer);
                }
            };
            representation.setCharacterSet(CharacterSet.UTF_8);
            response.setEntity((Representation)representation);
        } else {
            representation = new WriterRepresentation(MediaType.TEXT_HTML){

                public void write(Writer writer) throws IOException {
                    writer.append("<html><head><title>Events</title></head><body>");
                    for (Link link : feed.getLinks()) {
                        writer.append("<a href=\"").append(link.getHref().getPath()).append("\">");
                        writer.append(link.getTitle());
                        writer.append("</a><br/>");
                    }
                    writer.append("<ol>");
                    for (Entry entry : feed.getEntries()) {
                        writer.append("<li>").append(entry.getTitle().toString()).append("</li>");
                    }
                    writer.append("</ol></body>");
                }
            };
            representation.setCharacterSet(CharacterSet.UTF_8);
            response.setEntity((Representation)representation);
        }
    }
}

