/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.hazelcast;

import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.entitystore.hazelcast.HazelcastAccessors;
import org.qi4j.entitystore.hazelcast.HazelcastConfiguration;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;

public class HazelcastEntityStoreMixin
implements ServiceActivation,
HazelcastAccessors,
MapEntityStore {
    private static final String DEFAULT_MAPNAME = "qi4j:entitystore:data";
    @This
    private Configuration<HazelcastConfiguration> config;
    private IMap<String, String> stringMap;
    private HazelcastInstance hazelcastInstance;

    public void activateService() throws Exception {
        HazelcastConfiguration configuration = (HazelcastConfiguration)this.config.get();
        Config conf = this.createConfig(configuration);
        this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)conf);
        String mapName = DEFAULT_MAPNAME;
        if (configuration != null && configuration.mapName() != null) {
            mapName = (String)configuration.mapName().get();
        }
        this.stringMap = this.hazelcastInstance.getMap(mapName);
    }

    public void passivateService() throws Exception {
        this.stringMap = null;
        this.hazelcastInstance.getLifecycleService().shutdown();
    }

    @Override
    public HazelcastInstance hazelcastInstanceUsed() {
        return this.hazelcastInstance;
    }

    @Override
    public IMap hazelcastMapUsed() {
        return this.stringMap;
    }

    public Reader get(EntityReference ref) throws EntityStoreException {
        String serializedState = (String)this.stringMap.get((Object)ref.identity());
        if (serializedState == null) {
            throw new EntityNotFoundException(ref);
        }
        return new StringReader(serializedState);
    }

    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        changes.visitMap(new MapEntityStore.MapChanger(){

            public Writer newEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                return new StringWriter(1000){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        HazelcastEntityStoreMixin.this.stringMap.put((Object)ref.identity(), (Object)this.toString());
                    }
                };
            }

            public Writer updateEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                return this.newEntity(ref, entityDescriptor);
            }

            public void removeEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws EntityNotFoundException {
                HazelcastEntityStoreMixin.this.stringMap.remove((Object)ref.identity());
            }
        });
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    public <RTT extends Throwable> void sendTo(Receiver<? super Reader, RTT> receiver) throws RTT, IOException {
                        for (Map.Entry eachEntry : HazelcastEntityStoreMixin.this.stringMap.entrySet()) {
                            receiver.receive((Object)new StringReader((String)eachEntry.getValue()));
                        }
                    }
                });
            }
        };
    }

    private Config createConfig(HazelcastConfiguration configuration) throws IOException {
        String hzConfLocation = (String)configuration.configXmlLocation().get();
        if (hzConfLocation == null || hzConfLocation.isEmpty()) {
            hzConfLocation = "hazelcast-default.xml";
        }
        Object conf = hzConfLocation.contains(":") ? new UrlXmlConfig(hzConfLocation) : new ClasspathXmlConfig(hzConfLocation);
        return conf;
    }
}

