/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.replay;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.qi4j.api.Qi4j;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.library.eventsourcing.application.api.ApplicationEvent;
import org.qi4j.library.eventsourcing.application.replay.ApplicationEventPlayer;
import org.qi4j.library.eventsourcing.application.replay.ApplicationEventReplayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface ApplicationEventPlayerService
extends ApplicationEventPlayer,
ServiceComposite {

    public static class Mixin
    implements ApplicationEventPlayer {
        final Logger logger = LoggerFactory.getLogger(ApplicationEventPlayer.class);
        @Structure
        UnitOfWorkFactory uowf;
        @Structure
        Module module;
        @Structure
        Qi4j api;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

        @Override
        public void playEvent(ApplicationEvent applicationEvent, Object object) throws ApplicationEventReplayException {
            UnitOfWork uow = this.uowf.currentUnitOfWork();
            Class<?> handlerType = object.getClass();
            Method eventMethod = this.getEventMethod(handlerType, (String)applicationEvent.name().get());
            if (eventMethod == null) {
                this.logger.warn("Could not find event method " + (String)applicationEvent.name().get() + " in entity of type " + handlerType.getName());
                return;
            }
            try {
                String jsonParameters = (String)applicationEvent.parameters().get();
                JSONObject parameters = (JSONObject)new JSONTokener(jsonParameters).nextValue();
                Object[] args = new Object[eventMethod.getParameterTypes().length];
                for (int i = 1; i < eventMethod.getParameterTypes().length; ++i) {
                    Class<?> parameterType = eventMethod.getParameterTypes()[i];
                    String paramName = "param" + i;
                    Object value = parameters.get(paramName);
                    args[i] = this.getParameterArgument(parameterType, value, uow);
                }
                args[0] = applicationEvent;
                this.logger.debug("Replay:" + applicationEvent + " on:" + object);
                eventMethod.invoke(object, args);
            }
            catch (Exception e) {
                throw new ApplicationEventReplayException(applicationEvent, (Throwable)e);
            }
        }

        private Object getParameterArgument(Class<?> parameterType, Object value, UnitOfWork uow) throws ParseException {
            if (value.equals(JSONObject.NULL)) {
                return null;
            }
            if (parameterType.equals(String.class)) {
                return (String)value;
            }
            if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
                return (Boolean)value;
            }
            if (parameterType.equals(Long.class) || parameterType.equals(Long.TYPE)) {
                return ((Number)value).longValue();
            }
            if (parameterType.equals(Integer.class) || parameterType.equals(Integer.TYPE)) {
                return ((Number)value).intValue();
            }
            if (parameterType.equals(Date.class)) {
                return this.dateFormat.parse((String)value);
            }
            if (ValueComposite.class.isAssignableFrom(parameterType)) {
                return this.module.newValueFromSerializedState(parameterType, (String)value);
            }
            if (parameterType.isInterface()) {
                return uow.get(parameterType, (String)value);
            }
            if (parameterType.isEnum()) {
                return Enum.valueOf(parameterType, value.toString());
            }
            throw new IllegalArgumentException("Unknown parameter type:" + parameterType.getName());
        }

        private Method getEventMethod(Class<?> aClass, String eventName) {
            for (Method method : aClass.getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(eventName) || (parameterTypes = method.getParameterTypes()).length <= 0 || !parameterTypes[0].equals(ApplicationEvent.class)) continue;
                return method;
            }
            return null;
        }
    }
}

