/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.source.helper;

import org.qi4j.api.configuration.Configuration;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.eventsourcing.application.api.TransactionApplicationEvents;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventSource;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStream;
import org.qi4j.library.eventsourcing.domain.source.helper.DomainEventTrackerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTransactionTracker<ReceiverThrowableType extends Throwable> {
    private Configuration<? extends DomainEventTrackerConfiguration> configuration;
    private Output<TransactionApplicationEvents, ReceiverThrowableType> output;
    private ApplicationEventStream stream;
    private ApplicationEventSource source;
    private boolean started = false;
    private boolean upToSpeed = false;
    private Logger logger;
    private Output<TransactionApplicationEvents, ReceiverThrowableType> trackerOutput;

    public ApplicationTransactionTracker(ApplicationEventStream stream, ApplicationEventSource source, Configuration<? extends DomainEventTrackerConfiguration> configuration, Output<TransactionApplicationEvents, ReceiverThrowableType> output) {
        this.stream = stream;
        this.configuration = configuration;
        this.source = source;
        this.output = output;
        this.logger = LoggerFactory.getLogger(output.getClass());
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            this.upToSpeed = true;
            this.trackerOutput = this.output();
            try {
                this.source.transactionsAfter((Long)((DomainEventTrackerConfiguration)this.configuration.get()).lastOffset().get(), Long.MAX_VALUE).transferTo(this.trackerOutput);
            }
            catch (Throwable receiverThrowableType) {
                this.upToSpeed = false;
            }
            this.stream.registerListener(this.trackerOutput);
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
            this.stream.unregisterListener(this.trackerOutput);
            this.upToSpeed = false;
        }
    }

    private Output<TransactionApplicationEvents, ReceiverThrowableType> output() {
        return new Output<TransactionApplicationEvents, ReceiverThrowableType>(){

            public <SenderThrowableType extends Throwable> void receiveFrom(final Sender<? extends TransactionApplicationEvents, SenderThrowableType> sender) throws Throwable, Throwable {
                if (!ApplicationTransactionTracker.this.upToSpeed) {
                    ApplicationTransactionTracker.this.upToSpeed = true;
                    try {
                        ApplicationTransactionTracker.this.source.transactionsAfter((Long)((DomainEventTrackerConfiguration)ApplicationTransactionTracker.this.configuration.get()).lastOffset().get(), Long.MAX_VALUE).transferTo(ApplicationTransactionTracker.this.trackerOutput);
                    }
                    catch (Throwable e) {
                        ApplicationTransactionTracker.this.upToSpeed = false;
                        throw e;
                    }
                }
                try {
                    ApplicationTransactionTracker.this.output.receiveFrom(new Sender<TransactionApplicationEvents, SenderThrowableType>(){

                        public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super TransactionApplicationEvents, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                            sender.sendTo(new Receiver<TransactionApplicationEvents, ReceiverThrowableType>(){

                                public void receive(TransactionApplicationEvents item) throws Throwable {
                                    receiver.receive((Object)item);
                                    ((DomainEventTrackerConfiguration)ApplicationTransactionTracker.this.configuration.get()).lastOffset().set(item.timestamp().get());
                                    ApplicationTransactionTracker.this.configuration.save();
                                }
                            });
                        }
                    });
                }
                catch (Throwable receiverThrowableType) {
                    ApplicationTransactionTracker.this.upToSpeed = false;
                    throw receiverThrowableType;
                }
            }
        };
    }
}

