/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.factory;

import java.io.IOException;
import java.util.List;
import org.qi4j.api.Qi4j;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Application;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCallback;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Inputs;
import org.qi4j.io.Output;
import org.qi4j.library.eventsourcing.domain.api.DomainEventValue;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.factory.DomainEventFactory;
import org.qi4j.library.eventsourcing.domain.factory.UnitOfWorkEvents;
import org.qi4j.library.eventsourcing.domain.source.EventStore;
import org.qi4j.library.eventsourcing.domain.source.UnitOfWorkEventsVisitor;
import org.qi4j.library.eventsourcing.domain.spi.CurrentUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWorkNotificationConcern
extends ConcernOf<DomainEventFactory>
implements DomainEventFactory {
    @Service
    EventStore eventStore;
    @Service
    Iterable<UnitOfWorkEventsVisitor> transactionVisitors;
    @Service
    CurrentUser currentUser;
    @Structure
    ValueBuilderFactory vbf;
    @Structure
    UnitOfWorkFactory uowf;
    @Structure
    Qi4j api;
    String version;
    Logger logger = LoggerFactory.getLogger(DomainEventFactory.class);
    Output<UnitOfWorkDomainEventsValue, IOException> eventOutput;

    public void init(@Structure Application application) {
        this.version = application.version();
        this.eventOutput = this.eventStore.storeEvents();
    }

    @Override
    public DomainEventValue createEvent(EntityComposite entity, String name, Object[] args) {
        final UnitOfWork unitOfWork = this.uowf.currentUnitOfWork();
        DomainEventValue eventValue = ((DomainEventFactory)this.next).createEvent((EntityComposite)this.api.dereference((Object)entity), name, args);
        UnitOfWorkEvents events = (UnitOfWorkEvents)unitOfWork.metaInfo(UnitOfWorkEvents.class);
        if (events == null) {
            events = new UnitOfWorkEvents();
            unitOfWork.setMetaInfo((Object)events);
            unitOfWork.addUnitOfWorkCallback(new UnitOfWorkCallback(){
                String user;

                public void beforeCompletion() throws UnitOfWorkCompletionException {
                    this.user = UnitOfWorkNotificationConcern.this.currentUser.getCurrentUser();
                }

                public void afterCompletion(UnitOfWorkCallback.UnitOfWorkStatus status) {
                    if (status.equals((Object)UnitOfWorkCallback.UnitOfWorkStatus.COMPLETED)) {
                        UnitOfWorkEvents events = (UnitOfWorkEvents)unitOfWork.metaInfo(UnitOfWorkEvents.class);
                        ValueBuilder builder = UnitOfWorkNotificationConcern.this.vbf.newValueBuilder(UnitOfWorkDomainEventsValue.class);
                        ((UnitOfWorkDomainEventsValue)builder.prototype()).user().set((Object)this.user);
                        ((UnitOfWorkDomainEventsValue)builder.prototype()).timestamp().set((Object)System.currentTimeMillis());
                        ((UnitOfWorkDomainEventsValue)builder.prototype()).usecase().set((Object)unitOfWork.usecase().name());
                        ((UnitOfWorkDomainEventsValue)builder.prototype()).version().set((Object)UnitOfWorkNotificationConcern.this.version);
                        ((List)((UnitOfWorkDomainEventsValue)builder.prototype()).events().get()).addAll(events.getEventValues());
                        try {
                            UnitOfWorkDomainEventsValue unitOfWorkDomainValue = (UnitOfWorkDomainEventsValue)builder.newInstance();
                            Inputs.iterable((Iterable)Iterables.iterable((Object[])new UnitOfWorkDomainEventsValue[]{unitOfWorkDomainValue})).transferTo(UnitOfWorkNotificationConcern.this.eventOutput);
                            for (UnitOfWorkEventsVisitor unitOfWorkEventsVisitor : UnitOfWorkNotificationConcern.this.transactionVisitors) {
                                try {
                                    unitOfWorkEventsVisitor.visit(unitOfWorkDomainValue);
                                }
                                catch (Exception e) {
                                    UnitOfWorkNotificationConcern.this.logger.warn("Could not deliver events", (Throwable)e);
                                }
                            }
                        }
                        catch (IOException e) {
                            UnitOfWorkNotificationConcern.this.logger.error("Could not store events", (Throwable)e);
                        }
                    }
                }
            });
        }
        events.add(eventValue);
        return eventValue;
    }
}

