/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueType;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.eventsourcing.domain.api.DomainEventValue;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.source.EventStore;
import org.qi4j.library.eventsourcing.domain.source.EventStoreActivation;
import org.qi4j.library.eventsourcing.domain.source.EventStream;
import org.qi4j.library.eventsourcing.domain.source.UnitOfWorkEventsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventStoreMixin
implements EventStore,
EventStream,
EventStoreActivation {
    @This
    protected Identity identity;
    protected Logger logger;
    protected ValueType domainEventType;
    protected ValueType eventsType;
    protected Lock lock = new ReentrantLock();
    @Structure
    protected Module module;
    private ExecutorService transactionNotifier;
    private final List<UnitOfWorkEventsListener> listeners = Collections.synchronizedList(new ArrayList());

    @Override
    public void activateEventStore() throws Exception {
        this.logger = LoggerFactory.getLogger((String)((String)this.identity.identity().get()));
        this.domainEventType = this.module.valueDescriptor(DomainEventValue.class.getName()).valueType();
        this.eventsType = this.module.valueDescriptor(UnitOfWorkDomainEventsValue.class.getName()).valueType();
        this.transactionNotifier = Executors.newSingleThreadExecutor();
    }

    @Override
    public void passivateEventStore() throws Exception {
        this.transactionNotifier.shutdown();
        this.transactionNotifier.awaitTermination(10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Output<UnitOfWorkDomainEventsValue, IOException> storeEvents() {
        final Output<UnitOfWorkDomainEventsValue, IOException> storeOutput = this.storeEvents0();
        return new Output<UnitOfWorkDomainEventsValue, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <SenderThrowableType extends Throwable> void receiveFrom(final Sender<? extends UnitOfWorkDomainEventsValue, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                final ArrayList events = new ArrayList();
                AbstractEventStoreMixin.this.lock();
                try {
                    storeOutput.receiveFrom(new Sender<UnitOfWorkDomainEventsValue, SenderThrowableType>(){

                        public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super UnitOfWorkDomainEventsValue, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                            sender.sendTo(new Receiver<UnitOfWorkDomainEventsValue, ReceiverThrowableType>(){

                                public void receive(UnitOfWorkDomainEventsValue item) throws Throwable {
                                    receiver.receive((Object)item);
                                    events.add(item);
                                }
                            });
                        }
                    });
                }
                finally {
                    AbstractEventStoreMixin.this.lock.unlock();
                }
                AbstractEventStoreMixin.this.transactionNotifier.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List list = AbstractEventStoreMixin.this.listeners;
                        synchronized (list) {
                            for (UnitOfWorkEventsListener listener : AbstractEventStoreMixin.this.listeners) {
                                try {
                                    listener.notifyTransactions(events);
                                }
                                catch (Exception e) {
                                    AbstractEventStoreMixin.this.logger.warn("Could not notify event listener", (Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
        };
    }

    @Override
    public void registerListener(UnitOfWorkEventsListener subscriber) {
        this.listeners.add(subscriber);
    }

    @Override
    public void unregisterListener(UnitOfWorkEventsListener subscriber) {
        this.listeners.remove(subscriber);
    }

    protected abstract Output<UnitOfWorkDomainEventsValue, IOException> storeEvents0();

    protected void lock() {
        while (true) {
            try {
                this.lock.tryLock(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

