/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.source.helper;

import org.qi4j.api.configuration.Configuration;
import org.qi4j.functional.Function;
import org.qi4j.io.Output;
import org.qi4j.io.Transforms;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.source.EventSource;
import org.qi4j.library.eventsourcing.domain.source.EventStream;
import org.qi4j.library.eventsourcing.domain.source.UnitOfWorkEventsListener;
import org.qi4j.library.eventsourcing.domain.source.helper.DomainEventTrackerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainEventTracker
implements Runnable,
UnitOfWorkEventsListener {
    private Configuration<? extends DomainEventTrackerConfiguration> configuration;
    private final Output<UnitOfWorkDomainEventsValue, ? extends Throwable> output;
    private EventStream stream;
    private EventSource source;
    private boolean started = false;
    private Logger logger;

    public DomainEventTracker(EventStream stream, EventSource source, Configuration<? extends DomainEventTrackerConfiguration> configuration, Output<UnitOfWorkDomainEventsValue, ? extends Throwable> output) {
        this.stream = stream;
        this.configuration = configuration;
        this.output = output;
        this.source = source;
        this.logger = LoggerFactory.getLogger((String)((String)((DomainEventTrackerConfiguration)configuration.get()).identity().get()));
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.run();
            this.stream.registerListener(this);
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            this.stream.unregisterListener(this);
        }
    }

    @Override
    public synchronized void run() {
        if (this.started && ((Boolean)((DomainEventTrackerConfiguration)this.configuration.get()).enabled().get()).booleanValue()) {
            Transforms.Counter counter = new Transforms.Counter();
            try {
                long currentOffset = (Long)((DomainEventTrackerConfiguration)this.configuration.get()).lastOffset().get();
                this.source.events(currentOffset, Long.MAX_VALUE).transferTo(Transforms.map((Function)counter, this.output));
                ((DomainEventTrackerConfiguration)this.configuration.get()).lastOffset().set((Object)(currentOffset + counter.count()));
                this.configuration.save();
            }
            catch (Throwable throwable) {
                this.logger.warn("Event handling failed", throwable);
            }
        }
    }

    @Override
    public void notifyTransactions(Iterable<UnitOfWorkDomainEventsValue> transactions) {
        this.run();
    }
}

