/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.source.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.source.AbstractEventStoreMixin;
import org.qi4j.library.eventsourcing.domain.source.EventSource;
import org.qi4j.library.eventsourcing.domain.source.EventStore;
import org.qi4j.library.eventsourcing.domain.source.EventStoreActivation;
import org.qi4j.library.eventsourcing.domain.source.EventStream;

@Mixins(value={MemoryEventStoreMixin.class})
@Activators(value={EventStoreActivation.Activator.class})
public interface MemoryEventStoreService
extends EventSource,
EventStore,
EventStream,
EventStoreActivation,
ServiceComposite {

    public static abstract class MemoryEventStoreMixin
    extends AbstractEventStoreMixin
    implements EventSource,
    EventStoreActivation {
        private LinkedList<UnitOfWorkDomainEventsValue> store = new LinkedList();
        private long currentCount = 0L;

        @Override
        public Input<UnitOfWorkDomainEventsValue, IOException> events(final long offset, final long limit) {
            if (offset < 0L || offset > this.count()) {
                throw new IllegalArgumentException("Offset must be between 0 and current number of events in the store");
            }
            if (limit <= 0L) {
                throw new IllegalArgumentException("Limit must be above 0");
            }
            return new Input<UnitOfWorkDomainEventsValue, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super UnitOfWorkDomainEventsValue, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                    MemoryEventStoreMixin.this.lock.lock();
                    try {
                        output.receiveFrom((Sender)new Sender<UnitOfWorkDomainEventsValue, IOException>(){

                            public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super UnitOfWorkDomainEventsValue, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                                ListIterator iterator = MemoryEventStoreMixin.this.store.listIterator((int)offset);
                                for (long count = 0L; iterator.hasNext() && count < limit; ++count) {
                                    UnitOfWorkDomainEventsValue next = (UnitOfWorkDomainEventsValue)iterator.next();
                                    receiver.receive((Object)next);
                                }
                            }
                        });
                    }
                    finally {
                        MemoryEventStoreMixin.this.lock.unlock();
                    }
                }
            };
        }

        @Override
        public long count() {
            return this.currentCount;
        }

        @Override
        protected Output<UnitOfWorkDomainEventsValue, IOException> storeEvents0() {
            return new Output<UnitOfWorkDomainEventsValue, IOException>(){

                public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends UnitOfWorkDomainEventsValue, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                    final ArrayList newEvents = new ArrayList();
                    sender.sendTo((Receiver)new Receiver<UnitOfWorkDomainEventsValue, IOException>(){

                        public void receive(UnitOfWorkDomainEventsValue item) throws IOException {
                            newEvents.add(item);
                        }
                    });
                    MemoryEventStoreMixin.this.store.addAll(newEvents);
                    MemoryEventStoreMixin.this.currentCount += newEvents.size();
                }
            };
        }
    }
}

