/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.qi4j.api.common.Optional;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.functional.Specification;
import org.qi4j.index.sql.support.api.SQLQuerying;
import org.qi4j.library.sql.common.SQLUtil;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;

public class SQLEntityFinder
implements EntityFinder {
    @Service
    private SQLQuerying parser;
    @Service
    private DataSource _dataSource;

    public long countEntities(Class<?> resultType, @Optional Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
        final ArrayList<Object> values = new ArrayList<Object>();
        final ArrayList<Integer> valueSQLTypes = new ArrayList<Integer>();
        final String query = this.parser.constructQuery(resultType, whereClause, null, null, null, variables, values, valueSQLTypes, true);
        return this.performQuery(new DoQuery<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long doIt(Connection connection) throws SQLException {
                Long l;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = SQLEntityFinder.this.createPS(connection, query, values, valueSQLTypes);
                    rs = ps.executeQuery();
                    rs.next();
                    l = rs.getLong(1);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(rs);
                    SQLUtil.closeQuietly(ps);
                    throw throwable;
                }
                SQLUtil.closeQuietly((ResultSet)rs);
                SQLUtil.closeQuietly((Statement)ps);
                return l;
            }
        });
    }

    public Iterable<EntityReference> findEntities(Class<?> resultType, @Optional Specification<Composite> whereClause, @Optional OrderBy[] orderBySegments, final @Optional Integer firstResult, final @Optional Integer maxResults, Map<String, Object> variables) throws EntityFinderException {
        Iterable<EntityReference> result;
        if (maxResults == null || maxResults > 0) {
            final ArrayList<Object> values = new ArrayList<Object>();
            final ArrayList<Integer> valueSQLTypes = new ArrayList<Integer>();
            final String query = this.parser.constructQuery(resultType, whereClause, orderBySegments, firstResult, maxResults, variables, values, valueSQLTypes, false);
            result = this.performQuery(new DoQuery<Iterable<EntityReference>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Iterable<EntityReference> doIt(Connection connection) throws SQLException {
                    PreparedStatement ps = null;
                    ResultSet rs = null;
                    ArrayList<EntityReference> resultList = new ArrayList<EntityReference>(maxResults == null ? 100 : maxResults);
                    try {
                        Integer rsType = SQLEntityFinder.this.parser.getResultSetType(firstResult, maxResults);
                        ps = SQLEntityFinder.this.createPS(connection, query, values, valueSQLTypes, rsType, 2);
                        rs = ps.executeQuery();
                        if (firstResult != null && !SQLEntityFinder.this.parser.isFirstResultSettingSupported().booleanValue() && rsType != 1003) {
                            rs.absolute(firstResult);
                        }
                        Integer i = 0;
                        while (rs.next() && (maxResults == null || i < maxResults)) {
                            resultList.add(new EntityReference(rs.getString(1)));
                            i = i + 1;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtil.closeQuietly(rs);
                        SQLUtil.closeQuietly(ps);
                        throw throwable;
                    }
                    SQLUtil.closeQuietly((ResultSet)rs);
                    SQLUtil.closeQuietly((Statement)ps);
                    return resultList;
                }
            });
        } else {
            result = new ArrayList<EntityReference>(0);
        }
        return result;
    }

    public EntityReference findEntity(Class<?> resultType, @Optional Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
        final ArrayList<Object> values = new ArrayList<Object>();
        final ArrayList<Integer> valueSQLTypes = new ArrayList<Integer>();
        final String query = this.parser.constructQuery(resultType, whereClause, null, null, null, variables, values, valueSQLTypes, false);
        return this.performQuery(new DoQuery<EntityReference>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EntityReference doIt(Connection connection) throws SQLException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                EntityReference result = null;
                try {
                    ps = SQLEntityFinder.this.createPS(connection, query, values, valueSQLTypes);
                    ps.setFetchSize(1);
                    ps.setMaxRows(1);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        result = new EntityReference(rs.getString(1));
                    }
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(rs);
                    SQLUtil.closeQuietly(ps);
                    throw throwable;
                }
                SQLUtil.closeQuietly((ResultSet)rs);
                SQLUtil.closeQuietly((Statement)ps);
                return result;
            }
        });
    }

    private PreparedStatement createPS(Connection connection, String query, List<Object> values, List<Integer> valueSQLTypes) throws SQLException {
        return this.createPS(connection, query, values, valueSQLTypes, 1003, 2);
    }

    private PreparedStatement createPS(Connection connection, String query, List<Object> values, List<Integer> valueSQLTypes, Integer resultSetType, Integer resultSetHoldability) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(query, resultSetType, 1007, resultSetHoldability);
        if (values.size() != valueSQLTypes.size()) {
            throw new InternalError("There was either too little or too much sql types for values [values=" + values.size() + ", types=" + valueSQLTypes.size() + "].");
        }
        Integer x = 0;
        while (x < values.size()) {
            ps.setObject(x + 1, values.get(x), valueSQLTypes.get(x));
            x = x + 1;
        }
        return ps;
    }

    private <ReturnType> ReturnType performQuery(DoQuery<ReturnType> doQuery) throws EntityFinderException {
        ReturnType result = null;
        Connection connection = null;
        try {
            connection = this._dataSource.getConnection();
            connection.setReadOnly(true);
            result = doQuery.doIt(connection);
        }
        catch (SQLException sqle) {
            throw new EntityFinderException((Throwable)sqle);
        }
        finally {
            SQLUtil.closeQuietly((Connection)connection);
        }
        return result;
    }

    private static interface DoQuery<ReturnType> {
        public ReturnType doIt(Connection var1) throws SQLException;
    }
}

