/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.common;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.library.sql.common.SQLUtil;
import org.sql.generation.api.grammar.builders.query.QuerySpecificationBuilder;
import org.sql.generation.api.grammar.builders.query.TableReferenceBuilder;
import org.sql.generation.api.grammar.common.SQLStatement;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.query.QueryExpressionBody;
import org.sql.generation.api.grammar.query.TableReferencePrimary;
import org.sql.generation.api.vendor.SQLVendor;

public final class GenericDatabaseExplorer {
    private static final Map<Integer, IntegrityActions> INTEGRITY_ACTIONS;
    private static final Map<Integer, Deferrability> DEFERRABILITIES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitDatabaseTables(Connection connection, String catalogName, String schemaNamePattern, String tableNamePattern, DatabaseProcessor processor, SQLVendor sqlSyntaxVendor) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        connection.setReadOnly(true);
        ResultSet rs = metaData.getTables(catalogName, schemaNamePattern, tableNamePattern, new String[]{"TABLE"});
        try {
            while (rs.next()) {
                String schemaName = rs.getString(2);
                try {
                    processor.beginProcessSchemaInfo(schemaName);
                    String tableName = rs.getString(3);
                    String tableRemarks = rs.getString(5);
                    try {
                        processor.beginProcessTableInfo(schemaName, tableName, tableRemarks);
                        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
                        try (ResultSet rsCols = metaData.getColumns(null, schemaName, tableName, null);){
                            while (rsCols.next()) {
                                String nullable = rsCols.getString(18);
                                colInfos.add(new ColumnInfo(rsCols.getString(4), rsCols.getInt(5), rsCols.getString(6), rsCols.getInt(7), rsCols.getInt(9), nullable.length() > 0 ? Boolean.toString(nullable.equals("YES")) : "unknown", rsCols.getString(13), rsCols.getString(12)));
                            }
                        }
                        rsCols = metaData.getImportedKeys(null, schemaName, tableName);
                        HashMap<String, ForeignKeyInfo> fkInfos = new HashMap<String, ForeignKeyInfo>();
                        try {
                            while (rsCols.next()) {
                                fkInfos.put(rsCols.getString(8), new ForeignKeyInfo(rsCols.getString(2), rsCols.getString(3), rsCols.getString(4), rsCols.getShort(10), rsCols.getShort(11), rsCols.getShort(14)));
                            }
                        }
                        finally {
                            rsCols.close();
                        }
                        try {
                            processor.beginProcessColumns(schemaName, tableName, tableRemarks);
                            for (ColumnInfo colInfo : colInfos) {
                                try {
                                    processor.beginProcessColumnInfo(schemaName, tableName, colInfo, (ForeignKeyInfo)fkInfos.get(colInfo._name));
                                }
                                finally {
                                    processor.endProcessColumnInfo(schemaName, tableName, colInfo, (ForeignKeyInfo)fkInfos.get(colInfo._name));
                                }
                            }
                        }
                        finally {
                            processor.endProcessColumns(schemaName, tableName, tableRemarks);
                        }
                        QueryFactory q = sqlSyntaxVendor.getQueryFactory();
                        TableReferenceFactory t = sqlSyntaxVendor.getTableReferenceFactory();
                        QuerySpecificationBuilder builda = q.querySpecificationBuilder();
                        builda.getSelect().selectAll();
                        builda.getFrom().addTableReferences(new TableReferenceBuilder[]{t.tableBuilder((TableReferencePrimary)t.table((TableName)t.tableName(schemaName, tableName)))});
                        String sql = sqlSyntaxVendor.toString((SQLStatement)q.createQuery((QueryExpressionBody)builda.createExpression()));
                        Statement stmt = connection.createStatement();
                        ResultSet rowsRs = null;
                        try {
                            rowsRs = stmt.executeQuery(sql);
                            processor.beginProcessRows(schemaName, tableName, tableRemarks);
                            while (rowsRs.next()) {
                                Object[] rowContents = new Object[colInfos.size()];
                                Integer x = 0;
                                while (x < rowContents.length) {
                                    rowContents[x.intValue()] = rowsRs.getObject(x + 1);
                                    x = x + 1;
                                }
                                try {
                                    processor.beginProcessRowInfo(schemaName, tableName, rowContents);
                                }
                                finally {
                                    processor.endProcessRowInfo(schemaName, tableName, rowContents);
                                }
                            }
                        }
                        finally {
                            processor.endProcessRows(schemaName, tableName, tableRemarks);
                            if (rowsRs != null) {
                                rowsRs.close();
                            }
                            stmt.close();
                        }
                    }
                    finally {
                        processor.endProcessTableInfo(schemaName, tableName, tableRemarks);
                    }
                }
                finally {
                    processor.endProcessSchemaInfo(schemaName);
                }
            }
        }
        finally {
            SQLUtil.closeQuietly((ResultSet)rs);
        }
    }

    private GenericDatabaseExplorer() {
    }

    static {
        DEFERRABILITIES = new HashMap<Integer, Deferrability>(3);
        DEFERRABILITIES.put(5, Deferrability.INITIALLY_DEFERRED);
        DEFERRABILITIES.put(6, Deferrability.INITIALLY_IMMEDIATE);
        DEFERRABILITIES.put(7, Deferrability.NOT_DEFERRABLE);
        INTEGRITY_ACTIONS = new HashMap<Integer, IntegrityActions>(5);
        INTEGRITY_ACTIONS.put(0, IntegrityActions.CASCADE);
        INTEGRITY_ACTIONS.put(3, IntegrityActions.NO_ACTION);
        INTEGRITY_ACTIONS.put(1, IntegrityActions.RESTRICT);
        INTEGRITY_ACTIONS.put(4, IntegrityActions.SET_DEFAULT);
        INTEGRITY_ACTIONS.put(2, IntegrityActions.SET_NULL);
    }

    public static abstract class DatabaseProcessorAdapter
    implements DatabaseProcessor {
        @Override
        public void beginProcessColumnInfo(String schemaName, String tableName, ColumnInfo colInfo, ForeignKeyInfo fkInfo) {
        }

        @Override
        public void beginProcessColumns(String schemaName, String tableName, String tableRemarks) {
        }

        @Override
        public void beginProcessRowInfo(String schemaName, String tableName, Object[] rowContents) {
        }

        @Override
        public void beginProcessRows(String schemaName, String tableName, String tableRemarks) {
        }

        @Override
        public void beginProcessSchemaInfo(String schemaName) {
        }

        @Override
        public void beginProcessTableInfo(String schemaName, String tableName, String remarks) {
        }

        @Override
        public void endProcessColumnInfo(String schemaName, String tableName, ColumnInfo colInfo, ForeignKeyInfo fkInfo) {
        }

        @Override
        public void endProcessColumns(String schemaName, String tableName, String tableRemarks) {
        }

        @Override
        public void endProcessRowInfo(String schemaName, String tableName, Object[] rowContents) {
        }

        @Override
        public void endProcessRows(String schemaName, String tableName, String tableRemarks) {
        }

        @Override
        public void endProcessSchemaInfo(String schemaName) {
        }

        @Override
        public void endProcessTableInfo(String schemaName, String tableName, String remarks) {
        }
    }

    public static interface DatabaseProcessor {
        public void beginProcessSchemaInfo(String var1);

        public void endProcessSchemaInfo(String var1);

        public void beginProcessTableInfo(String var1, String var2, String var3);

        public void endProcessTableInfo(String var1, String var2, String var3);

        public void beginProcessColumns(String var1, String var2, String var3);

        public void beginProcessColumnInfo(String var1, String var2, ColumnInfo var3, ForeignKeyInfo var4);

        public void endProcessColumnInfo(String var1, String var2, ColumnInfo var3, ForeignKeyInfo var4);

        public void endProcessColumns(String var1, String var2, String var3);

        public void beginProcessRows(String var1, String var2, String var3);

        public void beginProcessRowInfo(String var1, String var2, Object[] var3);

        public void endProcessRowInfo(String var1, String var2, Object[] var3);

        public void endProcessRows(String var1, String var2, String var3);
    }

    public static class ForeignKeyInfo {
        private final String _pkSchemaName;
        private final String _pkTableName;
        private final String _pkTablePKColumnName;
        private final IntegrityActions _onUpdateAction;
        private final IntegrityActions _onDeleteAction;
        private final Deferrability _deferrability;

        private ForeignKeyInfo(String pkSchemaName, String pkTableName, String pkTablePKColumnName, short onUpdate, short onDelete, short deferrability) {
            this._pkSchemaName = pkSchemaName;
            this._pkTableName = pkTableName;
            this._pkTablePKColumnName = pkTablePKColumnName;
            this._onUpdateAction = (IntegrityActions)((Object)INTEGRITY_ACTIONS.get(onUpdate));
            this._onDeleteAction = (IntegrityActions)((Object)INTEGRITY_ACTIONS.get(onDelete));
            this._deferrability = (Deferrability)((Object)DEFERRABILITIES.get(deferrability));
        }

        public String getPkSchemaName() {
            return this._pkSchemaName;
        }

        public String getPkTableName() {
            return this._pkTableName;
        }

        public String getPkTablePKColumnName() {
            return this._pkTablePKColumnName;
        }

        public IntegrityActions getOnUpdateAction() {
            return this._onUpdateAction;
        }

        public IntegrityActions getOnDeleteAction() {
            return this._onDeleteAction;
        }

        public Deferrability getDeferrability() {
            return this._deferrability;
        }
    }

    public static class ColumnInfo {
        private final String _name;
        private final Integer _sqlType;
        private final String _typeName;
        private final Integer _size;
        private final Integer _scale;
        private final String _nullable;
        private final String _defaultValue;
        private final String _remarks;

        private ColumnInfo(String name, Integer sqlType, String typeName, Integer size, Integer scale, String nullable, String defaultValue, String remarks) {
            this._name = name;
            this._sqlType = sqlType;
            this._typeName = typeName;
            this._size = size;
            this._scale = scale;
            this._nullable = nullable;
            this._defaultValue = defaultValue;
            this._remarks = remarks;
        }

        public String getName() {
            return this._name;
        }

        public String getTypeName() {
            return this._typeName;
        }

        public Integer getSize() {
            return this._size;
        }

        public Integer getScale() {
            return this._scale;
        }

        public String getNullable() {
            return this._nullable;
        }

        public String getDefaultValue() {
            return this._defaultValue;
        }

        public String getRemarks() {
            return this._remarks;
        }

        public Integer getSQLType() {
            return this._sqlType;
        }
    }

    public static enum Deferrability {
        INITIALLY_DEFERRED,
        INITIALLY_IMMEDIATE,
        NOT_DEFERRABLE;

    }

    public static enum IntegrityActions {
        CASCADE,
        NO_ACTION,
        RESTRICT,
        SET_DEFAULT,
        SET_NULL;

    }
}

