/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.common;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.property.PropertyDescriptor;

public final class QNameInfo {
    private static final List<Class<?>> EMPTY_COLL_CLASSES = new ArrayList();
    private String _tableName;
    private final List<Class<?>> _collectionClasses;
    private final QualifiedName _qName;
    private final QNameType _qNameType;
    private final Type _finalType;
    private final Boolean _isFinalTypePrimitive;
    private final PropertyDescriptor _propertyDescriptor;
    private final AssociationDescriptor _associationDescriptor;
    private final AssociationDescriptor _manyAssociationDescriptor;

    private QNameInfo(QualifiedName qName, QNameType qNameType, List<Class<?>> collectionClasses, String tableName, Type finalType, PropertyDescriptor propertyDescriptor, AssociationDescriptor associationDescriptor, AssociationDescriptor manyAssociationDescriptor) {
        if (!(propertyDescriptor != null && associationDescriptor == null && manyAssociationDescriptor == null || propertyDescriptor == null && associationDescriptor != null && manyAssociationDescriptor == null || propertyDescriptor == null && associationDescriptor == null && manyAssociationDescriptor != null)) {
            throw new IllegalArgumentException("Exactly one of property, association, or many-association descriptors must be non-null.");
        }
        this._propertyDescriptor = propertyDescriptor;
        this._associationDescriptor = associationDescriptor;
        this._manyAssociationDescriptor = manyAssociationDescriptor;
        this._qName = qName;
        this._qNameType = qNameType;
        this._collectionClasses = collectionClasses == null || collectionClasses.isEmpty() ? EMPTY_COLL_CLASSES : collectionClasses;
        this._tableName = tableName;
        this._finalType = finalType;
        Boolean isFinalTypePrimitive = false;
        if (finalType instanceof Class) {
            Class finalClass = (Class)finalType;
            isFinalTypePrimitive = Number.class.isAssignableFrom(finalClass) || Boolean.class.isAssignableFrom(finalClass) || Character.class.isAssignableFrom(finalClass) || Date.class.isAssignableFrom(finalClass) || Enum.class.isAssignableFrom(finalClass) || String.class.isAssignableFrom(finalClass);
        }
        this._isFinalTypePrimitive = isFinalTypePrimitive;
    }

    public Integer getCollectionDepth() {
        return this._collectionClasses.size();
    }

    public Type getFinalType() {
        return this._finalType;
    }

    public QualifiedName getQName() {
        return this._qName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name must not be null.");
        }
        if (this._tableName != null) {
            throw new IllegalStateException("Can only set table name when it is null.");
        }
        this._tableName = tableName;
    }

    public Boolean isFinalTypePrimitive() {
        return this._isFinalTypePrimitive;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this._propertyDescriptor;
    }

    public AssociationDescriptor getAssociationDescriptor() {
        return this._associationDescriptor;
    }

    public AssociationDescriptor getManyAssociationDescriptor() {
        return this._manyAssociationDescriptor;
    }

    public QNameType getQNameType() {
        return this._qNameType;
    }

    public static QNameInfo fromProperty(QualifiedName qName, String tableName, PropertyDescriptor propertyDescriptor) {
        Type vType = propertyDescriptor.type();
        ArrayList collectionClasses = new ArrayList();
        while (vType instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)vType).getRawType())) {
            collectionClasses.add((Class)((ParameterizedType)vType).getRawType());
            vType = ((ParameterizedType)vType).getActualTypeArguments()[0];
        }
        return new QNameInfo(qName, QNameType.PROPERTY, collectionClasses, tableName, vType, propertyDescriptor, null, null);
    }

    public static QNameInfo fromAssociation(QualifiedName qName, String tableName, AssociationDescriptor assoDescriptor) {
        return new QNameInfo(qName, QNameType.ASSOCIATION, null, tableName, assoDescriptor.type(), null, assoDescriptor, null);
    }

    public static QNameInfo fromManyAssociation(QualifiedName qName, String tableName, AssociationDescriptor manyAssoDescriptor) {
        return new QNameInfo(qName, QNameType.MANY_ASSOCIATION, null, tableName, manyAssoDescriptor.type(), null, null, manyAssoDescriptor);
    }

    public String toString() {
        return "[table: " + this._tableName + ", final type: " + this._finalType + ", qNameType: " + (Object)((Object)this._qNameType) + ", qName: " + this._qName + "]";
    }

    public static enum QNameType {
        PROPERTY,
        ASSOCIATION,
        MANY_ASSOCIATION;

    }
}

