/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.postgresql;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.index.sql.support.common.GenericDatabaseExplorer;
import org.qi4j.index.sql.support.skeletons.SQLDBState;
import org.qi4j.library.sql.common.SQLUtil;
import org.qi4j.spi.query.IndexExporter;
import org.sql.generation.api.vendor.SQLVendor;

public class PostgreSQLIndexExporter
implements IndexExporter {
    @This
    private SQLDBState _state;
    @Uses
    private ServiceDescriptor descriptor;
    @Service
    private DataSource _dataSource;
    private static final String SEPARATOR = "-----------------------------------------------";
    private static final Map<Integer, String> TYPE_STRINGS = new HashMap<Integer, String>(16);

    public void exportFormalToWriter(final PrintWriter out) throws IOException, UnsupportedOperationException {
        Connection connection = null;
        try {
            connection = this._dataSource.getConnection();
            GenericDatabaseExplorer.visitDatabaseTables(connection, null, (String)this._state.schemaName().get(), null, new GenericDatabaseExplorer.DatabaseProcessor(){

                @Override
                public void endProcessColumns(String schemaName, String tableName, String tableRemarks) {
                    out.write("</columns>\n");
                }

                @Override
                public void endProcessRows(String schemaName, String tableName, String tableRemarks) {
                    out.write("</rows>\n");
                }

                @Override
                public void endProcessTableInfo(String schemaName, String tableName, String tableRemarks) {
                    out.write("</table>\n");
                }

                @Override
                public void endProcessSchemaInfo(String schemaName) {
                    out.write("</schema>\n");
                }

                @Override
                public void endProcessRowInfo(String schemaName, String tableName, Object[] rowContents) {
                    out.write("</row>\n");
                }

                @Override
                public void endProcessColumnInfo(String schemaName, String tableName, GenericDatabaseExplorer.ColumnInfo colInfo, GenericDatabaseExplorer.ForeignKeyInfo fkInfo) {
                }

                @Override
                public void beginProcessTableInfo(String schemaName, String tableName, String tableRemarks) {
                    out.write("<table name=\"" + tableName + "\" remarks=\"" + tableRemarks + "\">" + "\n");
                }

                @Override
                public void beginProcessColumns(String schemaName, String tableName, String tableRemarks) {
                    out.write("<columns>\n");
                }

                @Override
                public void beginProcessColumnInfo(String schemaName, String tableName, GenericDatabaseExplorer.ColumnInfo colInfo, GenericDatabaseExplorer.ForeignKeyInfo fkInfo) {
                    String defaultValue = colInfo.getDefaultValue();
                    if (defaultValue.startsWith("'")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    out.write("<column name=\"" + colInfo.getName() + "\" colType=\"" + colInfo.getTypeName() + "\" colSize=\"" + colInfo.getSize() + "\" colScale=\"" + colInfo.getScale() + "\" nullable=\"" + colInfo.getNullable() + "\" default=\"" + defaultValue + "\" ");
                    if (fkInfo != null) {
                        out.write("refSchemaName=\"" + fkInfo.getPkSchemaName() + "\" refTableName=\"" + fkInfo.getPkTableName() + "\" refPKColumnName=\"" + fkInfo.getPkTablePKColumnName() + "\" onUpdate=\"" + (Object)((Object)fkInfo.getOnUpdateAction()) + "\" onDelete=\"" + (Object)((Object)fkInfo.getOnDeleteAction()) + "\" deferrability=\"" + (Object)((Object)fkInfo.getDeferrability()) + "\" ");
                    }
                    out.write("/>\n");
                }

                @Override
                public void beginProcessSchemaInfo(String schemaName) {
                    out.write("<schema name=\"" + schemaName + "\">" + "\n");
                }

                @Override
                public void beginProcessRows(String schemaName, String tableName, String tableRemarks) {
                    out.write("<rows>\n");
                }

                @Override
                public void beginProcessRowInfo(String schemaName, String tableName, Object[] rowContents) {
                    out.write("<row>\n");
                    Integer x = 0;
                    while (x < rowContents.length) {
                        out.write("<value index=\"" + x + "\" >" + rowContents[x] + "</value>" + "\n");
                        x = x + 1;
                    }
                }
            }, (SQLVendor)this.descriptor.metaInfo(SQLVendor.class));
        }
        catch (SQLException sqle) {
            throw new IOException(sqle);
        }
        finally {
            SQLUtil.closeQuietly((Connection)connection);
        }
    }

    public void exportReadableToStream(final PrintStream out) throws IOException, UnsupportedOperationException {
        Connection connection = null;
        try {
            connection = this._dataSource.getConnection();
            GenericDatabaseExplorer.visitDatabaseTables(connection, null, (String)this._state.schemaName().get(), null, new GenericDatabaseExplorer.DatabaseProcessor(){

                @Override
                public void endProcessTableInfo(String schemaName, String tableName, String tableRemarks) {
                    out.print("\n\n\n");
                }

                @Override
                public void endProcessSchemaInfo(String schemaName) {
                    out.print("\n\n");
                }

                @Override
                public void endProcessRowInfo(String schemaName, String tableName, Object[] rowContents) {
                }

                @Override
                public void endProcessColumnInfo(String schemaName, String tableName, GenericDatabaseExplorer.ColumnInfo colInfo, GenericDatabaseExplorer.ForeignKeyInfo fkInfo) {
                }

                @Override
                public void endProcessColumns(String schemaName, String tableName, String tableRemarks) {
                    out.print("-----------------------------------------------\n-----------------------------------------------\n");
                }

                @Override
                public void endProcessRows(String schemaName, String tableName, String tableRemarks) {
                    out.print("-----------------------------------------------\n-----------------------------------------------\n");
                }

                private String parseSQLType(GenericDatabaseExplorer.ColumnInfo colInfo) {
                    String result = colInfo.getTypeName();
                    Integer sqlType = colInfo.getSQLType();
                    if (TYPE_STRINGS.containsKey(sqlType)) {
                        result = (String)TYPE_STRINGS.get(sqlType);
                        if (sqlType == 3 || sqlType == 2) {
                            result = result + "(" + colInfo.getSize() + ", " + colInfo.getScale() + ")";
                        } else if (sqlType == 12 || sqlType == -3) {
                            result = result + "(" + colInfo.getSize() + ")";
                        }
                    }
                    return result;
                }

                @Override
                public void beginProcessColumnInfo(String schemaName, String tableName, GenericDatabaseExplorer.ColumnInfo colInfo, GenericDatabaseExplorer.ForeignKeyInfo fkInfo) {
                    out.print(colInfo.getName() + ":" + this.parseSQLType(colInfo) + "[nullable:" + colInfo.getNullable() + "; default: " + colInfo.getDefaultValue() + "]");
                    if (fkInfo != null) {
                        out.print(" -> " + fkInfo.getPkSchemaName() + "." + fkInfo.getPkTableName() + "(" + fkInfo.getPkTablePKColumnName() + ")[ON UPDATE " + (Object)((Object)fkInfo.getOnUpdateAction()) + ", ON DELETE " + (Object)((Object)fkInfo.getOnDeleteAction()) + ", " + (Object)((Object)fkInfo.getDeferrability()) + "]");
                    }
                    out.print("\n");
                }

                @Override
                public void beginProcessTableInfo(String schemaName, String tableName, String tableRemarks) {
                    out.print("Table: " + schemaName + "." + tableName + (tableRemarks == null ? "" : " (" + tableRemarks + ")") + "\n");
                }

                @Override
                public void beginProcessSchemaInfo(String schemaName) {
                    out.print("\n\nSchema: " + schemaName + "\n" + PostgreSQLIndexExporter.SEPARATOR + "\n\n\n");
                }

                @Override
                public void beginProcessRowInfo(String schemaName, String tableName, Object[] rowContents) {
                    Integer x = 0;
                    while (x < rowContents.length) {
                        Object value = rowContents[x];
                        out.print(value == null ? "NULL" : "\"" + value + "\"");
                        if (x + 1 < rowContents.length) {
                            out.print(" ; ");
                        }
                        x = x + 1;
                    }
                    out.print("\n");
                }

                @Override
                public void beginProcessColumns(String schemaName, String tableName, String tableRemarks) {
                    out.print("-----------------------------------------------\n-----------------------------------------------\n");
                }

                @Override
                public void beginProcessRows(String schemaName, String tableName, String tableRemarks) {
                }
            }, (SQLVendor)this.descriptor.metaInfo(SQLVendor.class));
        }
        catch (SQLException sqle) {
            throw new IOException(sqle);
        }
        finally {
            SQLUtil.closeQuietly((Connection)connection);
        }
    }

    static {
        TYPE_STRINGS.put(-5, "BIGINT");
        TYPE_STRINGS.put(16, "BOOLEAN");
        TYPE_STRINGS.put(1, "CHAR");
        TYPE_STRINGS.put(91, "DATE");
        TYPE_STRINGS.put(3, "DECIMAL");
        TYPE_STRINGS.put(8, "DOUBLE");
        TYPE_STRINGS.put(6, "FLOAT");
        TYPE_STRINGS.put(4, "INTEGER");
        TYPE_STRINGS.put(0, "NULL");
        TYPE_STRINGS.put(2, "NUMERIC");
        TYPE_STRINGS.put(7, "REAL");
        TYPE_STRINGS.put(5, "SMALLINT");
        TYPE_STRINGS.put(92, "TIME");
        TYPE_STRINGS.put(93, "TIMESTAMP");
        TYPE_STRINGS.put(12, "VARCHAR");
        TYPE_STRINGS.put(-3, "VARBINARY");
    }
}

