/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.skeletons;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.qi4j.api.Qi4j;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.structure.Application;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.index.sql.support.api.SQLIndexing;
import org.qi4j.index.sql.support.common.QNameInfo;
import org.qi4j.index.sql.support.postgresql.PostgreSQLTypeHelper;
import org.qi4j.index.sql.support.skeletons.AbstractSQLStartup;
import org.qi4j.index.sql.support.skeletons.SQLCompatEntityStateWrapper;
import org.qi4j.index.sql.support.skeletons.SQLDBState;
import org.qi4j.index.sql.support.skeletons.SQLSkeletonUtil;
import org.qi4j.library.sql.common.SQLUtil;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.builders.modification.ColumnSourceByValuesBuilder;
import org.sql.generation.api.grammar.builders.modification.DeleteBySearchBuilder;
import org.sql.generation.api.grammar.builders.modification.UpdateBySearchBuilder;
import org.sql.generation.api.grammar.builders.query.QuerySpecificationBuilder;
import org.sql.generation.api.grammar.builders.query.TableReferenceBuilder;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.common.SQLStatement;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.common.ValueExpression;
import org.sql.generation.api.grammar.factories.BooleanFactory;
import org.sql.generation.api.grammar.factories.ColumnsFactory;
import org.sql.generation.api.grammar.factories.LiteralFactory;
import org.sql.generation.api.grammar.factories.ModificationFactory;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.modification.ColumnSource;
import org.sql.generation.api.grammar.modification.DeleteStatement;
import org.sql.generation.api.grammar.modification.InsertStatement;
import org.sql.generation.api.grammar.modification.SetClause;
import org.sql.generation.api.grammar.modification.UpdateSource;
import org.sql.generation.api.grammar.modification.UpdateSourceByExpression;
import org.sql.generation.api.grammar.modification.UpdateStatement;
import org.sql.generation.api.grammar.query.ColumnReference;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.api.grammar.query.QueryExpressionBody;
import org.sql.generation.api.grammar.query.TableReferencePrimary;
import org.sql.generation.api.vendor.SQLVendor;

public abstract class AbstractSQLIndexing
implements SQLIndexing {
    public static final Integer AMOUNT_OF_COLUMNS_IN_ENTITY_TABLE = 5;
    public static final Integer AMOUNT_OF_COLUMNS_IN_ALL_QNAMES_TABLE = 2;
    public static final Integer AMOUNT_OF_COLUMNS_IN_ASSO_TABLE = 2;
    public static final Integer AMOUNT_OF_COLUMNS_IN_MANY_ASSO_TABLE = 3;
    @Structure
    private Application _app;
    @Structure
    private Qi4jSPI _qi4SPI;
    @This
    private SQLDBState _state;
    @This
    private PostgreSQLTypeHelper _sqlTypeHelper;
    @Uses
    private ServiceDescriptor descriptor;
    @Service
    private DataSource _dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void indexEntities(Iterable<EntityState> changedStates) throws SQLException {
        final String schemaName = (String)this._state.schemaName().get();
        final SQLVendor vendor = (SQLVendor)this.descriptor.metaInfo(SQLVendor.class);
        Connection connectionTest = AbstractSQLStartup.CONNECTION_FOR_REINDEXING.get();
        boolean connectionFromStartupWasNull = connectionTest == null;
        boolean wasAutoCommit = false;
        boolean wasReadOnly = false;
        if (connectionFromStartupWasNull) {
            connectionTest = this._dataSource.getConnection();
        } else {
            wasAutoCommit = connectionTest.getAutoCommit();
            wasReadOnly = connectionTest.isReadOnly();
        }
        final Connection connection = connectionTest;
        PreparedStatement updateEntityTablePS = null;
        PreparedStatement removeEntityPS = null;
        PreparedStatement insertToPropertyQNamesPS = null;
        PreparedStatement clearEntityDataPS = null;
        SQLSkeletonUtil.Lazy<PreparedStatement, SQLException> queryEntityPKPS = new SQLSkeletonUtil.Lazy<PreparedStatement, SQLException>(new SQLSkeletonUtil.LazyInit<PreparedStatement, SQLException>(){

            @Override
            public PreparedStatement create() throws SQLException {
                return connection.prepareStatement(vendor.toString((SQLStatement)AbstractSQLIndexing.this.createQueryEntityPkByIdentityStatement(schemaName, vendor)));
            }
        });
        SQLSkeletonUtil.Lazy<PreparedStatement, SQLException> insertToEntityTableAutoGenerated = new SQLSkeletonUtil.Lazy<PreparedStatement, SQLException>(new SQLSkeletonUtil.LazyInit<PreparedStatement, SQLException>(){

            @Override
            public PreparedStatement create() throws SQLException {
                return connection.prepareStatement(AbstractSQLIndexing.this.createInsertStatementWithAutoGeneratedIDForEntitiesTable(schemaName, "indexing_entities", vendor).toString());
            }
        });
        SQLSkeletonUtil.Lazy<PreparedStatement, SQLException> insertToEntityTypeTablePS = new SQLSkeletonUtil.Lazy<PreparedStatement, SQLException>(new SQLSkeletonUtil.LazyInit<PreparedStatement, SQLException>(){

            @Override
            public PreparedStatement create() throws SQLException {
                return connection.prepareStatement(AbstractSQLIndexing.this.createInsertEntityTypeStatement(schemaName, vendor).toString());
            }
        });
        HashMap<QualifiedName, PreparedStatement> qNameInsertPSs = new HashMap<QualifiedName, PreparedStatement>();
        try {
            Long pk;
            connection.setAutoCommit(false);
            connection.setReadOnly(false);
            updateEntityTablePS = connection.prepareStatement(this.createUpdateEntityTableStatement(schemaName, vendor).toString());
            removeEntityPS = connection.prepareStatement(this.createDeleteFromEntityTableStatement(schemaName, vendor).toString());
            insertToPropertyQNamesPS = connection.prepareStatement(vendor.toString((SQLStatement)this.createInsertStatement(schemaName, "all_qnames", AMOUNT_OF_COLUMNS_IN_ALL_QNAMES_TABLE, vendor)));
            clearEntityDataPS = connection.prepareStatement(this.createClearEntityDataStatement(schemaName, vendor).toString());
            HashMap<Long, EntityState> statesByPK = new HashMap<Long, EntityState>();
            HashMap<Long, Integer> qNamePKs = new HashMap<Long, Integer>();
            Iterable relatedStates = Iterables.filter((Specification)new Specification<EntityState>(){

                public boolean satisfiedBy(EntityState item) {
                    return item.entityDescriptor().queryable();
                }
            }, (Iterable)Iterables.map(SQLCompatEntityStateWrapper.WRAP, changedStates));
            for (EntityState entityState : relatedStates) {
                EntityStatus status = entityState.status();
                pk = null;
                boolean needToInsert = status.equals((Object)EntityStatus.NEW);
                if (!needToInsert) {
                    if (status.equals((Object)EntityStatus.UPDATED)) {
                        pk = this.findEntityPK(entityState, queryEntityPKPS);
                        if (pk == null) {
                            needToInsert = true;
                        } else {
                            this.updateEntityInfoAndProperties(connection, qNameInsertPSs, insertToPropertyQNamesPS, clearEntityDataPS, updateEntityTablePS, entityState, pk, qNamePKs);
                        }
                    } else if (status.equals((Object)EntityStatus.REMOVED)) {
                        this.removeEntity(entityState, removeEntityPS);
                    }
                }
                if (needToInsert) {
                    pk = this.getPKFromAutoGeneratedIDInsert(entityState, insertToEntityTableAutoGenerated.getValue(), vendor, connection);
                    this.insertPropertyType(connection, insertToEntityTypeTablePS.getValue(), entityState, pk);
                    this.insertProperties(connection, qNameInsertPSs, insertToPropertyQNamesPS, entityState, pk, qNamePKs);
                }
                if (pk == null) continue;
                statesByPK.put(pk, entityState);
            }
            removeEntityPS.executeBatch();
            updateEntityTablePS.executeBatch();
            clearEntityDataPS.executeBatch();
            if (insertToEntityTypeTablePS.hasValue()) {
                insertToEntityTypeTablePS.getValue().executeBatch();
            }
            for (Map.Entry entry : statesByPK.entrySet()) {
                EntityState eState = (EntityState)entry.getValue();
                pk = (Long)entry.getKey();
                this.insertAssoAndManyAssoQNames(qNameInsertPSs, insertToPropertyQNamesPS, eState, (Integer)qNamePKs.get(pk), pk);
            }
            insertToPropertyQNamesPS.executeBatch();
            for (PreparedStatement preparedStatement : qNameInsertPSs.values()) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException sqle) {
            try {
                SQLUtil.rollbackQuietly((Connection)connection);
                throw sqle;
            }
            catch (Throwable throwable) {
                try {
                    if (queryEntityPKPS.hasValue()) {
                        SQLUtil.closeQuietly((Statement)queryEntityPKPS.getValue());
                    }
                    if (insertToEntityTableAutoGenerated.hasValue()) {
                        SQLUtil.closeQuietly((Statement)insertToEntityTableAutoGenerated.getValue());
                    }
                    SQLUtil.closeQuietly(updateEntityTablePS);
                    SQLUtil.closeQuietly(removeEntityPS);
                    SQLUtil.closeQuietly(insertToPropertyQNamesPS);
                    SQLUtil.closeQuietly(clearEntityDataPS);
                    for (PreparedStatement ps : qNameInsertPSs.values()) {
                        SQLUtil.closeQuietly((Statement)ps);
                    }
                    throw throwable;
                }
                finally {
                    if (connectionFromStartupWasNull) {
                        SQLUtil.closeQuietly((Connection)connection);
                    } else {
                        connection.setReadOnly(wasReadOnly);
                        connection.setAutoCommit(wasAutoCommit);
                    }
                }
            }
        }
        try {
            if (queryEntityPKPS.hasValue()) {
                SQLUtil.closeQuietly((Statement)queryEntityPKPS.getValue());
            }
            if (insertToEntityTableAutoGenerated.hasValue()) {
                SQLUtil.closeQuietly((Statement)insertToEntityTableAutoGenerated.getValue());
            }
            SQLUtil.closeQuietly((Statement)updateEntityTablePS);
            SQLUtil.closeQuietly((Statement)removeEntityPS);
            SQLUtil.closeQuietly((Statement)insertToPropertyQNamesPS);
            SQLUtil.closeQuietly((Statement)clearEntityDataPS);
            for (PreparedStatement ps : qNameInsertPSs.values()) {
                SQLUtil.closeQuietly((Statement)ps);
            }
            return;
        }
        finally {
            if (connectionFromStartupWasNull) {
                SQLUtil.closeQuietly((Connection)connection);
            } else {
                connection.setReadOnly(wasReadOnly);
                connection.setAutoCommit(wasAutoCommit);
            }
        }
    }

    protected InsertStatement createInsertStatement(String schemaName, String tableName, Integer amountOfColumns, SQLVendor vendor) {
        ModificationFactory m = vendor.getModificationFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        ColumnSourceByValuesBuilder columnBuilder = m.columnSourceByValues();
        Integer x = 0;
        while (x < amountOfColumns) {
            columnBuilder.addValues(new ValueExpression[]{l.param()});
            x = x + 1;
        }
        return (InsertStatement)m.insert().setTableName(t.tableName(schemaName, tableName)).setColumnSource((ColumnSource)columnBuilder.createExpression()).createExpression();
    }

    protected abstract InsertStatement createInsertStatementWithAutoGeneratedIDForEntitiesTable(String var1, String var2, SQLVendor var3);

    protected void addEntityInfoToInsertToEntityTablePS(EntityState state, PreparedStatement ps, int startingIndex) throws SQLException {
        ps.setString(startingIndex, state.identity().identity());
        ps.setTimestamp(startingIndex + 1, new Timestamp(state.lastModified()));
        ps.setString(startingIndex + 2, state.version());
        ps.setString(startingIndex + 3, this._app.version());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long findEntityPK(EntityState state, SQLSkeletonUtil.Lazy<PreparedStatement, SQLException> queryPKPS) throws SQLException {
        Long entityPK = null;
        PreparedStatement ps = queryPKPS.getValue();
        ps.setString(1, state.identity().identity());
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            if (rs.next()) {
                entityPK = rs.getLong(1);
            }
        }
        finally {
            SQLUtil.closeQuietly((ResultSet)rs);
        }
        return entityPK;
    }

    protected abstract long getPKFromAutoGeneratedIDInsert(EntityState var1, PreparedStatement var2, SQLVendor var3, Connection var4) throws SQLException;

    protected UpdateStatement createUpdateEntityTableStatement(String schemaName, SQLVendor vendor) {
        ModificationFactory m = vendor.getModificationFactory();
        BooleanFactory b = vendor.getBooleanFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        UpdateSourceByExpression paramSource = m.updateSourceByExp((ValueExpression)l.param());
        UpdateBySearchBuilder builder = m.updateBySearch();
        builder.setTargetTable(m.createTargetTable(t.tableName(schemaName, "indexing_entities"))).addSetClauses(new SetClause[]{m.setClause("entity_identity", (UpdateSource)paramSource), m.setClause("modified", (UpdateSource)paramSource), m.setClause("entity_version", (UpdateSource)paramSource), m.setClause("application_version", (UpdateSource)paramSource)}).getWhereBuilder().reset((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_pk"), (NonBooleanExpression)l.param()));
        return (UpdateStatement)builder.createExpression();
    }

    protected QueryExpression createQueryEntityPkByIdentityStatement(String schemaName, SQLVendor vendor) {
        BooleanFactory b = vendor.getBooleanFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        QueryFactory q = vendor.getQueryFactory();
        QuerySpecificationBuilder query = q.querySpecificationBuilder();
        query.getSelect().addUnnamedColumns(new ColumnReference[]{c.colName("entity_pk")});
        query.getFrom().addTableReferences(new TableReferenceBuilder[]{t.tableBuilder((TableReferencePrimary)t.table((TableName)t.tableName(schemaName, "indexing_entities")))});
        query.getWhere().reset((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_identity"), (NonBooleanExpression)l.param()));
        return q.createQuery((QueryExpressionBody)query.createExpression());
    }

    protected DeleteStatement createDeleteFromEntityTableStatement(String schemaName, SQLVendor vendor) {
        return this.createDeleteFromTableStatement(schemaName, "indexing_entities", "entity_identity", vendor);
    }

    protected DeleteStatement createClearEntityDataStatement(String schemaName, SQLVendor vendor) {
        return this.createDeleteFromTableStatement(schemaName, "all_qnames", "entity_pk", vendor);
    }

    protected DeleteStatement createDeleteFromTableStatement(String schemaName, String tableName, String columnName, SQLVendor vendor) {
        ModificationFactory m = vendor.getModificationFactory();
        BooleanFactory b = vendor.getBooleanFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        DeleteBySearchBuilder delete = m.deleteBySearch();
        delete.setTargetTable(m.createTargetTable(t.tableName(schemaName, tableName))).getWhere().reset((BooleanExpression)b.eq((NonBooleanExpression)c.colName(columnName), (NonBooleanExpression)l.param()));
        return (DeleteStatement)delete.createExpression();
    }

    protected InsertStatement createPropertyInsert(QNameInfo qNameInfo, SQLVendor vendor) {
        String tableName = qNameInfo.getTableName();
        ModificationFactory m = vendor.getModificationFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnSourceByValuesBuilder columnBuilder = m.columnSourceByValues().addValues(new ValueExpression[]{l.param(), l.param(), l.param()});
        if (qNameInfo.getCollectionDepth() > 0) {
            columnBuilder.addValues(new ValueExpression[]{l.func("text2ltree", new ValueExpression[]{l.param()})});
        }
        columnBuilder.addValues(new ValueExpression[]{l.param()});
        return (InsertStatement)m.insert().setTableName(t.tableName((String)this._state.schemaName().get(), tableName)).setColumnSource((ColumnSource)columnBuilder.createExpression()).createExpression();
    }

    protected InsertStatement createAssoInsert(QNameInfo qNameInfo, SQLVendor vendor, Integer amountOfParams) {
        ModificationFactory m = vendor.getModificationFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        QueryFactory q = vendor.getQueryFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        BooleanFactory b = vendor.getBooleanFactory();
        String schemaName = (String)this._state.schemaName().get();
        QuerySpecificationBuilder qBuilder = q.querySpecificationBuilder();
        Integer x = 0;
        while (x < amountOfParams) {
            qBuilder.getSelect().addUnnamedColumns(new ColumnReference[]{c.colExp((ValueExpression)l.param())});
            x = x + 1;
        }
        qBuilder.getSelect().addUnnamedColumns(new ColumnReference[]{c.colName("entity_pk")});
        qBuilder.getFrom().addTableReferences(new TableReferenceBuilder[]{t.tableBuilder((TableReferencePrimary)t.table((TableName)t.tableName(schemaName, "indexing_entities")))});
        qBuilder.getWhere().reset((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_identity"), (NonBooleanExpression)l.param()));
        return (InsertStatement)m.insert().setTableName(t.tableName(schemaName, qNameInfo.getTableName())).setColumnSource((ColumnSource)m.columnSourceByQuery(q.createQuery((QueryExpressionBody)qBuilder.createExpression()))).createExpression();
    }

    protected InsertStatement createInsertEntityTypeStatement(String schemaName, SQLVendor vendor) {
        return this.createInsertStatement(schemaName, "indexing_entities_entity_types", 2, vendor);
    }

    private void syncQNamesInsertPSs(Connection connection, Map<QualifiedName, PreparedStatement> qNameInsertPSs, Set<QualifiedName> qNames) throws SQLException {
        HashSet<QualifiedName> copy = new HashSet<QualifiedName>(qNames);
        copy.removeAll(qNameInsertPSs.keySet());
        for (QualifiedName qName : copy) {
            QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
            if (info == null) {
                throw new InternalError("Could not find database information about qualified name [" + qName + "]");
            }
            QNameInfo.QNameType type = info.getQNameType();
            if (type.equals((Object)QNameInfo.QNameType.PROPERTY)) {
                qNameInsertPSs.put(qName, this.createInsertPropertyPS(connection, info));
                continue;
            }
            if (type.equals((Object)QNameInfo.QNameType.ASSOCIATION)) {
                qNameInsertPSs.put(qName, this.createInsertAssociationPS(connection, info));
                continue;
            }
            if (type.equals((Object)QNameInfo.QNameType.MANY_ASSOCIATION)) {
                qNameInsertPSs.put(qName, this.createInsertManyAssociationPS(connection, info));
                continue;
            }
            throw new IllegalArgumentException("Did not know what to do with QName of type " + (Object)((Object)type) + ".");
        }
    }

    private PreparedStatement createInsertPropertyPS(Connection connection, QNameInfo qNameInfo) throws SQLException {
        SQLVendor vendor = (SQLVendor)this.descriptor.metaInfo(SQLVendor.class);
        return connection.prepareStatement(vendor.toString((SQLStatement)this.createPropertyInsert(qNameInfo, vendor)));
    }

    private PreparedStatement createInsertAssociationPS(Connection connection, QNameInfo qNameInfo) throws SQLException {
        SQLVendor vendor = (SQLVendor)this.descriptor.metaInfo(SQLVendor.class);
        return connection.prepareStatement(vendor.toString((SQLStatement)this.createAssoInsert(qNameInfo, vendor, AMOUNT_OF_COLUMNS_IN_ASSO_TABLE)));
    }

    private PreparedStatement createInsertManyAssociationPS(Connection connection, QNameInfo qNameInfo) throws SQLException {
        SQLVendor vendor = (SQLVendor)this.descriptor.metaInfo(SQLVendor.class);
        return connection.prepareStatement(vendor.toString((SQLStatement)this.createAssoInsert(qNameInfo, vendor, AMOUNT_OF_COLUMNS_IN_MANY_ASSO_TABLE)));
    }

    private void clearAllEntitysQNames(PreparedStatement clearPropertiesPS, Long pk) throws SQLException {
        clearPropertiesPS.setLong(1, pk);
        clearPropertiesPS.addBatch();
    }

    private Integer insertPropertyQNames(Connection connection, Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, EntityState state, Long entityPK) throws SQLException {
        Set qNames = (Set)((Map)this._state.entityUsedQNames().get()).get(state.entityDescriptor());
        this.syncQNamesInsertPSs(connection, qNameInsertPSs, qNames);
        Integer propertyPK = 0;
        for (PropertyDescriptor pDesc : state.entityDescriptor().state().properties()) {
            if (!SQLSkeletonUtil.isQueryable(pDesc.accessor())) continue;
            propertyPK = this.insertProperty(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, pDesc.qualifiedName(), state.propertyValueOf(pDesc.qualifiedName()), null);
        }
        return propertyPK;
    }

    private void insertAssoAndManyAssoQNames(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertToAllQNamesPS, EntityState state, Integer qNamePK, Long entityPK) throws SQLException {
        PreparedStatement ps;
        QualifiedName qName;
        for (AssociationDescriptor aDesc : state.entityDescriptor().state().associations()) {
            if (!SQLSkeletonUtil.isQueryable(aDesc.accessor())) continue;
            qName = aDesc.qualifiedName();
            ps = qNameInsertPSs.get(qName);
            EntityReference ref = state.associationValueOf(qName);
            if (ref == null) continue;
            insertToAllQNamesPS.setInt(1, qNamePK);
            insertToAllQNamesPS.setLong(2, entityPK);
            insertToAllQNamesPS.addBatch();
            ps.setInt(1, qNamePK);
            ps.setLong(2, entityPK);
            ps.setString(3, ref.identity());
            ps.addBatch();
            qNamePK = qNamePK + 1;
        }
        for (AssociationDescriptor mDesc : state.entityDescriptor().state().manyAssociations()) {
            if (!SQLSkeletonUtil.isQueryable(mDesc.accessor())) continue;
            qName = mDesc.qualifiedName();
            ps = qNameInsertPSs.get(qName);
            Integer index = 0;
            for (EntityReference ref : state.manyAssociationValueOf(qName)) {
                if (ref != null) {
                    insertToAllQNamesPS.setInt(1, qNamePK);
                    insertToAllQNamesPS.setLong(2, entityPK);
                    insertToAllQNamesPS.addBatch();
                    ps.setInt(1, qNamePK);
                    ps.setLong(2, entityPK);
                    ps.setInt(3, index);
                    ps.setString(4, ref.identity());
                    ps.addBatch();
                    qNamePK = qNamePK + 1;
                }
                index = index + 1;
            }
        }
    }

    private Integer insertProperty(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, QualifiedName qName, Object property, Integer parentQNameID) throws SQLException {
        Integer result = propertyPK;
        if (property != null && !qName.type().equals(Identity.class.getName())) {
            QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
            result = info.getCollectionDepth() > 0 ? this.storeCollectionProperty(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, qName, (Collection)property, parentQNameID) : (info.isFinalTypePrimitive() != false ? this.storePrimitiveProperty(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, qName, property, parentQNameID) : this.storeValueCompositeProperty(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, qName, property, parentQNameID));
        }
        return result;
    }

    private Integer storeCollectionProperty(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, QualifiedName qName, Collection<?> property, Integer parentQNameID) throws SQLException {
        QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
        PreparedStatement ps = qNameInsertPSs.get(qName);
        propertyPK = this.storeCollectionInfo(insertAllQNamesPS, propertyPK, entityPK, parentQNameID, ps, info);
        propertyPK = this.storeCollectionItems(qNameInsertPSs, property, insertAllQNamesPS, "Top", ps, info.getTableName(), propertyPK, entityPK, parentQNameID, info.getFinalType(), info.isFinalTypePrimitive());
        return propertyPK;
    }

    private Integer storeCollectionInfo(PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, Integer parentQNameID, PreparedStatement ps, QNameInfo info) throws SQLException {
        insertAllQNamesPS.setInt(1, propertyPK);
        insertAllQNamesPS.setLong(2, entityPK);
        insertAllQNamesPS.addBatch();
        ps.setInt(1, propertyPK);
        ps.setLong(2, entityPK);
        ps.setObject(3, (Object)parentQNameID, -5);
        ps.setString(4, "Top");
        if (info.isFinalTypePrimitive().booleanValue()) {
            this.storePrimitiveUsingPS(ps, 5, null, info.getFinalType());
        } else {
            this.storeVCClassIDUsingPS(ps, 5, null);
        }
        ps.addBatch();
        return propertyPK + 1;
    }

    private Integer storeCollectionItems(Map<QualifiedName, PreparedStatement> qNameInsertPSs, Collection<?> collection, PreparedStatement insertAllQNamesPS, String path, PreparedStatement ps, String tableName, Integer propertyPK, Long entityPK, Integer parentPK, Type finalType, Boolean isFinalTypePrimitive) throws SQLException {
        Integer index = 0;
        for (Object o : collection) {
            String itemPath = path + "." + index;
            if (o instanceof Collection) {
                propertyPK = this.storeCollectionItems(qNameInsertPSs, (Collection)o, insertAllQNamesPS, itemPath, ps, tableName, propertyPK, entityPK, parentPK, finalType, isFinalTypePrimitive);
            } else {
                propertyPK = this.storeCollectionItem(qNameInsertPSs, ps, insertAllQNamesPS, propertyPK, entityPK, parentPK, itemPath, o, isFinalTypePrimitive, finalType);
                ps.addBatch();
            }
            index = index + 1;
        }
        return propertyPK;
    }

    private Integer storeCollectionItem(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement ps, PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, Integer parentPK, String path, Object item, Boolean isFinalTypePrimitive, Type finalType) throws SQLException {
        insertAllQNamesPS.setInt(1, propertyPK);
        insertAllQNamesPS.setLong(2, entityPK);
        insertAllQNamesPS.addBatch();
        ps.setInt(1, propertyPK);
        ps.setLong(2, entityPK);
        ps.setObject(3, (Object)parentPK, 4);
        ps.setString(4, path);
        if (isFinalTypePrimitive.booleanValue()) {
            this.storePrimitiveUsingPS(ps, 5, item, finalType);
            propertyPK = propertyPK + 1;
        } else {
            this.storeVCClassIDUsingPS(ps, 5, item);
            propertyPK = this.storePropertiesOfVC(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, item);
        }
        return propertyPK;
    }

    private Integer storePrimitiveProperty(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, QualifiedName qName, Object property, Integer parentQNameID) throws SQLException {
        QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
        insertAllQNamesPS.setInt(1, propertyPK);
        insertAllQNamesPS.setLong(2, entityPK);
        insertAllQNamesPS.addBatch();
        PreparedStatement ps = qNameInsertPSs.get(qName);
        ps.setInt(1, propertyPK);
        ps.setLong(2, entityPK);
        ps.setObject(3, (Object)parentQNameID, 4);
        Type type = info.getFinalType();
        this.storePrimitiveUsingPS(ps, 4, property, type);
        ps.addBatch();
        return propertyPK + 1;
    }

    private Integer storeValueCompositeProperty(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, QualifiedName qName, Object property, Integer parentQNameID) throws SQLException {
        PreparedStatement ps = qNameInsertPSs.get(qName);
        insertAllQNamesPS.setInt(1, propertyPK);
        insertAllQNamesPS.setLong(2, entityPK);
        insertAllQNamesPS.addBatch();
        ps.setInt(1, propertyPK);
        ps.setLong(2, entityPK);
        ps.setObject(3, (Object)parentQNameID, 4);
        this.storeVCClassIDUsingPS(ps, 4, property);
        ps.addBatch();
        return this.storePropertiesOfVC(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, property);
    }

    private Integer storePropertiesOfVC(Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, Integer propertyPK, Long entityPK, Object property) throws SQLException {
        ValueDescriptor vDesc = this._qi4SPI.valueDescriptorFor((Object)((ValueComposite)property));
        StateHolder state = ((CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)((ValueComposite)property))).state();
        Integer originalPropertyPK = propertyPK;
        propertyPK = propertyPK + 1;
        for (PropertyDescriptor pDesc : vDesc.state().properties()) {
            propertyPK = this.insertProperty(qNameInsertPSs, insertAllQNamesPS, propertyPK, entityPK, pDesc.qualifiedName(), state.propertyFor(pDesc.accessor()).get(), originalPropertyPK);
        }
        return propertyPK;
    }

    private void storePrimitiveUsingPS(PreparedStatement ps, Integer nextFreeIndex, Object primitive, Type primitiveType) throws SQLException {
        if (primitiveType instanceof ParameterizedType) {
            primitiveType = ((ParameterizedType)primitiveType).getRawType();
        }
        if (primitiveType instanceof Class && Enum.class.isAssignableFrom((Class)primitiveType)) {
            ps.setInt(nextFreeIndex, (Integer)((Map)this._state.enumPKs().get()).get(QualifiedName.fromClass((Class)((Class)primitiveType), (String)primitive.toString()).toString()));
        } else {
            this._sqlTypeHelper.addPrimitiveToPS(ps, nextFreeIndex, primitive, primitiveType);
        }
    }

    private void storeVCClassIDUsingPS(PreparedStatement ps, Integer nextFreeIndex, Object vc) throws SQLException {
        if (vc == null) {
            ps.setNull(nextFreeIndex, 4);
        } else {
            ValueDescriptor vDesc = this._qi4SPI.valueDescriptorFor(vc);
            Integer classID = (Integer)((Map)this._state.usedClassesPKs().get()).get(vDesc);
            ps.setInt(nextFreeIndex, classID);
        }
    }

    private void updateEntityInfoAndProperties(Connection connection, Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, PreparedStatement clearPropertiesPS, PreparedStatement ps, EntityState state, Long entityPK, Map<Long, Integer> qNamePKs) throws SQLException {
        this.clearAllEntitysQNames(clearPropertiesPS, entityPK);
        ps.setString(1, state.identity().identity());
        ps.setTimestamp(2, new Timestamp(state.lastModified()));
        ps.setString(3, state.version());
        ps.setString(4, this._app.version());
        ps.setLong(5, entityPK);
        ps.addBatch();
        Integer nextUsableQNamePK = this.insertPropertyQNames(connection, qNameInsertPSs, insertAllQNamesPS, state, entityPK);
        qNamePKs.put(entityPK, nextUsableQNamePK);
    }

    private void insertProperties(Connection connection, Map<QualifiedName, PreparedStatement> qNameInsertPSs, PreparedStatement insertAllQNamesPS, EntityState state, Long entityPK, Map<Long, Integer> qNamePKs) throws SQLException {
        Integer nextQnamePK = this.insertPropertyQNames(connection, qNameInsertPSs, insertAllQNamesPS, state, entityPK);
        qNamePKs.put(entityPK, nextQnamePK);
    }

    private void removeEntity(EntityState state, PreparedStatement ps) throws SQLException {
        ps.setString(1, state.identity().identity());
        ps.addBatch();
    }

    private void insertPropertyType(Connection connection, PreparedStatement insertPropertyTypePS, EntityState state, Long entityPK) throws SQLException {
        for (Class clazz : state.entityDescriptor().types()) {
            Integer typePK = (Integer)((Map)this._state.entityTypePKs().get()).get(clazz.getName());
            if (typePK == null) {
                throw new InternalError("Tried to get entity : " + clazz + ", but only aware of the following entities: " + ((Map)this._state.entityTypePKs().get()).keySet());
            }
            insertPropertyTypePS.setLong(1, entityPK);
            insertPropertyTypePS.setInt(2, typePK);
            insertPropertyTypePS.addBatch();
        }
    }
}

