/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.skeletons;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.qi4j.api.Qi4j;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.grammar.AndSpecification;
import org.qi4j.api.query.grammar.AssociationFunction;
import org.qi4j.api.query.grammar.AssociationNotNullSpecification;
import org.qi4j.api.query.grammar.AssociationNullSpecification;
import org.qi4j.api.query.grammar.ComparisonSpecification;
import org.qi4j.api.query.grammar.ContainsAllSpecification;
import org.qi4j.api.query.grammar.ContainsSpecification;
import org.qi4j.api.query.grammar.EqSpecification;
import org.qi4j.api.query.grammar.GeSpecification;
import org.qi4j.api.query.grammar.GtSpecification;
import org.qi4j.api.query.grammar.LeSpecification;
import org.qi4j.api.query.grammar.LtSpecification;
import org.qi4j.api.query.grammar.ManyAssociationContainsSpecification;
import org.qi4j.api.query.grammar.ManyAssociationFunction;
import org.qi4j.api.query.grammar.MatchesSpecification;
import org.qi4j.api.query.grammar.NeSpecification;
import org.qi4j.api.query.grammar.NotSpecification;
import org.qi4j.api.query.grammar.OrSpecification;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.PropertyFunction;
import org.qi4j.api.query.grammar.PropertyNotNullSpecification;
import org.qi4j.api.query.grammar.PropertyNullSpecification;
import org.qi4j.api.query.grammar.Variable;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.index.sql.support.api.SQLQuerying;
import org.qi4j.index.sql.support.common.QNameInfo;
import org.qi4j.index.sql.support.postgresql.PostgreSQLTypeHelper;
import org.qi4j.index.sql.support.skeletons.SQLDBState;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.query.EntityFinderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.builders.booleans.BooleanBuilder;
import org.sql.generation.api.grammar.builders.booleans.InBuilder;
import org.sql.generation.api.grammar.builders.query.GroupByBuilder;
import org.sql.generation.api.grammar.builders.query.QueryBuilder;
import org.sql.generation.api.grammar.builders.query.QuerySpecificationBuilder;
import org.sql.generation.api.grammar.builders.query.TableReferenceBuilder;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.common.SQLStatement;
import org.sql.generation.api.grammar.common.SetQuantifier;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.common.ValueExpression;
import org.sql.generation.api.grammar.factories.BooleanFactory;
import org.sql.generation.api.grammar.factories.ColumnsFactory;
import org.sql.generation.api.grammar.factories.LiteralFactory;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.query.ColumnReference;
import org.sql.generation.api.grammar.query.ColumnReferenceByName;
import org.sql.generation.api.grammar.query.GroupingElement;
import org.sql.generation.api.grammar.query.Ordering;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.api.grammar.query.QueryExpressionBody;
import org.sql.generation.api.grammar.query.QuerySpecification;
import org.sql.generation.api.grammar.query.SortSpecification;
import org.sql.generation.api.grammar.query.TableReference;
import org.sql.generation.api.grammar.query.TableReferenceByName;
import org.sql.generation.api.grammar.query.TableReferencePrimary;
import org.sql.generation.api.grammar.query.joins.JoinSpecification;
import org.sql.generation.api.grammar.query.joins.JoinType;
import org.sql.generation.api.vendor.SQLVendor;

public abstract class AbstractSQLQuerying
implements SQLQuerying {
    @This
    private SQLDBState _state;
    @This
    private PostgreSQLTypeHelper _typeHelper;
    @Structure
    private Module module;
    @Structure
    private Qi4jSPI spi;
    private static final Map<Class<? extends Specification>, SQLBooleanCreator> SQL_OPERATORS;
    private static final Map<Class<? extends Specification>, JoinType> JOIN_STYLES;
    private static final Map<Class<? extends Specification>, JoinType> NEGATED_JOIN_STYLES;
    private static final Map<Class<?>, BooleanExpressionProcessor> EXPRESSION_PROCESSORS;
    private static final String TABLE_NAME_PREFIX = "t";
    private static final String TYPE_TABLE_SUFFIX = "_types";
    private static final Logger LOGGER;
    @Uses
    private ServiceDescriptor descriptor;

    @Override
    public Integer getResultSetType(Integer firstResult, Integer maxResults) {
        return 1003;
    }

    @Override
    public Boolean isFirstResultSettingSupported() {
        return true;
    }

    @Override
    public String constructQuery(Class<?> resultType, Specification<Composite> whereClause, OrderBy[] orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes, Boolean countOnly) throws EntityFinderException {
        SQLVendor vendor = (SQLVendor)this.descriptor.metaInfo(SQLVendor.class);
        QueryFactory q = vendor.getQueryFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        ColumnReferenceByName mainColumn = c.colName("t0", "entity_identity");
        if (countOnly.booleanValue()) {
            mainColumn = c.colExp((ValueExpression)l.func("COUNT", new ValueExpression[]{mainColumn}));
        }
        QueryBuilder innerBuilder = this.processBooleanExpression(whereClause, false, vendor, this.createTypeCondition(resultType, vendor), variables, values, valueSQLTypes);
        QuerySpecificationBuilder mainQuery = q.querySpecificationBuilder();
        mainQuery.getSelect().addUnnamedColumns(new ColumnReference[]{mainColumn});
        mainQuery.getFrom().addTableReferences(new TableReferenceBuilder[]{t.tableBuilder((TableReferencePrimary)t.table(q.createQuery((QueryExpressionBody)innerBuilder.createExpression()), t.tableAlias("t0")))});
        this.processOrderBySegments(orderBySegments, vendor, mainQuery);
        QueryExpression finalMainQuery = this.finalizeQuery(vendor, mainQuery, resultType, whereClause, orderBySegments, firstResult, maxResults, variables, values, valueSQLTypes, countOnly);
        String result = vendor.toString((SQLStatement)finalMainQuery);
        LOGGER.info("SQL query:\n" + result);
        return result;
    }

    protected BooleanExpression createTypeCondition(Class<?> resultType, SQLVendor vendor) {
        BooleanFactory b = vendor.getBooleanFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        List<Integer> typeIDs = this.getEntityTypeIDs(resultType);
        InBuilder in = b.inBuilder((NonBooleanExpression)c.colName("t_types", "entity_type_id"));
        for (Integer i : typeIDs) {
            in.addValues(new NonBooleanExpression[]{l.n((Number)i)});
        }
        return (BooleanExpression)in.createExpression();
    }

    protected abstract QueryExpression finalizeQuery(SQLVendor var1, QuerySpecificationBuilder var2, Class<?> var3, Specification<Composite> var4, OrderBy[] var5, Integer var6, Integer var7, Map<String, Object> var8, List<Object> var9, List<Integer> var10, Boolean var11);

    protected QueryBuilder processBooleanExpression(Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
        QueryBuilder result = null;
        if (expression == null) {
            QueryFactory q = vendor.getQueryFactory();
            result = q.queryBuilder((QueryExpressionBody)this.selectAllEntitiesOfCorrectType(vendor, entityTypeCondition).createExpression());
        } else if (EXPRESSION_PROCESSORS.containsKey(expression.getClass())) {
            result = EXPRESSION_PROCESSORS.get(expression.getClass()).processBooleanExpression(this, expression, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
        } else {
            throw new UnsupportedOperationException("Expression " + expression + " of type " + expression.getClass() + " is not supported");
        }
        return result;
    }

    protected QuerySpecificationBuilder selectAllEntitiesOfCorrectType(SQLVendor vendor, BooleanExpression entityTypeCondition) {
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        String tableAlias = "t0";
        TableReferenceBuilder from = t.tableBuilder((TableReferencePrimary)t.table((TableName)t.tableName((String)this._state.schemaName().get(), "indexing_entities"), t.tableAlias(tableAlias)));
        this.addTypeJoin(vendor, from, 0);
        QuerySpecificationBuilder query = this.getBuilderForPredicate(vendor, tableAlias);
        query.getFrom().addTableReferences(new TableReferenceBuilder[]{from});
        query.getWhere().reset(entityTypeCondition);
        return query;
    }

    protected QueryBuilder processMatchesPredicate(final MatchesSpecification predicate, Boolean negationActive, final SQLVendor vendor, BooleanExpression entityTypeCondition, final Map<String, Object> variables, final List<Object> values, final List<Integer> valueSQLTypes) {
        return this.singleQuery((Specification<Composite>)predicate, predicate.property(), null, null, negationActive, vendor, entityTypeCondition, new WhereClauseProcessor(){

            @Override
            public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
                LiteralFactory l = vendor.getLiteralFactory();
                ColumnsFactory c = vendor.getColumnsFactory();
                builder.getWhere().reset((BooleanExpression)vendor.getBooleanFactory().regexp((NonBooleanExpression)c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, "qname_value"), (NonBooleanExpression)l.param()));
                Object value = predicate.value();
                if (value instanceof Variable) {
                    value = variables.get(((Variable)value).variableName());
                }
                values.add(AbstractSQLQuerying.this.translateJavaRegexpToPGSQLRegexp(value.toString()));
                valueSQLTypes.add(12);
            }
        });
    }

    protected QueryBuilder processComparisonPredicate(final ComparisonSpecification<?> predicate, final Boolean negationActive, final SQLVendor vendor, BooleanExpression entityTypeCondition, final Map<String, Object> variables, final List<Object> values, final List<Integer> valueSQLTypes) {
        return this.singleQuery((Specification<Composite>)predicate, (PropertyFunction<?>)predicate.property(), null, null, negationActive, vendor, entityTypeCondition, new WhereClauseProcessor(){

            @Override
            public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
                QualifiedName qName = QualifiedName.fromAccessor((AccessibleObject)predicate.property().accessor());
                String columnName = qName.type().equals(Identity.class.getName()) ? "entity_identity" : "qname_value";
                Object value = predicate.value();
                AbstractSQLQuerying.this.modifyFromClauseAndWhereClauseToGetValue(qName, value, (Specification<Composite>)predicate, negationActive, lastTableIndex, new ModifiableInt(lastTableIndex), columnName, "Top", vendor, builder.getWhere(), afterWhere, (TableReferenceBuilder)builder.getFrom().getTableReferences().iterator().next(), builder.getGroupBy(), builder.getHaving(), new ArrayList<QNameJoin>(), variables, values, valueSQLTypes);
            }
        });
    }

    protected QueryBuilder processManyAssociationContainsPredicate(final ManyAssociationContainsSpecification<?> predicate, Boolean negationActive, final SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, final List<Object> values, final List<Integer> valueSQLTypes) {
        return this.singleQuery((Specification<Composite>)predicate, null, new TraversedAssoOrManyAssoRef(predicate), true, negationActive, vendor, entityTypeCondition, new WhereClauseProcessor(){

            @Override
            public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
                LiteralFactory l = vendor.getLiteralFactory();
                ColumnsFactory c = vendor.getColumnsFactory();
                BooleanFactory b = vendor.getBooleanFactory();
                builder.getWhere().reset(AbstractSQLQuerying.this.getOperator((Specification<Composite>)predicate).getExpression(b, (NonBooleanExpression)c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, "entity_identity"), (NonBooleanExpression)l.param()));
                Object value = predicate.value();
                value = value instanceof EntityComposite ? ((EntityComposite)AbstractSQLQuerying.this.module.currentUnitOfWork().get((Object)((EntityComposite)value))).identity().get() : value.toString();
                values.add(value);
                valueSQLTypes.add(12);
            }
        });
    }

    protected QueryBuilder processPropertyNullPredicate(PropertyNullSpecification<?> predicate, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition) {
        return this.singleQuery((Specification<Composite>)predicate, (PropertyFunction<?>)predicate.property(), null, null, negationActive, vendor, entityTypeCondition, new PropertyNullWhereClauseProcessor(this._state, vendor, predicate.property(), negationActive));
    }

    protected QueryBuilder processPropertyNotNullPredicate(PropertyNotNullSpecification<?> predicate, boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition) {
        return this.singleQuery((Specification<Composite>)predicate, (PropertyFunction<?>)predicate.property(), null, null, negationActive, vendor, entityTypeCondition, new PropertyNullWhereClauseProcessor(this._state, vendor, predicate.property(), !negationActive));
    }

    protected QueryBuilder processAssociationNullPredicate(AssociationNullSpecification<?> predicate, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition) {
        return this.singleQuery((Specification<Composite>)predicate, null, new TraversedAssoOrManyAssoRef(predicate), false, negationActive, vendor, entityTypeCondition, new AssociationNullWhereClauseProcessor(vendor, negationActive));
    }

    protected QueryBuilder processAssociationNotNullPredicate(AssociationNotNullSpecification<?> predicate, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition) {
        return this.singleQuery((Specification<Composite>)predicate, null, new TraversedAssoOrManyAssoRef(predicate), false, negationActive, vendor, entityTypeCondition, new AssociationNullWhereClauseProcessor(vendor, negationActive == false));
    }

    protected QueryBuilder processContainsPredicate(final ContainsSpecification<?> predicate, Boolean negationActive, final SQLVendor vendor, BooleanExpression entityTypeCondition, final Map<String, Object> variables, final List<Object> values, final List<Integer> valueSQLTypes) {
        QuerySpecification contains = this.constructQueryForPredicate((Specification<Composite>)predicate, (PropertyFunction<?>)predicate.collectionProperty(), null, null, false, vendor, entityTypeCondition, new WhereClauseProcessor(){

            @Override
            public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
                BooleanFactory b = vendor.getBooleanFactory();
                LiteralFactory l = vendor.getLiteralFactory();
                ColumnsFactory c = vendor.getColumnsFactory();
                builder.getWhere().reset((BooleanExpression)b.regexp((NonBooleanExpression)c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, "collection_path"), (NonBooleanExpression)l.s("Top.*{1,}")));
                Object value = predicate.value();
                if (value instanceof Collection) {
                    throw new IllegalArgumentException("ContainsPredicate may have only either primitive or value composite as value.");
                }
                BooleanBuilder condition = b.booleanBuilder();
                AbstractSQLQuerying.this.modifyFromClauseAndWhereClauseToGetValue(QualifiedName.fromAccessor((AccessibleObject)predicate.collectionProperty().accessor()), value, (Specification<Composite>)predicate, false, lastTableIndex, new ModifiableInt(lastTableIndex), "qname_value", "Top", vendor, condition, afterWhere, (TableReferenceBuilder)builder.getFrom().getTableReferences().iterator().next(), builder.getGroupBy(), builder.getHaving(), new ArrayList<QNameJoin>(), variables, values, valueSQLTypes);
                builder.getWhere().and((BooleanExpression)condition.createExpression());
            }
        });
        return this.finalizeContainsQuery(vendor, contains, entityTypeCondition, negationActive);
    }

    protected QueryBuilder finalizeContainsQuery(SQLVendor vendor, QuerySpecification contains, BooleanExpression entityTypeCondition, Boolean negationActive) {
        QueryFactory q = vendor.getQueryFactory();
        QueryBuilder result = negationActive != false ? q.queryBuilder((QueryExpressionBody)this.selectAllEntitiesOfCorrectType(vendor, entityTypeCondition).createExpression()).except((QueryExpressionBody)contains) : q.queryBuilder((QueryExpressionBody)contains);
        return result;
    }

    protected QueryBuilder processContainsAllPredicate(final ContainsAllSpecification<?> predicate, Boolean negationActive, final SQLVendor vendor, BooleanExpression entityTypeCondition, final Map<String, Object> variables, final List<Object> values, final List<Integer> valueSQLTypes) {
        QuerySpecification contains = this.constructQueryForPredicate((Specification<Composite>)predicate, (PropertyFunction<?>)predicate.collectionProperty(), null, null, false, vendor, entityTypeCondition, new WhereClauseProcessor(){

            @Override
            public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
                BooleanFactory b = vendor.getBooleanFactory();
                LiteralFactory l = vendor.getLiteralFactory();
                ColumnsFactory c = vendor.getColumnsFactory();
                Iterable collection = predicate.containedValues();
                ArrayList<QNameJoin> joins = new ArrayList<QNameJoin>();
                for (Object value : collection) {
                    if (value instanceof Collection) {
                        throw new IllegalArgumentException("ContainsAllPredicate may not have nested collections as value.");
                    }
                    BooleanBuilder conditionForItem = b.booleanBuilder((BooleanExpression)b.regexp((NonBooleanExpression)c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, "collection_path"), (NonBooleanExpression)l.s("Top.*{1,}")));
                    AbstractSQLQuerying.this.modifyFromClauseAndWhereClauseToGetValue(QualifiedName.fromAccessor((AccessibleObject)predicate.collectionProperty().accessor()), value, (Specification<Composite>)predicate, false, lastTableIndex, new ModifiableInt(lastTableIndex), "qname_value", "Top", vendor, conditionForItem, afterWhere, (TableReferenceBuilder)builder.getFrom().getTableReferences().iterator().next(), builder.getGroupBy(), builder.getHaving(), joins, variables, values, valueSQLTypes);
                    builder.getWhere().or((BooleanExpression)conditionForItem.createExpression());
                }
                builder.getHaving().and((BooleanExpression)b.geq((NonBooleanExpression)l.func("COUNT", new ValueExpression[]{c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, "qname_value")}), (NonBooleanExpression)l.n((Number)Iterables.count((Iterable)collection))));
            }
        });
        return this.finalizeContainsQuery(vendor, contains, entityTypeCondition, negationActive);
    }

    protected QueryBuilder singleQuery(Specification<Composite> predicate, PropertyFunction<?> propRef, TraversedAssoOrManyAssoRef assoRef, Boolean includeLastAssoPathTable, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, WhereClauseProcessor whereClauseGenerator) {
        return vendor.getQueryFactory().queryBuilder((QueryExpressionBody)this.constructQueryForPredicate(predicate, propRef, assoRef, includeLastAssoPathTable, negationActive, vendor, entityTypeCondition, whereClauseGenerator));
    }

    protected QuerySpecification constructQueryForPredicate(Specification<Composite> predicate, PropertyFunction<?> propRef, TraversedAssoOrManyAssoRef assoRef, Boolean includeLastAssoPathTable, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, WhereClauseProcessor whereClauseGenerator) {
        Integer startingIndex = 0;
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        QuerySpecificationBuilder builder = this.getBuilderForPredicate(vendor, TABLE_NAME_PREFIX + startingIndex);
        TableReferenceBuilder from = t.tableBuilder((TableReferencePrimary)t.table((TableName)t.tableName((String)this._state.schemaName().get(), "indexing_entities"), t.tableAlias(TABLE_NAME_PREFIX + startingIndex)));
        this.addTypeJoin(vendor, from, startingIndex);
        Integer lastTableIndex = null;
        JoinType joinStyle = this.getTableJoinStyle(predicate, negationActive);
        if (propRef == null && assoRef != null && assoRef._hasRefs) {
            lastTableIndex = this.traverseAssociationPath(assoRef, startingIndex, startingIndex + 1, vendor, from, joinStyle, includeLastAssoPathTable);
        } else if (assoRef == null || !assoRef._hasRefs) {
            lastTableIndex = this.traversePropertyPath(propRef, startingIndex, startingIndex + 1, vendor, from, joinStyle);
        } else {
            throw new InternalError("Can not have both property reference and association reference (non-)nulls [propRef=" + propRef + ", assoRef=" + assoRef + ", predicate=" + predicate + "].");
        }
        builder.getFrom().addTableReferences(new TableReferenceBuilder[]{from});
        BooleanBuilder afterWhere = vendor.getBooleanFactory().booleanBuilder();
        whereClauseGenerator.processWhereClause(builder, afterWhere, joinStyle, startingIndex, lastTableIndex);
        BooleanBuilder where = builder.getWhere();
        if (negationActive.booleanValue()) {
            where.not();
        }
        where.and((BooleanExpression)afterWhere.createExpression());
        where.and(entityTypeCondition);
        builder.trimGroupBy();
        return (QuerySpecification)builder.createExpression();
    }

    protected void addTypeJoin(SQLVendor vendor, TableReferenceBuilder from, int startingIndex) {
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        BooleanFactory b = vendor.getBooleanFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        from.addQualifiedJoin(JoinType.INNER, (TableReference)t.table((TableName)t.tableName((String)this._state.schemaName().get(), "indexing_entities_entity_types"), t.tableAlias("t_types")), (JoinSpecification)t.jc((BooleanExpression)b.eq((NonBooleanExpression)c.colName(TABLE_NAME_PREFIX + startingIndex, "entity_pk"), (NonBooleanExpression)c.colName("t_types", "entity_pk"))));
    }

    protected SQLBooleanCreator getOperator(Specification<Composite> predicate) {
        return this.findFromLookupTables(SQL_OPERATORS, null, predicate, false);
    }

    protected JoinType getTableJoinStyle(Specification<Composite> predicate, Boolean negationActive) {
        return this.findFromLookupTables(JOIN_STYLES, NEGATED_JOIN_STYLES, predicate, negationActive);
    }

    protected <ReturnType> ReturnType findFromLookupTables(Map<Class<? extends Specification>, ReturnType> normal, Map<Class<? extends Specification>, ReturnType> negated, Specification<Composite> predicate, Boolean negationActive) {
        Class<?> predicateClass = predicate.getClass();
        ReturnType result = null;
        Set<Map.Entry<Class<Specification>, ReturnType>> entries = negationActive != false ? negated.entrySet() : normal.entrySet();
        for (Map.Entry<Class<Specification>, ReturnType> entry : entries) {
            if (!entry.getKey().isAssignableFrom(predicateClass)) continue;
            result = entry.getValue();
            break;
        }
        if (result == null) {
            throw new UnsupportedOperationException("Predicate [" + predicateClass.getName() + "] is not supported");
        }
        return result;
    }

    protected QuerySpecificationBuilder getBuilderForPredicate(SQLVendor vendor, String tableAlias) {
        QueryFactory q = vendor.getQueryFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        QuerySpecificationBuilder result = q.querySpecificationBuilder();
        result.getSelect().setSetQuantifier(SetQuantifier.DISTINCT).addUnnamedColumns(new ColumnReference[]{c.colName(tableAlias, "entity_pk"), c.colName(tableAlias, "entity_identity")});
        return result;
    }

    protected String translateJavaRegexpToPGSQLRegexp(String javaRegexp) {
        return javaRegexp;
    }

    protected void processOrderBySegments(OrderBy[] orderBy, SQLVendor vendor, QuerySpecificationBuilder builder) {
        if (orderBy != null) {
            QNameInfo[] qNames = new QNameInfo[orderBy.length];
            QueryFactory q = vendor.getQueryFactory();
            ColumnsFactory c = vendor.getColumnsFactory();
            Integer tableIndex = 0;
            Integer idx = 0;
            while (idx < orderBy.length) {
                if (orderBy[idx] != null) {
                    Integer tableIdx;
                    String colName;
                    QNameInfo info;
                    PropertyFunction ref = orderBy[idx].property();
                    QualifiedName qName = QualifiedName.fromAccessor((AccessibleObject)ref.accessor());
                    qNames[idx.intValue()] = info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
                    if (info == null) {
                        throw new InternalError("No qName info found for qName [" + qName + "].");
                    }
                    tableIndex = this.traversePropertyPath(ref, 0, tableIndex + 1, vendor, (TableReferenceBuilder)builder.getFrom().getTableReferences().iterator().next(), JoinType.LEFT_OUTER);
                    Class<?> declaringType = ((Member)((Object)ref.accessor())).getDeclaringClass();
                    if (Identity.class.equals(declaringType)) {
                        colName = "entity_identity";
                        tableIdx = tableIndex - 1;
                    } else {
                        colName = "qname_value";
                        tableIdx = tableIndex;
                    }
                    Ordering ordering = Ordering.ASCENDING;
                    if (orderBy[idx].order() == OrderBy.Order.DESCENDING) {
                        ordering = Ordering.DESCENDING;
                    }
                    builder.getOrderBy().addSortSpecs(new SortSpecification[]{q.sortSpec((ValueExpression)c.colName(TABLE_NAME_PREFIX + tableIdx, colName), ordering)});
                }
                idx = idx + 1;
            }
        }
    }

    protected Integer traversePropertyPath(PropertyFunction<?> reference, Integer lastTableIndex, Integer nextAvailableIndex, SQLVendor vendor, TableReferenceBuilder builder, JoinType joinStyle) {
        Stack<QualifiedName> qNameStack = new Stack<QualifiedName>();
        Stack<PropertyFunction> refStack = new Stack<PropertyFunction>();
        while (reference != null) {
            Integer lastAssoTableIndex;
            qNameStack.add(QualifiedName.fromAccessor((AccessibleObject)reference.accessor()));
            refStack.add(reference);
            if (reference.traversedProperty() == null && (reference.traversedAssociation() != null || reference.traversedManyAssociation() != null) && (lastAssoTableIndex = this.traverseAssociationPath(new TraversedAssoOrManyAssoRef(reference), lastTableIndex, nextAvailableIndex, vendor, builder, joinStyle, true)) > lastTableIndex) {
                lastTableIndex = lastAssoTableIndex;
                nextAvailableIndex = lastTableIndex + 1;
            }
            reference = reference.traversedProperty();
        }
        PropertyFunction prevRef = null;
        String schemaName = (String)this._state.schemaName().get();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        BooleanFactory b = vendor.getBooleanFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        while (!qNameStack.isEmpty()) {
            QualifiedName qName = (QualifiedName)qNameStack.pop();
            PropertyFunction ref = (PropertyFunction)refStack.pop();
            if (qName.type().equals(Identity.class.getName())) continue;
            QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
            if (info == null) {
                throw new InternalError("No qName info found for qName [" + qName + "].");
            }
            String prevTableAlias = TABLE_NAME_PREFIX + lastTableIndex;
            String nextTableAlias = TABLE_NAME_PREFIX + nextAvailableIndex;
            TableReferenceByName nextTable = t.table((TableName)t.tableName(schemaName, info.getTableName()), t.tableAlias(nextTableAlias));
            if (prevRef == null) {
                builder.addQualifiedJoin(joinStyle, (TableReference)nextTable, (JoinSpecification)t.jc((BooleanExpression)b.booleanBuilder((BooleanExpression)b.eq((NonBooleanExpression)c.colName(prevTableAlias, "entity_pk"), (NonBooleanExpression)c.colName(nextTableAlias, "entity_pk"))).and((BooleanExpression)b.isNull((NonBooleanExpression)c.colName(nextTableAlias, "parent_qname"))).createExpression()));
            } else {
                builder.addQualifiedJoin(joinStyle, (TableReference)nextTable, (JoinSpecification)t.jc((BooleanExpression)b.booleanBuilder((BooleanExpression)b.eq((NonBooleanExpression)c.colName(prevTableAlias, "qname_id"), (NonBooleanExpression)c.colName(nextTableAlias, "parent_qname"))).and((BooleanExpression)b.eq((NonBooleanExpression)c.colName(prevTableAlias, "entity_pk"), (NonBooleanExpression)c.colName(nextTableAlias, "entity_pk"))).createExpression()));
            }
            lastTableIndex = nextAvailableIndex;
            nextAvailableIndex = nextAvailableIndex + 1;
            prevRef = ref;
        }
        return lastTableIndex;
    }

    protected Integer traverseAssociationPath(TraversedAssoOrManyAssoRef reference, Integer lastTableIndex, Integer nextAvailableIndex, SQLVendor vendor, TableReferenceBuilder builder, JoinType joinStyle, Boolean includeLastTable) {
        Stack<QualifiedName> qNameStack = new Stack<QualifiedName>();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        BooleanFactory b = vendor.getBooleanFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        String schemaName = (String)this._state.schemaName().get();
        while (reference._hasRefs) {
            qNameStack.add(QualifiedName.fromAccessor((AccessibleObject)reference.getAccessor()));
            reference = reference.getTraversedAssociation();
        }
        while (!qNameStack.isEmpty()) {
            QualifiedName qName = (QualifiedName)qNameStack.pop();
            QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(qName);
            if (info == null) {
                throw new InternalError("No qName info found for qName [" + qName + "].");
            }
            builder.addQualifiedJoin(joinStyle, (TableReference)t.table((TableName)t.tableName(schemaName, info.getTableName()), t.tableAlias(TABLE_NAME_PREFIX + nextAvailableIndex)), (JoinSpecification)t.jc((BooleanExpression)b.eq((NonBooleanExpression)c.colName(TABLE_NAME_PREFIX + lastTableIndex, "entity_pk"), (NonBooleanExpression)c.colName(TABLE_NAME_PREFIX + nextAvailableIndex, "entity_pk"))));
            lastTableIndex = nextAvailableIndex;
            nextAvailableIndex = nextAvailableIndex + 1;
            if (!includeLastTable.booleanValue() && qNameStack.isEmpty()) continue;
            builder.addQualifiedJoin(joinStyle, (TableReference)t.table((TableName)t.tableName(schemaName, "indexing_entities"), t.tableAlias(TABLE_NAME_PREFIX + nextAvailableIndex)), (JoinSpecification)t.jc((BooleanExpression)b.eq((NonBooleanExpression)c.colName(TABLE_NAME_PREFIX + lastTableIndex, "qname_value"), (NonBooleanExpression)c.colName(TABLE_NAME_PREFIX + nextAvailableIndex, "entity_pk"))));
            lastTableIndex = nextAvailableIndex;
            nextAvailableIndex = nextAvailableIndex + 1;
        }
        return lastTableIndex;
    }

    protected List<Integer> getEntityTypeIDs(Class<?> entityType) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Map.Entry entry : ((Map)this._state.entityTypePKs().get()).entrySet()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName((String)entry.getKey());
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (clazz == null || !entityType.isAssignableFrom(clazz)) continue;
            result.add((Integer)entry.getValue());
        }
        return result;
    }

    protected Integer modifyFromClauseAndWhereClauseToGetValue(QualifiedName qName, Object value, Specification<Composite> predicate, Boolean negationActive, Integer currentTableIndex, ModifiableInt maxTableIndex, String columnName, String collectionPath, SQLVendor vendor, BooleanBuilder whereClause, BooleanBuilder afterWhere, TableReferenceBuilder fromClause, GroupByBuilder groupBy, BooleanBuilder having, List<QNameJoin> qNameJoins, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
        if (value instanceof Variable) {
            value = variables.get(((Variable)value).variableName());
        }
        String schemaName = (String)this._state.schemaName().get();
        Integer result = 1;
        BooleanFactory b = vendor.getBooleanFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        ColumnsFactory c = vendor.getColumnsFactory();
        QueryFactory q = vendor.getQueryFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        if (value instanceof Collection) {
            Integer collectionIndex = 0;
            Boolean collectionIsSet = value instanceof Set;
            Boolean topLevel = collectionPath.equals("Top");
            String collTable = TABLE_NAME_PREFIX + currentTableIndex;
            String collCol = "collection_path";
            ColumnReferenceByName collColExp = c.colName(collTable, collCol);
            BooleanBuilder collectionCondition = b.booleanBuilder();
            if (topLevel.booleanValue() && negationActive.booleanValue()) {
                afterWhere.and((BooleanExpression)b.booleanBuilder((BooleanExpression)b.neq((NonBooleanExpression)collColExp, (NonBooleanExpression)l.s("Top"))).or((BooleanExpression)b.isNull((NonBooleanExpression)collColExp)).createExpression());
            }
            Integer totalItemsProcessed = 0;
            for (Object item : (Collection)value) {
                String path = collectionPath + "." + (collectionIsSet != false ? "*{1,}" : collectionIndex);
                Boolean isCollection = item instanceof Collection;
                BooleanBuilder newWhere = b.booleanBuilder();
                if (!isCollection.booleanValue()) {
                    newWhere.reset((BooleanExpression)b.regexp((NonBooleanExpression)collColExp, (NonBooleanExpression)l.s(path)));
                }
                totalItemsProcessed = totalItemsProcessed + this.modifyFromClauseAndWhereClauseToGetValue(qName, item, predicate, negationActive, currentTableIndex, maxTableIndex, columnName, path, vendor, newWhere, afterWhere, fromClause, groupBy, having, qNameJoins, variables, values, valueSQLTypes);
                collectionIndex = collectionIndex + 1;
                collectionCondition.or((BooleanExpression)newWhere.createExpression());
            }
            result = totalItemsProcessed;
            if (topLevel.booleanValue()) {
                if (totalItemsProcessed == 0) {
                    collectionCondition.and((BooleanExpression)b.isNotNull((NonBooleanExpression)collColExp)).and((BooleanExpression)b.eq((NonBooleanExpression)collColExp, (NonBooleanExpression)l.l("Top")));
                } else if (!negationActive.booleanValue()) {
                    groupBy.addGroupingElements(new GroupingElement[]{q.groupingElement(new NonBooleanExpression[]{c.colName(TABLE_NAME_PREFIX + currentTableIndex, "entity_pk")})});
                    having.and((BooleanExpression)b.eq((NonBooleanExpression)l.func("COUNT", new ValueExpression[]{c.colName(TABLE_NAME_PREFIX + currentTableIndex, "qname_value")}), (NonBooleanExpression)l.n((Number)totalItemsProcessed)));
                }
            }
            whereClause.and((BooleanExpression)collectionCondition.createExpression());
        } else if (value instanceof ValueComposite) {
            for (Property property : ((CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)((ValueComposite)value))).state().properties()) {
                Boolean qNameJoinDone = false;
                Integer sourceIndex = maxTableIndex.getInt();
                Integer targetIndex = sourceIndex + 1;
                for (QNameJoin join : qNameJoins) {
                    if (!join.getSourceQName().equals((Object)qName)) continue;
                    sourceIndex = join.getSourceTableIndex();
                    if (!join.getTargetQName().equals((Object)this.spi.propertyDescriptorFor(property).qualifiedName())) continue;
                    qNameJoinDone = true;
                    targetIndex = join.getTargetTableIndex();
                    break;
                }
                if (!qNameJoinDone.booleanValue()) {
                    QNameInfo info = (QNameInfo)((Map)this._state.qNameInfos().get()).get(this.spi.propertyDescriptorFor(property).qualifiedName());
                    String prevTableName = TABLE_NAME_PREFIX + sourceIndex;
                    String nextTableName = TABLE_NAME_PREFIX + targetIndex;
                    fromClause.addQualifiedJoin(JoinType.LEFT_OUTER, (TableReference)t.table((TableName)t.tableName(schemaName, info.getTableName()), t.tableAlias(TABLE_NAME_PREFIX + targetIndex)), (JoinSpecification)t.jc((BooleanExpression)b.booleanBuilder((BooleanExpression)b.eq((NonBooleanExpression)c.colName(prevTableName, "qname_id"), (NonBooleanExpression)c.colName(nextTableName, "parent_qname"))).and((BooleanExpression)b.eq((NonBooleanExpression)c.colName(prevTableName, "entity_pk"), (NonBooleanExpression)c.colName(nextTableName, "entity_pk"))).createExpression()));
                    qNameJoins.add(new QNameJoin(qName, this.spi.propertyDescriptorFor(property).qualifiedName(), sourceIndex, targetIndex));
                    maxTableIndex.setInt(maxTableIndex.getInt() + 1);
                }
                this.modifyFromClauseAndWhereClauseToGetValue(this.spi.propertyDescriptorFor(property).qualifiedName(), property.get(), predicate, negationActive, targetIndex, maxTableIndex, columnName, collectionPath, vendor, whereClause, afterWhere, fromClause, groupBy, having, qNameJoins, variables, values, valueSQLTypes);
            }
        } else {
            ColumnReferenceByName valueCol = c.colName(TABLE_NAME_PREFIX + currentTableIndex, columnName);
            if (value == null) {
                whereClause.and((BooleanExpression)b.isNull((NonBooleanExpression)valueCol));
            } else {
                Object dbValue = value;
                if (Enum.class.isAssignableFrom(value.getClass())) {
                    dbValue = ((Map)this._state.enumPKs().get()).get(value.getClass().getName());
                }
                whereClause.and((BooleanExpression)b.and((BooleanExpression)b.isNotNull((NonBooleanExpression)valueCol), this.getOperator(predicate).getExpression(b, (NonBooleanExpression)valueCol, (NonBooleanExpression)l.param())));
                values.add(dbValue);
                valueSQLTypes.add(this._typeHelper.getSQLType(value));
                LOGGER.info(TABLE_NAME_PREFIX + currentTableIndex + "." + columnName + " is " + dbValue);
            }
        }
        return result;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)AbstractSQLQuerying.class.getName());
        SQL_OPERATORS = new HashMap<Class<? extends Specification>, SQLBooleanCreator>(9);
        SQL_OPERATORS.put(EqSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.eq(left, right);
            }
        });
        SQL_OPERATORS.put(GeSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.geq(left, right);
            }
        });
        SQL_OPERATORS.put(GtSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.gt(left, right);
            }
        });
        SQL_OPERATORS.put(LeSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.leq(left, right);
            }
        });
        SQL_OPERATORS.put(LtSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.lt(left, right);
            }
        });
        SQL_OPERATORS.put(ManyAssociationContainsSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.eq(left, right);
            }
        });
        SQL_OPERATORS.put(MatchesSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.regexp(left, right);
            }
        });
        SQL_OPERATORS.put(ContainsSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.eq(left, right);
            }
        });
        SQL_OPERATORS.put(ContainsAllSpecification.class, new SQLBooleanCreator(){

            @Override
            public BooleanExpression getExpression(BooleanFactory factory, NonBooleanExpression left, NonBooleanExpression right) {
                return factory.eq(left, right);
            }
        });
        JOIN_STYLES = new HashMap<Class<? extends Specification>, JoinType>(13);
        JOIN_STYLES.put(EqSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(GeSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(GtSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(LeSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(LtSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(PropertyNullSpecification.class, JoinType.LEFT_OUTER);
        JOIN_STYLES.put(PropertyNotNullSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(AssociationNullSpecification.class, JoinType.LEFT_OUTER);
        JOIN_STYLES.put(AssociationNotNullSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(ManyAssociationContainsSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(MatchesSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(ContainsSpecification.class, JoinType.INNER);
        JOIN_STYLES.put(ContainsAllSpecification.class, JoinType.INNER);
        NEGATED_JOIN_STYLES = new HashMap<Class<? extends Specification>, JoinType>(13);
        NEGATED_JOIN_STYLES.put(EqSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(GeSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(GtSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(LeSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(LtSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(PropertyNullSpecification.class, JoinType.INNER);
        NEGATED_JOIN_STYLES.put(PropertyNotNullSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(AssociationNullSpecification.class, JoinType.INNER);
        NEGATED_JOIN_STYLES.put(AssociationNotNullSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(ManyAssociationContainsSpecification.class, JoinType.INNER);
        NEGATED_JOIN_STYLES.put(MatchesSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(ContainsSpecification.class, JoinType.LEFT_OUTER);
        NEGATED_JOIN_STYLES.put(ContainsAllSpecification.class, JoinType.LEFT_OUTER);
        EXPRESSION_PROCESSORS = new HashMap(17);
        EXPRESSION_PROCESSORS.put(AndSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                QueryBuilder result = null;
                AndSpecification conjunction = (AndSpecification)expression;
                for (Specification entitySpecification : conjunction.operands()) {
                    if (result == null) {
                        result = thisObject.processBooleanExpression((Specification<Composite>)entitySpecification, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
                        continue;
                    }
                    result = result.intersect((QueryExpressionBody)thisObject.processBooleanExpression((Specification<Composite>)entitySpecification, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes).createExpression());
                }
                return result;
            }
        });
        EXPRESSION_PROCESSORS.put(OrSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                QueryBuilder result = null;
                OrSpecification conjunction = (OrSpecification)expression;
                for (Specification entitySpecification : conjunction.operands()) {
                    if (result == null) {
                        result = thisObject.processBooleanExpression((Specification<Composite>)entitySpecification, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
                        continue;
                    }
                    result = result.union((QueryExpressionBody)thisObject.processBooleanExpression((Specification<Composite>)entitySpecification, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes).createExpression());
                }
                return result;
            }
        });
        EXPRESSION_PROCESSORS.put(NotSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processBooleanExpression((Specification<Composite>)((NotSpecification)expression).operand(), negationActive == false, vendor, entityTypeCondition, variables, values, valueSQLTypes);
            }
        });
        EXPRESSION_PROCESSORS.put(MatchesSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processMatchesPredicate((MatchesSpecification)expression, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
            }
        });
        EXPRESSION_PROCESSORS.put(ManyAssociationContainsSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processManyAssociationContainsPredicate((ManyAssociationContainsSpecification)expression, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
            }
        });
        EXPRESSION_PROCESSORS.put(PropertyNullSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processPropertyNullPredicate((PropertyNullSpecification)expression, negationActive, vendor, entityTypeCondition);
            }
        });
        EXPRESSION_PROCESSORS.put(PropertyNotNullSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processPropertyNotNullPredicate((PropertyNotNullSpecification)expression, negationActive, vendor, entityTypeCondition);
            }
        });
        EXPRESSION_PROCESSORS.put(AssociationNullSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processAssociationNullPredicate((AssociationNullSpecification)expression, negationActive, vendor, entityTypeCondition);
            }
        });
        EXPRESSION_PROCESSORS.put(AssociationNotNullSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processAssociationNotNullPredicate((AssociationNotNullSpecification)expression, negationActive, vendor, entityTypeCondition);
            }
        });
        EXPRESSION_PROCESSORS.put(ContainsSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processContainsPredicate((ContainsSpecification)expression, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
            }
        });
        EXPRESSION_PROCESSORS.put(ContainsAllSpecification.class, new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processContainsAllPredicate((ContainsAllSpecification)expression, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
            }
        });
        BooleanExpressionProcessor comparisonProcessor = new BooleanExpressionProcessor(){

            @Override
            public QueryBuilder processBooleanExpression(AbstractSQLQuerying thisObject, Specification<Composite> expression, Boolean negationActive, SQLVendor vendor, BooleanExpression entityTypeCondition, Map<String, Object> variables, List<Object> values, List<Integer> valueSQLTypes) {
                return thisObject.processComparisonPredicate((ComparisonSpecification)expression, negationActive, vendor, entityTypeCondition, variables, values, valueSQLTypes);
            }
        };
        EXPRESSION_PROCESSORS.put(EqSpecification.class, comparisonProcessor);
        EXPRESSION_PROCESSORS.put(NeSpecification.class, comparisonProcessor);
        EXPRESSION_PROCESSORS.put(GeSpecification.class, comparisonProcessor);
        EXPRESSION_PROCESSORS.put(GtSpecification.class, comparisonProcessor);
        EXPRESSION_PROCESSORS.put(LeSpecification.class, comparisonProcessor);
        EXPRESSION_PROCESSORS.put(LtSpecification.class, comparisonProcessor);
    }

    private static class QNameJoin {
        private final QualifiedName _sourceQName;
        private final QualifiedName _targetQName;
        private final Integer _sourceTableIndex;
        private final Integer _targetTableIndex;

        private QNameJoin(QualifiedName sourceQName, QualifiedName targetQName, Integer sourceTableIndex, Integer targetTableIndex) {
            this._sourceQName = sourceQName;
            this._targetQName = targetQName;
            this._sourceTableIndex = sourceTableIndex;
            this._targetTableIndex = targetTableIndex;
        }

        private QualifiedName getSourceQName() {
            return this._sourceQName;
        }

        private QualifiedName getTargetQName() {
            return this._targetQName;
        }

        private Integer getSourceTableIndex() {
            return this._sourceTableIndex;
        }

        private Integer getTargetTableIndex() {
            return this._targetTableIndex;
        }
    }

    private static class ModifiableInt {
        private int _int;

        private ModifiableInt(Integer integer) {
            this._int = integer;
        }

        private int getInt() {
            return this._int;
        }

        private void setInt(int integer) {
            this._int = integer;
        }

        public String toString() {
            return Integer.toString(this._int);
        }
    }

    private static class AssociationNullWhereClauseProcessor
    implements WhereClauseProcessor {
        private final boolean negationActive;
        private final SQLVendor vendor;

        private AssociationNullWhereClauseProcessor(SQLVendor pVendor, boolean pNegationActive) {
            this.vendor = pVendor;
            this.negationActive = pNegationActive;
        }

        @Override
        public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
            if (!this.negationActive) {
                ColumnsFactory c = this.vendor.getColumnsFactory();
                BooleanFactory b = this.vendor.getBooleanFactory();
                builder.getWhere().reset((BooleanExpression)b.isNull((NonBooleanExpression)c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, "qname_value")));
            }
        }
    }

    private static class PropertyNullWhereClauseProcessor
    implements WhereClauseProcessor {
        private final boolean negationActive;
        private final SQLVendor vendor;
        private final SQLDBState state;
        private final PropertyFunction<?> propFunction;

        private PropertyNullWhereClauseProcessor(SQLDBState pState, SQLVendor pVendor, PropertyFunction<?> pPropFunction, boolean pNegationActive) {
            this.state = pState;
            this.vendor = pVendor;
            this.negationActive = pNegationActive;
            this.propFunction = pPropFunction;
        }

        @Override
        public void processWhereClause(QuerySpecificationBuilder builder, BooleanBuilder afterWhere, JoinType joinStyle, Integer firstTableIndex, Integer lastTableIndex) {
            if (!this.negationActive) {
                ColumnsFactory c = this.vendor.getColumnsFactory();
                BooleanFactory b = this.vendor.getBooleanFactory();
                QNameInfo info = (QNameInfo)((Map)this.state.qNameInfos().get()).get(QualifiedName.fromAccessor((AccessibleObject)this.propFunction.accessor()));
                String colName = info.getCollectionDepth() > 0 ? "qname_id" : "qname_value";
                builder.getWhere().reset((BooleanExpression)b.isNull((NonBooleanExpression)c.colName(AbstractSQLQuerying.TABLE_NAME_PREFIX + lastTableIndex, colName)));
            }
        }
    }

    private static interface WhereClauseProcessor {
        public void processWhereClause(QuerySpecificationBuilder var1, BooleanBuilder var2, JoinType var3, Integer var4, Integer var5);
    }

    private static interface BooleanExpressionProcessor {
        public QueryBuilder processBooleanExpression(AbstractSQLQuerying var1, Specification<Composite> var2, Boolean var3, SQLVendor var4, BooleanExpression var5, Map<String, Object> var6, List<Object> var7, List<Integer> var8);
    }

    public static interface SQLBooleanCreator {
        public BooleanExpression getExpression(BooleanFactory var1, NonBooleanExpression var2, NonBooleanExpression var3);
    }

    private static class TraversedAssoOrManyAssoRef {
        private final AssociationFunction<?> _traversedAsso;
        private final ManyAssociationFunction<?> _traversedManyAsso;
        private final boolean _hasRefs;

        private TraversedAssoOrManyAssoRef(AssociationFunction<?> func) {
            this(func.traversedAssociation(), func.traversedManyAssociation());
        }

        private TraversedAssoOrManyAssoRef(PropertyFunction<?> func) {
            this(func.traversedAssociation(), func.traversedManyAssociation());
        }

        private TraversedAssoOrManyAssoRef(ManyAssociationFunction<?> func) {
            this(func.traversedAssociation(), func.traversedManyAssociation());
        }

        private TraversedAssoOrManyAssoRef(AssociationNullSpecification<?> spec) {
            this(spec.association(), null);
        }

        private TraversedAssoOrManyAssoRef(AssociationNotNullSpecification<?> spec) {
            this(spec.association(), null);
        }

        private TraversedAssoOrManyAssoRef(ManyAssociationContainsSpecification<?> spec) {
            this(null, spec.manyAssociation());
        }

        private TraversedAssoOrManyAssoRef(AssociationFunction<?> traversedAsso, ManyAssociationFunction<?> traversedManyAsso) {
            this._traversedAsso = traversedAsso;
            this._traversedManyAsso = traversedManyAsso;
            this._hasRefs = this._traversedAsso != null || this._traversedManyAsso != null;
        }

        private TraversedAssoOrManyAssoRef getTraversedAssociation() {
            return this._traversedAsso == null ? new TraversedAssoOrManyAssoRef(this._traversedManyAsso) : new TraversedAssoOrManyAssoRef(this._traversedAsso);
        }

        private AccessibleObject getAccessor() {
            return this._traversedAsso == null ? this._traversedManyAsso.accessor() : this._traversedAsso.accessor();
        }

        public String toString() {
            return "[hasRefs=" + this._hasRefs + ", ref:" + (this._hasRefs ? (this._traversedAsso == null ? this._traversedManyAsso : this._traversedAsso) : "null") + "]";
        }
    }
}

