/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.locking;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.This;
import org.qi4j.library.locking.ReadLock;

@AppliesTo(value={ReadLock.class})
public class ReadLockConcern
extends ConcernOf<InvocationHandler>
implements InvocationHandler {
    @This
    private ReadWriteLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        Lock readLock = this.lock.readLock();
        this.lock(readLock);
        try {
            Object object = ((InvocationHandler)this.next).invoke(o, method, objects);
            return object;
        }
        finally {
            try {
                this.lock.readLock().unlock();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void lock(Lock lock) {
        while (true) {
            try {
                while (!lock.tryLock(1000L, TimeUnit.MILLISECONDS)) {
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

