/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.lang.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.common.AppliesToFilter;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.injection.scope.This;
import org.qi4j.io.Inputs;
import org.qi4j.io.Outputs;

@org.qi4j.api.common.AppliesTo(value={AppliesTo.class})
public class GroovyMixin
implements InvocationHandler {
    @This
    private Composite me;
    private final Map<Class, GroovyObject> groovyObjects = new HashMap<Class, GroovyObject>();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        FunctionResource groovySource = GroovyMixin.getFunctionResource(method);
        if (groovySource != null) {
            if (groovySource.script) {
                return this.invokeAsObject(method, args, groovySource.url);
            }
            return this.invokeAsScript(method, args, groovySource.url);
        }
        throw new RuntimeException("Internal error: Mixin invoked even if it does not apply");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeAsObject(Method method, Object[] args, URL groovySource) throws Throwable {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            GroovyObject groovyObject = this.groovyObjects.get(declaringClass);
            if (groovyObject == null) {
                Class groovyClass;
                try (InputStream is = null;){
                    is = groovySource.openStream();
                    StringBuilder sourceBuilder = new StringBuilder();
                    Inputs.text((URL)groovySource).transferTo(Outputs.text((StringBuilder)sourceBuilder));
                    GroovyClassLoader groovyClassLoader = new GroovyClassLoader(declaringClass.getClassLoader());
                    groovyClass = groovyClassLoader.parseClass(sourceBuilder.toString());
                }
                groovyObject = (GroovyObject)groovyClass.newInstance();
                if (this.hasProperty(groovyObject, "This")) {
                    groovyObject.setProperty("This", (Object)this.me);
                }
                this.groovyObjects.put(declaringClass, groovyObject);
            }
            return groovyObject.invokeMethod(method.getName(), (Object)args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private boolean hasProperty(GroovyObject groovyObject, String propertyName) {
        try {
            groovyObject.getProperty(propertyName);
            return true;
        }
        catch (MissingPropertyException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeAsScript(Method method, Object[] args, URL groovySource) throws Throwable {
        Object object;
        block6: {
            Binding binding = new Binding();
            binding.setVariable("This", (Object)this.me);
            binding.setVariable("args", (Object)args);
            GroovyShell shell = new GroovyShell(binding);
            InputStream is = null;
            try {
                is = groovySource.openStream();
                object = shell.evaluate((Reader)new InputStreamReader(is));
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            is.close();
        }
        return object;
    }

    private static FunctionResource getFunctionResource(Method method) {
        boolean script = false;
        String scriptPath = method.getDeclaringClass().getName().replace('.', File.separatorChar);
        String scriptFile = scriptPath + "." + method.getName() + ".groovy";
        URL scriptUrl = method.getDeclaringClass().getClassLoader().getResource(scriptFile);
        if (scriptUrl == null) {
            script = true;
            scriptFile = scriptPath + ".groovy";
            scriptUrl = method.getDeclaringClass().getClassLoader().getResource(scriptFile);
        }
        if (scriptUrl != null) {
            return new FunctionResource(script, scriptUrl);
        }
        return null;
    }

    private static class FunctionResource {
        URL url;
        boolean script;

        private FunctionResource(boolean script, URL url) {
            this.script = script;
            this.url = url;
        }
    }

    public static class AppliesTo
    implements AppliesToFilter {
        public boolean appliesTo(Method method, Class compositeType, Class mixin, Class modelClass) {
            return GroovyMixin.getFunctionResource(method) != null;
        }
    }
}

