/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.jclouds;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.io.Payload;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.entitystore.jclouds.JCloudsMapEntityStoreConfiguration;
import org.qi4j.io.Input;
import org.qi4j.io.Inputs;
import org.qi4j.io.Output;
import org.qi4j.io.Outputs;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCloudsMapEntityStoreMixin
implements ServiceActivation,
MapEntityStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.qi4j.entitystore.jclouds");
    private static final Map<String, ApiMetadata> allApis = Maps.uniqueIndex((Iterable)Apis.viewableAs(BlobStoreContext.class), (Function)Apis.idFunction());
    private static final Map<String, ProviderMetadata> appProviders = Maps.uniqueIndex((Iterable)Providers.viewableAs(BlobStoreContext.class), (Function)Providers.idFunction());
    private static final Set<String> allKeys = ImmutableSet.copyOf((Iterable)Iterables.concat(appProviders.keySet(), allApis.keySet()));
    @This
    private Configuration<JCloudsMapEntityStoreConfiguration> configuration;
    private BlobStoreContext storeContext;
    private String container;

    public void activateService() throws Exception {
        this.configuration.refresh();
        String provider = (String)((JCloudsMapEntityStoreConfiguration)this.configuration.get()).provider().get();
        String identifier = (String)((JCloudsMapEntityStoreConfiguration)this.configuration.get()).identifier().get();
        String credentials = (String)((JCloudsMapEntityStoreConfiguration)this.configuration.get()).credential().get();
        Map properties = (Map)((JCloudsMapEntityStoreConfiguration)this.configuration.get()).properties().get();
        this.container = (String)((JCloudsMapEntityStoreConfiguration)this.configuration.get()).container().get();
        if (provider != null) {
            Preconditions.checkArgument((boolean)Iterables.contains(allKeys, (Object)provider), (String)"provider %s not in supported list: %s", (Object[])new Object[]{provider, allKeys});
        } else {
            provider = "transient";
        }
        if (this.container == null) {
            this.container = "qi4j-entities";
        }
        this.storeContext = (BlobStoreContext)ContextBuilder.newBuilder((String)provider).credentials(identifier, credentials).overrides(this.asProperties(properties)).buildView(BlobStoreContext.class);
        BlobStore blobStore = this.storeContext.getBlobStore();
        if (!blobStore.containerExists(this.container)) {
            if (!blobStore.createContainerInLocation(null, this.container)) {
                throw new EntityStoreException("Unable to create JClouds Blob Container, cannot continue.");
            }
            LOGGER.debug("Created new container: {}", (Object)this.container);
        }
        LOGGER.info("Activated using {} cloud provider [id:{}]", (Object)provider, (Object)identifier);
    }

    private Properties asProperties(Map<String, String> map) {
        Properties props = new Properties();
        for (Map.Entry<String, String> eachEntry : map.entrySet()) {
            props.put(eachEntry.getKey(), eachEntry.getValue());
        }
        return props;
    }

    public void passivateService() throws Exception {
        if (this.storeContext != null) {
            this.storeContext.close();
            this.storeContext = null;
            this.container = null;
        }
    }

    public Reader get(EntityReference entityReference) throws EntityStoreException {
        Blob blob = this.storeContext.getBlobStore().getBlob(this.container, entityReference.identity());
        if (blob == null) {
            throw new EntityNotFoundException(entityReference);
        }
        Payload payload = blob.getPayload();
        if (payload == null) {
            throw new EntityNotFoundException(entityReference);
        }
        InputStream input = null;
        try {
            input = payload.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Inputs.byteBuffer((InputStream)input, (int)4096).transferTo(Outputs.byteBuffer((OutputStream)baos));
            StringReader stringReader = new StringReader(baos.toString("UTF-8"));
            return stringReader;
        }
        catch (IOException ex) {
            throw new EntityStoreException("Unable to read entity state for: " + entityReference, (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        final BlobStore blobStore = this.storeContext.getBlobStore();
        changes.visitMap(new MapEntityStore.MapChanger(){

            public Writer newEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                return new StringWriter(){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        Blob blob = blobStore.blobBuilder(ref.identity()).payload(ByteSource.wrap((byte[])this.toString().getBytes(Charsets.UTF_8))).build();
                        blobStore.putBlob(JCloudsMapEntityStoreMixin.this.container, blob);
                    }
                };
            }

            public Writer updateEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                if (!blobStore.blobExists(JCloudsMapEntityStoreMixin.this.container, ref.identity())) {
                    throw new EntityNotFoundException(ref);
                }
                return new StringWriter(){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        Blob blob = blobStore.blobBuilder(ref.identity()).payload(ByteSource.wrap((byte[])this.toString().getBytes(Charsets.UTF_8))).build();
                        blobStore.putBlob(JCloudsMapEntityStoreMixin.this.container, blob);
                    }
                };
            }

            public void removeEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws EntityNotFoundException {
                if (!blobStore.blobExists(JCloudsMapEntityStoreMixin.this.container, ref.identity())) {
                    throw new EntityNotFoundException(ref);
                }
                blobStore.removeBlob(JCloudsMapEntityStoreMixin.this.container, ref.identity());
            }
        });
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                        for (StorageMetadata stored : JCloudsMapEntityStoreMixin.this.storeContext.getBlobStore().list()) {
                            Payload payload = JCloudsMapEntityStoreMixin.this.storeContext.getBlobStore().getBlob(JCloudsMapEntityStoreMixin.this.container, stored.getName()).getPayload();
                            if (payload == null) {
                                throw new EntityNotFoundException(EntityReference.parseEntityReference((String)stored.getName()));
                            }
                            InputStream input = null;
                            try {
                                input = payload.openStream();
                                receiver.receive((Object)new InputStreamReader(input, "UTF-8"));
                            }
                            finally {
                                if (input == null) continue;
                                try {
                                    input.close();
                                }
                                catch (IOException ignored) {}
                            }
                        }
                    }
                });
            }
        };
    }
}

