/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.activation;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.structure.Application;

public final class ApplicationPassivationThread
extends Thread {
    public ApplicationPassivationThread(Application application) {
        this(application, null, null);
    }

    public ApplicationPassivationThread(Application application, Logger logger) {
        this(application, null, logger);
    }

    public ApplicationPassivationThread(Application application, PrintStream output) {
        this(application, output, null);
    }

    private ApplicationPassivationThread(Application application, PrintStream output, Logger logger) {
        super((Runnable)new ApplicationPassivation(application, output, logger), application.name() + " Passivation Thread");
    }

    private static class ApplicationPassivation
    implements Runnable {
        private final Application application;
        private final PrintStream output;
        private final Logger logger;

        private ApplicationPassivation(Application application, PrintStream output, Logger logger) {
            this.application = application;
            this.output = output;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                this.application.passivate();
            }
            catch (PassivationException ex) {
                String message = this.application.name() + " " + ex.getMessage();
                if (this.logger != null) {
                    this.logger.log(Level.SEVERE, message, ex);
                }
                if (this.output != null) {
                    this.output.println(message);
                    ex.printStackTrace(this.output);
                }
                ex.printStackTrace();
            }
        }
    }
}

