/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.common;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.qi4j.api.common.TypeName;
import org.qi4j.api.util.NullArgumentException;

public final class QualifiedName
implements Comparable<QualifiedName>,
Serializable {
    private final TypeName typeName;
    private final String name;

    public static QualifiedName fromAccessor(AccessibleObject method) {
        NullArgumentException.validateNotNull("method", method);
        return QualifiedName.fromClass(((Member)((Object)method)).getDeclaringClass(), ((Member)((Object)method)).getName());
    }

    public static QualifiedName fromClass(Class type, String name) {
        return new QualifiedName(TypeName.nameOf(type), name);
    }

    public static QualifiedName fromName(String type, String name) {
        return new QualifiedName(TypeName.nameOf(type), name);
    }

    public static QualifiedName fromFQN(String fullQualifiedName) {
        NullArgumentException.validateNotEmpty("qualifiedName", fullQualifiedName);
        int idx = fullQualifiedName.lastIndexOf(":");
        if (idx == -1) {
            throw new IllegalArgumentException("Name '" + fullQualifiedName + "' is not a qualified name");
        }
        String type = fullQualifiedName.substring(0, idx);
        String name = fullQualifiedName.substring(idx + 1);
        return new QualifiedName(TypeName.nameOf(type), name);
    }

    QualifiedName(TypeName typeName, String name) {
        NullArgumentException.validateNotNull("typeName", typeName);
        NullArgumentException.validateNotEmpty("name", name);
        this.typeName = typeName;
        this.name = name;
    }

    public String type() {
        return this.typeName.normalized();
    }

    public String name() {
        return this.name;
    }

    public String toURI() {
        return this.toNamespace() + this.name;
    }

    public String toNamespace() {
        return this.typeName.toURI() + "#";
    }

    public String toString() {
        return this.typeName + ":" + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.name.equals(that.name) && this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        return 31 * this.typeName.hashCode() + this.name.hashCode();
    }

    @Override
    public int compareTo(QualifiedName other) {
        int result = this.typeName.compareTo(other.typeName);
        if (result != 0) {
            return result;
        }
        return this.name.compareTo(other.name);
    }
}

