/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.common;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.NullArgumentException;

public final class TypeName
implements Serializable,
Comparable<TypeName> {
    private final String name;

    public static TypeName nameOf(Class type) {
        NullArgumentException.validateNotNull("type", type);
        return new TypeName(type.getName());
    }

    public static TypeName nameOf(Type type) {
        return TypeName.nameOf((Class)Classes.RAW_CLASS.map((Object)type));
    }

    public static TypeName nameOf(String typeName) {
        return new TypeName(typeName);
    }

    private TypeName(String name) {
        NullArgumentException.validateNotEmpty("name", name);
        this.name = name;
    }

    public String normalized() {
        return Classes.normalizeClassToURI(this.name);
    }

    public String toURI() {
        return Classes.toURI(this.name);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isClass(Class<?> type) {
        return type.getName().equals(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeName other = (TypeName)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(TypeName typeName) {
        return this.name.compareTo(typeName.name);
    }
}

