/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.composite;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Property;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.Dates;
import org.qi4j.api.value.ValueComposite;

public final class PropertyMapper {
    private static final Map<Type, MappingStrategy> STRATEGY = new HashMap<Type, MappingStrategy>();

    public static void map(Properties props, Composite composite) throws IllegalArgumentException {
        for (Map.Entry<Object, Object> objectObjectEntry : props.entrySet()) {
            try {
                String methodName = objectObjectEntry.getKey().toString();
                Method propertyMethod = composite.getClass().getInterfaces()[0].getMethod(methodName, new Class[0]);
                propertyMethod.setAccessible(true);
                Object value = objectObjectEntry.getValue();
                Type propertyType = GenericPropertyInfo.propertyTypeOf(propertyMethod);
                value = PropertyMapper.mapToType(composite, propertyType, value.toString());
                Property property = (Property)propertyMethod.invoke((Object)composite, new Object[0]);
                property.set(value);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find any property named " + objectObjectEntry.getKey());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not populate property named " + objectObjectEntry.getKey(), e);
            }
            catch (InvocationTargetException e) {
                String message = "Could not populate property named " + objectObjectEntry.getKey();
                throw new IllegalArgumentException(message, e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object mapToType(Composite composite, Type propertyType, Object value) {
        MappingStrategy strategy;
        String stringValue = value.toString();
        if (propertyType instanceof Class) {
            Class type = (Class)propertyType;
            strategy = type.isArray() ? STRATEGY.get(Array.class) : (Enum.class.isAssignableFrom((Class)Classes.RAW_CLASS.map((Object)propertyType)) ? STRATEGY.get(Enum.class) : STRATEGY.get(type));
            if (strategy == null) {
                strategy = STRATEGY.get(ValueComposite.class);
            }
        } else {
            if (!(propertyType instanceof ParameterizedType)) throw new IllegalArgumentException(propertyType + " is not supported.");
            ParameterizedType type = (ParameterizedType)propertyType;
            if (!(type.getRawType() instanceof Class)) throw new IllegalArgumentException(propertyType + " is not supported.");
            Class clazz = (Class)type.getRawType();
            if (List.class.isAssignableFrom(clazz)) {
                strategy = STRATEGY.get(List.class);
            } else if (Set.class.isAssignableFrom(clazz)) {
                strategy = STRATEGY.get(Set.class);
            } else {
                if (!Map.class.isAssignableFrom(clazz)) throw new IllegalArgumentException(propertyType + " is not supported.");
                strategy = STRATEGY.get(Map.class);
            }
        }
        if (strategy != null) return strategy.map(composite, propertyType, stringValue);
        throw new IllegalArgumentException(propertyType + " is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void map(InputStream propertyInputStream, Composite composite) throws IOException {
        if (propertyInputStream != null) {
            Properties configProps = new Properties();
            try {
                configProps.load(propertyInputStream);
            }
            finally {
                propertyInputStream.close();
            }
            PropertyMapper.map(configProps, composite);
        }
    }

    public static Properties toJavaProperties(final Composite composite) {
        return new Properties(){
            private static final long serialVersionUID = 3550125427530538865L;

            @Override
            public Object get(Object o) {
                try {
                    Method propertyMethod = composite.getClass().getMethod(o.toString(), new Class[0]);
                    Property property = (Property)propertyMethod.invoke((Object)composite, new Object[0]);
                    return property.get();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }

            @Override
            public Object put(Object o, Object o1) {
                Object oldValue = this.get(o);
                try {
                    Method propertyMethod = composite.getClass().getMethod(o.toString(), Object.class);
                    propertyMethod.invoke((Object)composite, o1);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return oldValue;
            }
        };
    }

    private static void tokenize(String valueString, boolean mapSyntax, TokenizerCallback callback) {
        char[] data = valueString.toCharArray();
        int oldPos = 0;
        for (int pos = 0; pos < data.length; ++pos) {
            char ch = data[pos];
            if (ch == '\"') {
                oldPos = pos = PropertyMapper.resolveQuotes(valueString, callback, data, pos, '\"');
            }
            if (ch == '\'') {
                oldPos = pos = PropertyMapper.resolveQuotes(valueString, callback, data, pos, '\'');
            }
            if (ch != ',' && (!mapSyntax || ch != ':')) continue;
            String token = new String(data, oldPos, pos - oldPos);
            callback.token(token);
            oldPos = pos + 1;
        }
        String token = new String(data, oldPos, data.length - oldPos);
        callback.token(token);
    }

    private static int resolveQuotes(String valueString, TokenizerCallback callback, char[] data, int pos, char quote) {
        boolean found = false;
        for (int j = pos + 1; j < data.length; ++j) {
            if (!found) {
                if (data[j] != quote) continue;
                String token = new String(data, pos + 1, j - pos - 1);
                callback.token(token);
                found = true;
                continue;
            }
            if (data[j] != ',') continue;
            return j + 1;
        }
        if (!found) {
            throw new IllegalArgumentException("String is not quoted correctly: " + valueString);
        }
        return data.length;
    }

    private PropertyMapper() {
    }

    static {
        STRATEGY.put((Type)((Object)Integer.class), new IntegerMapper());
        STRATEGY.put((Type)((Object)Long.class), new LongMapper());
        STRATEGY.put((Type)((Object)Short.class), new ShortMapper());
        STRATEGY.put((Type)((Object)Byte.class), new ByteMapper());
        STRATEGY.put((Type)((Object)String.class), new StringMapper());
        STRATEGY.put((Type)((Object)Character.class), new CharMapper());
        STRATEGY.put((Type)((Object)Float.class), new FloatMapper());
        STRATEGY.put((Type)((Object)Double.class), new DoubleMapper());
        STRATEGY.put((Type)((Object)Date.class), new DateMapper());
        STRATEGY.put((Type)((Object)Boolean.class), new BooleanMapper());
        STRATEGY.put((Type)((Object)BigDecimal.class), new BigDecimalMapper());
        STRATEGY.put((Type)((Object)BigInteger.class), new BigIntegerMapper());
        STRATEGY.put((Type)((Object)Enum.class), new EnumMapper());
        STRATEGY.put((Type)((Object)Array.class), new ArrayMapper());
        STRATEGY.put((Type)((Object)Map.class), new MapMapper());
        STRATEGY.put((Type)((Object)List.class), new ListMapper());
        STRATEGY.put((Type)((Object)Set.class), new SetMapper());
        STRATEGY.put((Type)((Object)ValueComposite.class), new ValueCompositeMapper());
    }

    private static class MapMapper
    implements MappingStrategy {
        private MapMapper() {
        }

        @Override
        public Object map(final Composite composite, Type generictype, String value) {
            ParameterizedType type = (ParameterizedType)generictype;
            final Type keyType = type.getActualTypeArguments()[0];
            final Type valueType = type.getActualTypeArguments()[0];
            final HashMap result = new HashMap();
            PropertyMapper.tokenize(value, true, new TokenizerCallback(){
                boolean keyArrivingNext = true;
                String key;

                @Override
                public void token(String token) {
                    if (this.keyArrivingNext) {
                        this.key = token;
                        this.keyArrivingNext = false;
                    } else {
                        result.put(PropertyMapper.mapToType(composite, keyType, this.key), PropertyMapper.mapToType(composite, valueType, token));
                        this.keyArrivingNext = true;
                    }
                }
            });
            return result;
        }
    }

    private static class SetMapper
    implements MappingStrategy {
        private SetMapper() {
        }

        @Override
        public Object map(final Composite composite, Type type, String value) {
            final Type dataType = ((ParameterizedType)type).getActualTypeArguments()[0];
            final HashSet result = new HashSet();
            PropertyMapper.tokenize(value, false, new TokenizerCallback(){

                @Override
                public void token(String token) {
                    result.add(PropertyMapper.mapToType(composite, dataType, token));
                }
            });
            return result;
        }
    }

    private static class ListMapper
    implements MappingStrategy {
        private ListMapper() {
        }

        @Override
        public Object map(final Composite composite, Type type, String value) {
            final Type dataType = ((ParameterizedType)type).getActualTypeArguments()[0];
            final ArrayList result = new ArrayList();
            PropertyMapper.tokenize(value, false, new TokenizerCallback(){

                @Override
                public void token(String token) {
                    result.add(PropertyMapper.mapToType(composite, dataType, token));
                }
            });
            return result;
        }
    }

    private static class BooleanMapper
    implements MappingStrategy {
        private BooleanMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return Boolean.valueOf(value.trim());
        }
    }

    private static class ArrayMapper
    implements MappingStrategy {
        private ArrayMapper() {
        }

        @Override
        public Object map(final Composite composite, Type type, String value) {
            final Class<?> arrayType = ((Class)type).getComponentType();
            final ArrayList result = new ArrayList();
            PropertyMapper.tokenize(value, false, new TokenizerCallback(){

                @Override
                public void token(String token) {
                    result.add(PropertyMapper.mapToType(composite, arrayType, token));
                }
            });
            return result.toArray((Object[])Array.newInstance(arrayType, result.size()));
        }
    }

    private static class ValueCompositeMapper
    implements MappingStrategy {
        private ValueCompositeMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return ((CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)composite)).module().newValueFromSerializedState((Class)type, value);
        }
    }

    private static class DateMapper
    implements MappingStrategy {
        private DateMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return Dates.fromString(value.trim());
        }
    }

    private static class EnumMapper
    implements MappingStrategy {
        private EnumMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return Enum.valueOf((Class)type, value);
        }
    }

    private static class BigIntegerMapper
    implements MappingStrategy {
        private BigIntegerMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new BigInteger(value.trim());
        }
    }

    private static class BigDecimalMapper
    implements MappingStrategy {
        private BigDecimalMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new BigDecimal(value.trim());
        }
    }

    private static class CharMapper
    implements MappingStrategy {
        private CharMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return Character.valueOf(value.trim().charAt(0));
        }
    }

    private static class ByteMapper
    implements MappingStrategy {
        private ByteMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new Byte(value.trim());
        }
    }

    private static class ShortMapper
    implements MappingStrategy {
        private ShortMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new Short(value.trim());
        }
    }

    private static class LongMapper
    implements MappingStrategy {
        private LongMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new Long(value.trim());
        }
    }

    private static class DoubleMapper
    implements MappingStrategy {
        private DoubleMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new Double(value.trim());
        }
    }

    private static class FloatMapper
    implements MappingStrategy {
        private FloatMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new Float(value.trim());
        }
    }

    private static class IntegerMapper
    implements MappingStrategy {
        private IntegerMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return new Integer(value.trim());
        }
    }

    private static class StringMapper
    implements MappingStrategy {
        private StringMapper() {
        }

        @Override
        public Object map(Composite composite, Type type, String value) {
            return value;
        }
    }

    private static interface MappingStrategy {
        public Object map(Composite var1, Type var2, String var3);
    }

    private static interface TokenizerCallback {
        public void token(String var1);
    }
}

