/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.PropertyMapper;
import org.qi4j.api.configuration.NoSuchConfigurationException;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.ServiceTags;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.functional.Iterables;

@Mixins(value={ConfigurationMixin.class})
public interface Configuration<T> {
    public T get();

    public void refresh();

    public void save();

    public static class ConfigurationMixin<T>
    implements Configuration<T> {
        private T configuration;
        private UnitOfWork uow;
        @Structure
        private Qi4j api;
        @This
        private ServiceComposite me;
        @Structure
        private Module module;
        @Service
        private Iterable<ServiceReference<ValueSerialization>> valueSerialization;

        @Override
        public synchronized T get() {
            if (this.configuration == null) {
                Usecase usecase = UsecaseBuilder.newUsecase("Configuration:" + this.me.identity().get());
                this.uow = this.module.newUnitOfWork(usecase);
                try {
                    this.configuration = this.findConfigurationInstanceFor(this.me, this.uow);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.configuration;
        }

        @Override
        public synchronized void refresh() {
            if (this.configuration != null) {
                this.configuration = null;
                this.uow.discard();
                this.uow = null;
            }
        }

        @Override
        public void save() {
            if (this.uow != null) {
                try {
                    this.uow.complete();
                    this.uow = null;
                }
                catch (UnitOfWorkCompletionException e) {
                    e.printStackTrace();
                }
                this.configuration = null;
            }
        }

        public <V> V findConfigurationInstanceFor(ServiceComposite serviceComposite, UnitOfWork uow) throws InstantiationException {
            Object configuration;
            ServiceDescriptor serviceModel = this.api.serviceDescriptorFor(serviceComposite);
            String identity = serviceComposite.identity().get();
            try {
                configuration = uow.get(serviceModel.configurationType(), identity);
                uow.pause();
            }
            catch (EntityTypeNotFoundException | NoSuchEntityException e) {
                return this.initializeConfigurationInstance(serviceComposite, uow, serviceModel, identity);
            }
            return (V)configuration;
        }

        private <V extends Identity> V initializeConfigurationInstance(ServiceComposite serviceComposite, UnitOfWork uow, ServiceDescriptor serviceModel, String identity) throws InstantiationException {
            Class configType;
            Class type;
            Usecase usecase;
            Module module = this.api.moduleOf(serviceComposite);
            UnitOfWork buildUow = module.newUnitOfWork(usecase = UsecaseBuilder.newUsecase("Configuration:" + this.me.identity().get()));
            Identity config = (Identity)this.tryLoadPropertiesFile(buildUow, type = (Class)Iterables.first(this.api.serviceDescriptorFor(serviceComposite).types()), configType = serviceModel.configurationType(), identity);
            if (config == null && (config = this.tryLoadJsonFile(buildUow, type, configType, identity)) == null && (config = this.tryLoadYamlFile(buildUow, type, configType, identity)) == null && (config = this.tryLoadXmlFile(buildUow, type, configType, identity)) == null) {
                try {
                    EntityBuilder configBuilder = buildUow.newEntityBuilder(serviceModel.configurationType(), identity);
                    configBuilder.newInstance();
                }
                catch (ConstraintViolationException e) {
                    throw new NoSuchConfigurationException(configType, identity, e);
                }
            }
            try {
                buildUow.complete();
                return (V)((Identity)this.findConfigurationInstanceFor(serviceComposite, uow));
            }
            catch (Exception e1) {
                InstantiationException ex = new InstantiationException("Could not instantiate configuration, and no configuration initialization file was found (" + identity + ")");
                ex.initCause(e1);
                throw ex;
            }
        }

        private <C, V> V tryLoadPropertiesFile(UnitOfWork buildUow, Class<C> compositeType, Class<V> configType, String identity) throws InstantiationException {
            EntityBuilder<V> configBuilder = buildUow.newEntityBuilder(configType, identity);
            String resourceName = identity + ".properties";
            InputStream asStream = this.getResource(compositeType, resourceName);
            if (asStream != null) {
                try {
                    PropertyMapper.map(asStream, (Composite)configBuilder.instance());
                    return configBuilder.newInstance();
                }
                catch (IOException e1) {
                    InstantiationException exception = new InstantiationException("Could not read underlying Properties file.");
                    exception.initCause(e1);
                    throw exception;
                }
            }
            return null;
        }

        private InputStream getResource(Class<?> type, String resourceName) {
            if (type.getResource(resourceName) == null && type.getResource("/" + resourceName) != null) {
                resourceName = "/" + resourceName;
            }
            return type.getResourceAsStream(resourceName);
        }

        private <C, V extends Identity> V tryLoadJsonFile(UnitOfWork uow, Class<C> compositeType, Class<V> configType, String identity) {
            return this.readConfig(uow, compositeType, configType, identity, "json", ".json");
        }

        private <C, V extends Identity> V tryLoadYamlFile(UnitOfWork uow, Class<C> compositeType, Class<V> configType, String identity) {
            return this.readConfig(uow, compositeType, configType, identity, "yaml", ".yaml");
        }

        private <C, V extends Identity> V tryLoadXmlFile(UnitOfWork uow, Class<C> compositeType, Class<V> configType, String identity) {
            return this.readConfig(uow, compositeType, configType, identity, "xml", ".xml");
        }

        private <C, V extends Identity> V readConfig(UnitOfWork uow, Class<C> compositeType, Class<V> configType, String identity, String format, String extension) {
            for (ServiceReference<ValueSerialization> serializerRef : this.valueSerialization) {
                String resourceName;
                InputStream asStream;
                ServiceTags serviceTags = serializerRef.metaInfo(ServiceTags.class);
                if (!serviceTags.hasTag(format) || (asStream = this.getResource(compositeType, resourceName = identity + extension)) == null) continue;
                Identity configObject = (Identity)serializerRef.get().deserialize(configType, asStream);
                return (V)uow.toEntity(configType, configObject);
            }
            return null;
        }
    }
}

