/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.constraint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;

public class ConstraintViolationException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    private final Collection<ConstraintViolation> constraintViolations;
    private String methodName;
    private String mixinTypeName;
    private String instanceToString;
    private Iterable<Class<?>> instanceTypes;

    public ConstraintViolationException(Composite instance, Member method, Collection<ConstraintViolation> constraintViolations) {
        this(instance.toString(), ((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)instance)).types(), method, constraintViolations);
    }

    public ConstraintViolationException(String instanceToString, Iterable<Class<?>> instanceTypes, Member method, Collection<ConstraintViolation> violations) {
        this.instanceToString = instanceToString;
        this.instanceTypes = instanceTypes;
        this.mixinTypeName = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        this.constraintViolations = violations;
    }

    public ConstraintViolationException(String instanceToString, Iterable<Class<?>> instanceTypes, String mixinTypeName, String methodName, Collection<ConstraintViolation> violations) {
        this.instanceToString = instanceToString;
        this.instanceTypes = instanceTypes;
        this.mixinTypeName = mixinTypeName;
        this.methodName = methodName;
        this.constraintViolations = violations;
    }

    public Collection<ConstraintViolation> constraintViolations() {
        return this.constraintViolations;
    }

    public String[] localizedMessagesFrom(ResourceBundle bundle) {
        String pattern = "Constraint violation in {0}.{1} for method ''{3}'' with constraint \"{4}({6})\", for value ''{5}''";
        ArrayList<String> list = new ArrayList<String>();
        for (ConstraintViolation violation : this.constraintViolations) {
            Locale locale;
            if (bundle != null) {
                try {
                    pattern = bundle.getString("qi4j.constraint." + this.mixinTypeName + "." + this.methodName);
                }
                catch (MissingResourceException e1) {
                    try {
                        pattern = bundle.getString("qi4j.constraint");
                    }
                    catch (MissingResourceException e2) {
                        // empty catch block
                    }
                }
                locale = bundle.getLocale();
            } else {
                locale = Locale.getDefault();
            }
            MessageFormat format = new MessageFormat(pattern, locale);
            Annotation annotation = violation.constraint();
            String name = violation.name();
            Object value = violation.value();
            String classes = Iterables.count(this.instanceTypes) == 1L ? ((Class)Iterables.first(this.instanceTypes)).getSimpleName() : "[" + Iterables.toString(this.instanceTypes, (Function)new Function<Class<?>, String>(){

                public String map(Class<?> from) {
                    return from.getSimpleName();
                }
            }, (String)",") + "]";
            Object[] args = new Object[]{this.instanceToString, classes, this.mixinTypeName, this.methodName, annotation.toString(), "" + value, name};
            StringBuffer text = new StringBuffer();
            format.format(args, text, (FieldPosition)null);
            list.add(text.toString());
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public String localizedMessage() {
        String[] messages = this.localizedMessagesFrom(null);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String message : messages) {
            if (!first) {
                result.append(',');
            }
            first = false;
            result.append(message);
        }
        return result.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.localizedMessage();
    }

    @Override
    public String getMessage() {
        return this.localizedMessage();
    }

    public String methodName() {
        return this.methodName;
    }

    public String mixinTypeName() {
        return this.mixinTypeName;
    }
}

