/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.property;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class DefaultValues {
    private static final Map<Type, Object> DEFAULT_VALUES = new HashMap<Type, Object>();

    public static Object getDefaultValueOf(Type type) {
        Object value = DEFAULT_VALUES.get(type);
        if (value != null) {
            return value;
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            Class typeAsClass = (Class)type;
            if (Set.class.isAssignableFrom(typeAsClass)) {
                return new HashSet();
            }
            if (Map.class.isAssignableFrom(typeAsClass)) {
                return new LinkedHashMap();
            }
            if (Collection.class.isAssignableFrom(typeAsClass)) {
                return new ArrayList();
            }
            if (typeAsClass.isEnum()) {
                return ((Class)type).getEnumConstants()[0];
            }
        }
        throw new IllegalArgumentException("Cannot use @UseDefaults with type " + type.toString());
    }

    static {
        DEFAULT_VALUES.put((Type)((Object)Byte.class), 0);
        DEFAULT_VALUES.put((Type)((Object)Short.class), 0);
        DEFAULT_VALUES.put((Type)((Object)Character.class), 0);
        DEFAULT_VALUES.put((Type)((Object)Integer.class), 0);
        DEFAULT_VALUES.put((Type)((Object)Long.class), 0L);
        DEFAULT_VALUES.put((Type)((Object)Double.class), 0.0);
        DEFAULT_VALUES.put((Type)((Object)Float.class), Float.valueOf(0.0f));
        DEFAULT_VALUES.put((Type)((Object)Boolean.class), false);
        DEFAULT_VALUES.put((Type)((Object)String.class), "");
    }
}

