/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.qi4j.api.entity.Queryable;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.query.QueryException;
import org.qi4j.api.util.Classes;

public class NotQueryableException
extends QueryException {
    private static final long serialVersionUID = 1L;

    public NotQueryableException(String message) {
        super(message);
    }

    public static void throwIfNotQueryable(AccessibleObject accessor) {
        Queryable queryable = accessor.getAnnotation(Queryable.class);
        if (queryable != null && !queryable.value()) {
            throw new NotQueryableException(String.format("%1$s \"%2$s\" (%3$s) is not queryable as has been marked with @Queryable(false)", ((Class)Classes.RAW_CLASS.map((Object)GenericPropertyInfo.propertyTypeOf(accessor))).getSimpleName(), ((Member)((Object)accessor)).getName(), ((Member)((Object)accessor)).getDeclaringClass().getName()));
        }
    }

    public static void throwIfNotQueryable(Class<?> type) {
        Queryable queryable = type.getAnnotation(Queryable.class);
        if (queryable != null && !queryable.value()) {
            throw new NotQueryableException(String.format("Type \"%1$s\" is not queryable as has been marked with @Queryable(false)", type.getName()));
        }
    }
}

