/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query.grammar;

import java.util.Collection;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.query.grammar.ExpressionSpecification;
import org.qi4j.api.query.grammar.PropertyFunction;

public class ContainsSpecification<T>
extends ExpressionSpecification {
    private PropertyFunction<? extends Collection<T>> collectionProperty;
    private T value;

    public ContainsSpecification(PropertyFunction<? extends Collection<T>> collectionProperty, T value) {
        this.collectionProperty = collectionProperty;
        this.value = value;
    }

    public PropertyFunction<? extends Collection<T>> collectionProperty() {
        return this.collectionProperty;
    }

    public T value() {
        return this.value;
    }

    public boolean satisfiedBy(Composite item) {
        Collection<T> collection = this.collectionProperty.map(item).get();
        if (collection == null) {
            return false;
        }
        return collection.contains(this.value);
    }

    public String toString() {
        return this.collectionProperty + " contains " + this.value;
    }
}

