/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query.grammar;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.qi4j.api.association.Association;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.NotQueryableException;
import org.qi4j.api.query.QueryExpressionException;
import org.qi4j.api.query.grammar.AssociationFunction;
import org.qi4j.api.query.grammar.ManyAssociationFunction;
import org.qi4j.api.query.grammar.NamedAssociationFunction;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;

public class PropertyFunction<T>
implements Function<Composite, Property<T>> {
    private final PropertyFunction<?> traversedProperty;
    private final AssociationFunction<?> traversedAssociation;
    private final ManyAssociationFunction<?> traversedManyAssociation;
    private final NamedAssociationFunction<?> traversedNamedAssociation;
    private final AccessibleObject accessor;

    public PropertyFunction(PropertyFunction<?> traversedProperty, AssociationFunction<?> traversedAssociation, ManyAssociationFunction<?> traversedManyAssociation, NamedAssociationFunction<?> traversedNamedAssociation, AccessibleObject accessor) {
        this.traversedProperty = traversedProperty;
        this.traversedAssociation = traversedAssociation;
        this.traversedManyAssociation = traversedManyAssociation;
        this.traversedNamedAssociation = traversedNamedAssociation;
        this.accessor = accessor;
        NotQueryableException.throwIfNotQueryable(accessor);
        Type returnType = Classes.typeOf(accessor);
        if (!Property.class.isAssignableFrom((Class)Classes.RAW_CLASS.map((Object)returnType))) {
            throw new QueryExpressionException("Not a property type:" + returnType);
        }
        Type propertyTypeAsType = GenericPropertyInfo.toPropertyType(returnType);
        if (propertyTypeAsType instanceof ParameterizedType) {
            propertyTypeAsType = ((ParameterizedType)propertyTypeAsType).getRawType();
        }
        if (!(propertyTypeAsType instanceof Class)) {
            throw new QueryExpressionException("Unsupported property type:" + propertyTypeAsType);
        }
        Class type = (Class)propertyTypeAsType;
        NotQueryableException.throwIfNotQueryable(type);
    }

    public PropertyFunction<?> traversedProperty() {
        return this.traversedProperty;
    }

    public AssociationFunction<?> traversedAssociation() {
        return this.traversedAssociation;
    }

    public ManyAssociationFunction<?> traversedManyAssociation() {
        return this.traversedManyAssociation;
    }

    public NamedAssociationFunction<?> traversedNamedAssociation() {
        return this.traversedNamedAssociation;
    }

    public AccessibleObject accessor() {
        return this.accessor;
    }

    public Property<T> map(Composite entity) {
        try {
            Composite target = entity;
            if (this.traversedProperty != null) {
                Property<?> property = this.traversedProperty.map(entity);
                if (property == null) {
                    return null;
                }
                target = property.get();
            } else if (this.traversedAssociation != null) {
                Association<?> association = this.traversedAssociation.map(entity);
                if (association == null) {
                    return null;
                }
                target = association.get();
            } else {
                if (this.traversedManyAssociation != null) {
                    throw new IllegalArgumentException("Cannot evaluate a ManyAssociation");
                }
                if (this.traversedNamedAssociation != null) {
                    throw new IllegalArgumentException("Cannot evaluate a NamedAssociation");
                }
            }
            if (target == null) {
                return null;
            }
            CompositeInstance handler = (CompositeInstance)Proxy.getInvocationHandler(target);
            return handler.state().propertyFor(this.accessor);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        if (this.traversedProperty != null) {
            return this.traversedProperty.toString() + "." + ((Member)((Object)this.accessor)).getName();
        }
        if (this.traversedAssociation != null) {
            return this.traversedAssociation.toString() + "." + ((Member)((Object)this.accessor)).getName();
        }
        return ((Member)((Object)this.accessor)).getName();
    }
}

