/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.service.importer;

import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceFinder;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.service.ServiceReference;

public class ServiceInstanceImporter<T>
implements ServiceImporter<T> {
    @Structure
    ServiceFinder finder;
    ServiceImporter<T> service;
    String serviceId;

    @Override
    public T importService(ImportedServiceDescriptor importedServiceDescriptor) throws ServiceImporterException {
        this.serviceId = importedServiceDescriptor.metaInfo(String.class);
        return this.serviceImporter().importService(importedServiceDescriptor);
    }

    @Override
    public boolean isAvailable(T instance) {
        return this.serviceImporter().isAvailable(instance);
    }

    private ServiceImporter<T> serviceImporter() {
        if (this.service == null) {
            for (ServiceReference<ServiceImporter> reference : this.finder.findServices(ServiceImporter.class)) {
                if (!reference.identity().equals(this.serviceId)) continue;
                this.service = reference.get();
                break;
            }
        }
        if (this.service == null) {
            throw new ServiceImporterException("No service importer with id '" + this.serviceId + "' was found");
        }
        return this.service;
    }
}

