/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.service.importer;

import java.util.ArrayList;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.Availability;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceFinder;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.ServiceQualifier;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;

public final class ServiceSelectorImporter<T>
implements ServiceImporter<T> {
    @Structure
    private ServiceFinder locator;

    @Override
    public T importService(ImportedServiceDescriptor serviceDescriptor) throws ServiceImporterException {
        Specification selector = serviceDescriptor.metaInfo(Specification.class);
        Class serviceType = (Class)Iterables.first(serviceDescriptor.types());
        Iterable services = this.locator.findServices(serviceType);
        ArrayList filteredServices = new ArrayList();
        for (ServiceReference<Specification> serviceReference : services) {
            Specification selector1 = serviceReference.metaInfo(Specification.class);
            if (selector1 != null && selector1 == selector) continue;
            filteredServices.add(serviceReference);
        }
        Object service = ServiceQualifier.firstService(selector, filteredServices);
        if (service == null) {
            throw new ServiceImporterException("Could not find any service to import that matches the given specification for " + serviceDescriptor.identity());
        }
        return service;
    }

    @Override
    public boolean isAvailable(T instance) {
        return !(instance instanceof Availability) || ((Availability)instance).isAvailable();
    }
}

