/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.service.qualifier;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.AnnotationQualifier;
import org.qi4j.api.service.qualifier.Qualifier;
import org.qi4j.functional.Specification;

@Retention(value=RetentionPolicy.RUNTIME)
@Qualifier(value=HasMetaInfoQualifier.class)
@Documented
public @interface HasMetaInfo {
    public Class[] value();

    public boolean anded() default false;

    public static class HasMetaInfoQualifier
    implements AnnotationQualifier<HasMetaInfo> {
        @Override
        public <T> Specification<ServiceReference<?>> qualifier(final HasMetaInfo hasMetaInfo) {
            return new Specification<ServiceReference<?>>(){

                public boolean satisfiedBy(ServiceReference<?> service) {
                    for (Class metaInfoType : hasMetaInfo.value()) {
                        Object metaInfo = service.metaInfo(metaInfoType);
                        if (hasMetaInfo.anded()) {
                            if (metaInfo != null) continue;
                            return false;
                        }
                        if (metaInfo == null) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

