/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.service.qualifier;

import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.ServiceTags;
import org.qi4j.functional.Specification;

public abstract class ServiceQualifier {
    public static <T> T firstService(Specification<ServiceReference<?>> qualifier, Iterable<ServiceReference<T>> services) {
        for (ServiceReference<T> service : services) {
            if (!qualifier.satisfiedBy(service)) continue;
            return service.get();
        }
        return null;
    }

    public static Specification<ServiceReference<?>> withId(final String anId) {
        return new Specification<ServiceReference<?>>(){

            public boolean satisfiedBy(ServiceReference<?> service) {
                return service.identity().equals(anId);
            }
        };
    }

    public static Specification<ServiceReference<?>> whereMetaInfoIs(final Object metaInfo) {
        return new Specification<ServiceReference<?>>(){

            public boolean satisfiedBy(ServiceReference<?> service) {
                Object metaObject = service.metaInfo(metaInfo.getClass());
                return metaObject != null && metaInfo.equals(metaObject);
            }
        };
    }

    public static Specification<ServiceReference<?>> whereActive() {
        return new Specification<ServiceReference<?>>(){

            public boolean satisfiedBy(ServiceReference<?> service) {
                return service.isActive();
            }
        };
    }

    public static Specification<ServiceReference<?>> whereAvailable() {
        return new Specification<ServiceReference<?>>(){

            public boolean satisfiedBy(ServiceReference<?> service) {
                return service.isAvailable();
            }
        };
    }

    public static Specification<ServiceReference<?>> withTags(final String ... tags) {
        return new Specification<ServiceReference<?>>(){

            public boolean satisfiedBy(ServiceReference<?> service) {
                ServiceTags serviceTags = service.metaInfo(ServiceTags.class);
                return serviceTags != null && serviceTags.hasTags(tags);
            }
        };
    }
}

