/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.util.Classes;

public final class CollectionType
extends ValueType {
    private ValueType collectedType;

    public static boolean isCollection(Type type) {
        Class cl = (Class)Classes.RAW_CLASS.map((Object)type);
        return cl.equals(Collection.class) || cl.equals(List.class) || cl.equals(Set.class);
    }

    public static CollectionType collectionOf(Class<?> collectedType) {
        return new CollectionType(Collection.class, ValueType.of(collectedType));
    }

    public static CollectionType listOf(Class<?> collectedType) {
        return new CollectionType(List.class, ValueType.of(collectedType));
    }

    public static CollectionType setOf(Class<?> collectedType) {
        return new CollectionType(Set.class, ValueType.of(collectedType));
    }

    public CollectionType(Class<?> type, ValueType collectedType) {
        super(type);
        this.collectedType = collectedType;
        if (!CollectionType.isCollection(type)) {
            throw new IllegalArgumentException(type + " is not a Collection, List or Set.");
        }
    }

    public ValueType collectedType() {
        return this.collectedType;
    }

    @Override
    public String toString() {
        return super.toString() + "<" + this.collectedType + ">";
    }
}

