/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.type;

import java.lang.reflect.Type;
import java.util.Map;
import org.qi4j.api.type.Serialization;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.util.Classes;

public final class MapType
extends ValueType {
    private ValueType keyType;
    private ValueType valueType;
    private final Serialization.Variant variant;

    public static boolean isMap(Type type) {
        Class cl = (Class)Classes.RAW_CLASS.map((Object)type);
        return Map.class.isAssignableFrom(cl);
    }

    public static MapType of(Class<?> keyType, Class<?> valueType) {
        return new MapType(Map.class, ValueType.of(keyType), ValueType.of(valueType));
    }

    public static MapType of(Class<?> keyType, Class<?> valueType, Serialization.Variant variant) {
        return new MapType(Map.class, ValueType.of(keyType), ValueType.of(valueType), variant);
    }

    public MapType(Class<?> type, ValueType keyType, ValueType valueType) {
        this(type, keyType, valueType, Serialization.Variant.entry);
    }

    public MapType(Class<?> type, ValueType keyType, ValueType valueType, Serialization.Variant variant) {
        super(type);
        this.keyType = keyType;
        this.valueType = valueType;
        this.variant = variant;
        if (!MapType.isMap(type)) {
            throw new IllegalArgumentException(type + " is not a Map.");
        }
    }

    public ValueType keyType() {
        return this.keyType;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    public Serialization.Variant variant() {
        return this.variant;
    }

    @Override
    public String toString() {
        return super.toString() + "<" + this.keyType + "," + this.valueType + ">";
    }
}

