/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.unitofwork.concern;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.concern.GenericConcern;
import org.qi4j.api.injection.scope.Invocation;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.concern.UnitOfWorkDiscardOn;
import org.qi4j.api.unitofwork.concern.UnitOfWorkPropagation;
import org.qi4j.api.unitofwork.concern.UnitOfWorkRetry;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.usecase.UsecaseBuilder;

@AppliesTo(value={UnitOfWorkPropagation.class})
public class UnitOfWorkConcern
extends GenericConcern {
    private static final Class<?>[] DEFAULT_DISCARD_CLASSES = new Class[]{Throwable.class};
    @Structure
    Module module;
    @Invocation
    UnitOfWorkPropagation propagation;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        UnitOfWorkPropagation.Propagation propagationPolicy = this.propagation.value();
        if (propagationPolicy == UnitOfWorkPropagation.Propagation.REQUIRED) {
            if (this.module.isUnitOfWorkActive()) {
                return ((InvocationHandler)this.next).invoke(proxy, method, args);
            }
            Usecase usecase = this.usecase();
            return this.invokeWithCommit(proxy, method, args, this.module.newUnitOfWork(usecase));
        }
        if (propagationPolicy == UnitOfWorkPropagation.Propagation.MANDATORY) {
            if (!this.module.isUnitOfWorkActive()) {
                throw new IllegalStateException("UnitOfWork was required but there is no available unit of work.");
            }
        } else if (propagationPolicy == UnitOfWorkPropagation.Propagation.REQUIRES_NEW) {
            Usecase usecase = this.usecase();
            return this.invokeWithCommit(proxy, method, args, this.module.newUnitOfWork(usecase));
        }
        return ((InvocationHandler)this.next).invoke(proxy, method, args);
    }

    private Usecase usecase() {
        String usecaseName = this.propagation.usecase();
        Usecase usecase = usecaseName == null ? Usecase.DEFAULT : UsecaseBuilder.newUsecase(usecaseName);
        return usecase;
    }

    protected Object invokeWithCommit(Object proxy, Method method, Object[] args, UnitOfWork currentUnitOfWork) throws Throwable {
        try {
            UnitOfWorkRetry retryAnnot = method.getAnnotation(UnitOfWorkRetry.class);
            int maxTries = 0;
            long delayFactor = 0L;
            long initialDelay = 0L;
            if (retryAnnot != null) {
                maxTries = retryAnnot.retries();
                initialDelay = retryAnnot.initialDelay();
                delayFactor = retryAnnot.delayFactory();
            }
            int retry = 0;
            while (true) {
                Object result = ((InvocationHandler)this.next).invoke(proxy, method, args);
                try {
                    currentUnitOfWork.complete();
                    return result;
                }
                catch (ConcurrentEntityModificationException e) {
                    if (retry >= maxTries) {
                        throw e;
                    }
                    this.module.currentUnitOfWork().discard();
                    Thread.sleep(initialDelay + (long)retry * delayFactor);
                    ++retry;
                    currentUnitOfWork = this.module.newUnitOfWork(this.usecase());
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.discardIfRequired(method, currentUnitOfWork, throwable);
            throw throwable;
        }
    }

    protected void discardIfRequired(Method aMethod, UnitOfWork aUnitOfWork, Throwable aThrowable) {
        UnitOfWorkDiscardOn discardPolicy = aMethod.getAnnotation(UnitOfWorkDiscardOn.class);
        Class<Object>[] discardClasses = discardPolicy != null ? discardPolicy.value() : DEFAULT_DISCARD_CLASSES;
        Class<?> aThrowableClass = aThrowable.getClass();
        for (Class<Object> discardClass : discardClasses) {
            if (!discardClass.isAssignableFrom(aThrowableClass)) continue;
            aUnitOfWork.discard();
        }
    }
}

