/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class Dates {
    private static final ThreadLocal<DateFormat> ISO8601 = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private static final ThreadLocal<DateFormat> ISO8601_UTC = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };

    public static Date fromString(String stringDate) {
        try {
            Date date = ISO8601_UTC.get().parse(stringDate);
            return date;
        }
        catch (ParseException e) {
            try {
                Date date = ISO8601.get().parse(stringDate);
                return date;
            }
            catch (ParseException e1) {
                if (stringDate.startsWith("@") && stringDate.endsWith("@")) {
                    long time = Long.parseLong(stringDate.substring(1, stringDate.length() - 1));
                    Date date = new Date(time);
                    return date;
                }
                if (stringDate.startsWith("/Date(") && stringDate.endsWith(")/")) {
                    long time = Long.parseLong(stringDate.substring(6, stringDate.length() - 2));
                    Date date = new Date(time);
                    return date;
                }
                throw new IllegalStateException("Illegal date:" + stringDate);
            }
        }
    }

    public static String toUtcString(Date date) {
        return ISO8601_UTC.get().format(date);
    }

    private Dates() {
    }
}

