/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.value;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.functional.Function;

public interface ValueSerializer {
    public <T> Function<T, String> serialize();

    public <T> Function<T, String> serialize(Options var1);

    @Deprecated
    public <T> Function<T, String> serialize(boolean var1);

    public String serialize(Object var1) throws ValueSerializationException;

    public String serialize(Options var1, Object var2) throws ValueSerializationException;

    @Deprecated
    public String serialize(Object var1, boolean var2) throws ValueSerializationException;

    public void serialize(Object var1, OutputStream var2) throws ValueSerializationException;

    public void serialize(Options var1, Object var2, OutputStream var3) throws ValueSerializationException;

    @Deprecated
    public void serialize(Object var1, OutputStream var2, boolean var3) throws ValueSerializationException;

    public static final class Options {
        public static final String INCLUDE_TYPE_INFO = "includeTypeInfo";
        public static final String MAP_ENTRIES_AS_OBJECTS = "mapentriesasobjects";
        private final Map<String, String> options = new HashMap<String, String>();

        public Options() {
            this.options.put(INCLUDE_TYPE_INFO, "true");
            this.options.put(MAP_ENTRIES_AS_OBJECTS, "false");
        }

        public Options withTypeInfo() {
            return this.put(INCLUDE_TYPE_INFO, true);
        }

        public Options withoutTypeInfo() {
            return this.put(INCLUDE_TYPE_INFO, false);
        }

        public Options withMapEntriesAsObjects() {
            return this.put(MAP_ENTRIES_AS_OBJECTS, true);
        }

        public Options withMapEntriesAsKeyValuePairs() {
            return this.put(MAP_ENTRIES_AS_OBJECTS, false);
        }

        public Boolean getBoolean(String option) {
            if (!this.options.containsKey(option)) {
                return null;
            }
            return Boolean.valueOf(this.options.get(option));
        }

        public Integer getInteger(String option) {
            if (!this.options.containsKey(option)) {
                return null;
            }
            return Integer.valueOf(this.options.get(option));
        }

        public String getString(String option) {
            return this.options.get(option);
        }

        public Options put(String option, String value) {
            if (value == null) {
                return this.remove(option);
            }
            this.options.put(option, value);
            return this;
        }

        public Options put(String option, Boolean value) {
            if (value == null) {
                return this.remove(option);
            }
            this.options.put(option, Boolean.toString(value));
            return this;
        }

        public Options put(String option, Integer value) {
            if (value == null) {
                return this.remove(option);
            }
            this.options.put(option, value.toString());
            return this;
        }

        public Options remove(String option) {
            this.options.remove(option);
            return this;
        }

        public Map<String, String> toMap() {
            return new HashMap<String, String>(this.options);
        }
    }
}

